/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.dataset;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataset.IDatasetManager;
import org.apache.hyracks.api.job.JobId;

public class ResultStateSweeper
implements Runnable {
    private final IDatasetManager datasetManager;
    private final long resultTTL;
    private final long resultSweepThreshold;
    private final Logger logger;
    private final List<JobId> toBeCollected;

    public ResultStateSweeper(IDatasetManager datasetManager, long resultTTL, long resultSweepThreshold, Logger logger) {
        this.datasetManager = datasetManager;
        this.resultTTL = resultTTL;
        this.resultSweepThreshold = resultSweepThreshold;
        this.logger = logger;
        this.toBeCollected = new ArrayList<JobId>();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(this.resultSweepThreshold);
                this.sweep();
            }
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "Result cleaner thread interrupted, shutting down.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep() {
        IDatasetManager iDatasetManager = this.datasetManager;
        synchronized (iDatasetManager) {
            this.toBeCollected.clear();
            for (JobId jobId : this.datasetManager.getJobIds()) {
                long timestamp = this.datasetManager.getResultTimestamp(jobId);
                if (timestamp == -1L || System.currentTimeMillis() <= timestamp + this.resultTTL) continue;
                this.toBeCollected.add(jobId);
            }
            for (JobId jobId : this.toBeCollected) {
                this.datasetManager.deinitState(jobId);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Result state cleanup instance successfully completed.");
        }
    }
}

