/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.rewrites;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.parser.AQLParserFactory;
import org.apache.asterix.lang.aql.parser.FunctionParser;
import org.apache.asterix.lang.aql.rewrites.AQLRewriterFactory;
import org.apache.asterix.lang.aql.rewrites.visitor.AqlBuiltinFunctionRewriteVisitor;
import org.apache.asterix.lang.aql.visitor.AQLInlineUdfsVisitor;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.CommonFunctionMapUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.GatherFunctionCallsVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;

class AqlQueryRewriter
implements IQueryRewriter {
    private final FunctionParser functionParser = new FunctionParser(new AQLParserFactory());
    private IReturningStatement topStatement;
    private List<FunctionDecl> declaredFunctions;
    private LangRewritingContext context;
    private MetadataProvider metadataProvider;

    AqlQueryRewriter() {
    }

    private void setup(List<FunctionDecl> declaredFunctions, IReturningStatement topStatement, MetadataProvider metadataProvider, LangRewritingContext context) {
        this.topStatement = topStatement;
        this.context = context;
        this.declaredFunctions = declaredFunctions;
        this.metadataProvider = metadataProvider;
    }

    public void rewrite(List<FunctionDecl> declaredFunctions, IReturningStatement topStatement, MetadataProvider metadataProvider, LangRewritingContext context) throws CompilationException {
        this.setup(declaredFunctions, topStatement, metadataProvider, context);
        if (topStatement.isTopLevel()) {
            this.wrapInLets();
        }
        this.inlineDeclaredUdfs();
        this.rewriteFunctionName();
        topStatement.setVarCounter(context.getVarCounter());
    }

    private void wrapInLets() {
        if (this.topStatement == null) {
            return;
        }
        Expression body = this.topStatement.getBody();
        if (body.getKind() != Expression.Kind.FLWOGR_EXPRESSION) {
            VarIdentifier var = this.context.newVariable();
            VariableExpr v = new VariableExpr(var);
            LetClause c1 = new LetClause(v, body);
            ArrayList<Clause> clauseList = new ArrayList<Clause>(1);
            clauseList.add((Clause)c1);
            FLWOGRExpression newBody = new FLWOGRExpression(clauseList, (Expression)new VariableExpr(var));
            this.topStatement.setBody((Expression)newBody);
        }
    }

    private void rewriteFunctionName() throws CompilationException {
        if (this.topStatement == null) {
            return;
        }
        AqlBuiltinFunctionRewriteVisitor visitor = new AqlBuiltinFunctionRewriteVisitor();
        this.topStatement.accept((ILangVisitor)visitor, null);
    }

    private void inlineDeclaredUdfs() throws CompilationException {
        if (this.topStatement == null) {
            return;
        }
        ArrayList<FunctionSignature> funIds = new ArrayList<FunctionSignature>();
        for (FunctionDecl functionDecl : this.declaredFunctions) {
            funIds.add(functionDecl.getSignature());
        }
        ArrayList storedFunctionDecls = new ArrayList();
        for (Expression topLevelExpr : this.topStatement.getDirectlyEnclosedExpressions()) {
            storedFunctionDecls.addAll(FunctionUtil.retrieveUsedStoredFunctions((MetadataProvider)this.metadataProvider, (Expression)topLevelExpr, funIds, null, expr -> this.getFunctionCalls(expr), func -> this.functionParser.getFunctionDecl(func), signature -> CommonFunctionMapUtil.normalizeBuiltinFunctionSignature((FunctionSignature)signature)));
            this.declaredFunctions.addAll(storedFunctionDecls);
        }
        if (!this.declaredFunctions.isEmpty()) {
            AQLInlineUdfsVisitor aQLInlineUdfsVisitor = new AQLInlineUdfsVisitor(this.context, new AQLRewriterFactory(), this.declaredFunctions, this.metadataProvider);
            while (((Boolean)this.topStatement.accept((ILangVisitor)aQLInlineUdfsVisitor, this.declaredFunctions)).booleanValue()) {
            }
        }
        this.declaredFunctions.removeAll(storedFunctionDecls);
    }

    private Set<FunctionSignature> getFunctionCalls(Expression expression) throws CompilationException {
        GatherFunctionCalls gfc = new GatherFunctionCalls();
        expression.accept((ILangVisitor)gfc, null);
        return gfc.getCalls();
    }

    private static class GatherFunctionCalls
    extends GatherFunctionCallsVisitor
    implements IAQLVisitor<Void, Void> {
        @Override
        public Void visit(DistinctClause dc, Void arg) throws CompilationException {
            for (Expression e : dc.getDistinctByExpr()) {
                e.accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        @Override
        public Void visit(FLWOGRExpression flwor, Void arg) throws CompilationException {
            for (Clause c : flwor.getClauseList()) {
                c.accept((ILangVisitor)this, (Object)arg);
            }
            flwor.getReturnExpr().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(ForClause fc, Void arg) throws CompilationException {
            fc.getInExpr().accept((ILangVisitor)this, (Object)arg);
            if (fc.getPosVarExpr() != null) {
                fc.getPosVarExpr().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        public Void visit(GroupbyClause gc, Void arg) throws CompilationException {
            for (GbyVariableExpressionPair p : gc.getGbyPairList()) {
                p.getExpr().accept((ILangVisitor)this, (Object)arg);
            }
            for (GbyVariableExpressionPair p : gc.getDecorPairList()) {
                p.getExpr().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        public Void visit(LetClause lc, Void arg) throws CompilationException {
            lc.getBindingExpr().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(UnionExpr u, Void arg) throws CompilationException {
            for (Expression e : u.getExprs()) {
                e.accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }
    }
}

