/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.expression;

import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class FLWOGRExpression
implements Expression {
    private List<Clause> clauseList;
    private Expression returnExpr;

    public FLWOGRExpression() {
    }

    public FLWOGRExpression(List<Clause> clauseList, Expression returnExpr) {
        this.clauseList = clauseList;
        this.returnExpr = returnExpr;
    }

    public List<Clause> getClauseList() {
        return this.clauseList;
    }

    public void setClauseList(List<Clause> clauseList) {
        this.clauseList = clauseList;
    }

    public Expression getReturnExpr() {
        return this.returnExpr;
    }

    public void setReturnExpr(Expression returnExpr) {
        this.returnExpr = returnExpr;
    }

    public Expression.Kind getKind() {
        return Expression.Kind.FLWOGR_EXPRESSION;
    }

    public boolean noForClause() {
        for (Clause c : this.clauseList) {
            if (c.getClauseType() != Clause.ClauseType.FOR_CLAUSE) continue;
            return false;
        }
        return true;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((IAQLVisitor)visitor).visit(this, arg);
    }
}

