/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.buffercache.VirtualPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.FileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.util.JSONUtil;

public class VirtualBufferCache
implements IVirtualBufferCache {
    private static final Logger LOGGER = Logger.getLogger(ExternalIndexHarness.class.getName());
    private static final int OVERFLOW_PADDING = 8;
    private final ICacheMemoryAllocator allocator;
    private final IFileMapManager fileMapManager;
    private final int pageSize;
    private final int numPages;
    private final CacheBucket[] buckets;
    private final ArrayList<VirtualPage> pages;
    private volatile int nextFree;
    private final AtomicInteger largePages;
    private boolean open;

    public VirtualBufferCache(ICacheMemoryAllocator allocator, int pageSize, int numPages) {
        this.allocator = allocator;
        this.fileMapManager = new FileMapManager();
        this.pageSize = pageSize;
        this.numPages = 2 * (numPages / 2) + 1;
        this.buckets = new CacheBucket[this.numPages];
        this.pages = new ArrayList();
        this.nextFree = 0;
        this.largePages = new AtomicInteger(0);
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createFile(FileReference fileRef) throws HyracksDataException {
        IFileMapManager iFileMapManager = this.fileMapManager;
        synchronized (iFileMapManager) {
            return this.fileMapManager.registerFile(fileRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openFile(FileReference fileRef) throws HyracksDataException {
        IFileMapManager iFileMapManager = this.fileMapManager;
        synchronized (iFileMapManager) {
            if (this.fileMapManager.isMapped(fileRef)) {
                return this.fileMapManager.lookupFileId(fileRef);
            }
            return this.fileMapManager.registerFile(fileRef);
        }
    }

    public void openFile(int fileId) throws HyracksDataException {
    }

    public void closeFile(int fileId) throws HyracksDataException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(FileReference fileRef) throws HyracksDataException {
        IFileMapManager iFileMapManager = this.fileMapManager;
        synchronized (iFileMapManager) {
            int fileId = this.fileMapManager.lookupFileId(fileRef);
            this.deleteFile(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(int fileId) throws HyracksDataException {
        IFileMapManager iFileMapManager = this.fileMapManager;
        synchronized (iFileMapManager) {
            this.fileMapManager.unregisterFile(fileId);
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            CacheBucket bucket = this.buckets[i];
            bucket.bucketLock.lock();
            try {
                VirtualPage prev = null;
                VirtualPage curr = bucket.cachedPage;
                while (curr != null) {
                    if (BufferedFileHandle.getFileId((long)curr.dpid()) == fileId) {
                        if (curr.getFrameSizeMultiplier() > 1) {
                            this.largePages.getAndAdd(-curr.getFrameSizeMultiplier());
                        }
                        if (prev == null) {
                            bucket.cachedPage = curr.next();
                            curr.reset();
                            curr = bucket.cachedPage;
                            continue;
                        }
                        prev.next(curr.next());
                        curr.reset();
                        curr = prev.next();
                        continue;
                    }
                    prev = curr;
                    curr = curr.next();
                }
                continue;
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
        this.defragPageList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defragPageList() {
        ArrayList<VirtualPage> arrayList = this.pages;
        synchronized (arrayList) {
            int end = this.nextFree - 1;
            for (int start = 0; start < end; ++start) {
                VirtualPage lastUsed = this.pages.get(end);
                while (end > 0 && lastUsed.dpid() == -1L) {
                    lastUsed = this.pages.get(--end);
                }
                if (end == 0) {
                    this.nextFree = lastUsed.dpid() == -1L ? 0 : 1;
                    break;
                }
                VirtualPage firstUnused = this.pages.get(start);
                while (start < end && firstUnused.dpid() != -1L) {
                    firstUnused = this.pages.get(++start);
                }
                if (start >= end) break;
                Collections.swap(this.pages, start, end);
                this.nextFree = end--;
            }
        }
    }

    public ICachedPage tryPin(long dpid) throws HyracksDataException {
        return this.pin(dpid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        VirtualPage page = null;
        int hash = this.hash(dpid);
        CacheBucket bucket = this.buckets[hash];
        bucket.bucketLock.lock();
        try {
            for (page = bucket.cachedPage; page != null; page = page.next()) {
                if (page.dpid() != dpid) continue;
                VirtualPage virtualPage = page;
                return virtualPage;
            }
            if (!newPage) {
                IFileMapManager iFileMapManager = this.fileMapManager;
                synchronized (iFileMapManager) {
                    throw new HyracksDataException("Page " + BufferedFileHandle.getPageId((long)dpid) + " does not exist in file " + this.fileMapManager.lookupFileName(BufferedFileHandle.getFileId((long)dpid)));
                }
            }
            page = this.getOrAllocPage(dpid);
            page.next(bucket.cachedPage);
            bucket.cachedPage = page;
        }
        finally {
            bucket.bucketLock.unlock();
        }
        return page;
    }

    private int hash(long dpid) {
        int hashValue = (int)dpid ^ Integer.reverse((int)(dpid >>> 32)) >>> 1;
        return hashValue % this.buckets.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualPage getOrAllocPage(long dpid) {
        VirtualPage page;
        ArrayList<VirtualPage> arrayList = this.pages;
        synchronized (arrayList) {
            if (this.nextFree >= this.pages.size()) {
                page = new VirtualPage(this.allocator.allocate(this.pageSize, 1)[0], this.pageSize);
                page.multiplier(1);
                this.pages.add(page);
            } else {
                page = this.pages.get(this.nextFree);
            }
            ++this.nextFree;
            page.dpid(dpid);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizePage(ICachedPage cPage, int multiplier, IExtraPageBlockHelper extraPageBlockHelper) {
        ByteBuffer oldBuffer = cPage.getBuffer();
        int origMultiplier = cPage.getFrameSizeMultiplier();
        if (origMultiplier == multiplier) {
            return;
        }
        if (origMultiplier == 1) {
            ArrayList<VirtualPage> arrayList = this.pages;
            synchronized (arrayList) {
                this.pages.remove(cPage);
                --this.nextFree;
            }
        }
        ByteBuffer newBuffer = this.allocator.allocate(this.pageSize * multiplier, 1)[0];
        oldBuffer.position(0);
        if (multiplier < origMultiplier) {
            oldBuffer.limit(newBuffer.capacity());
        }
        newBuffer.put(oldBuffer);
        if (origMultiplier == 1) {
            this.largePages.getAndAdd(multiplier);
        } else if (multiplier == 1) {
            this.largePages.getAndAdd(-origMultiplier);
            this.pages.add(0, (VirtualPage)cPage);
            ++this.nextFree;
        } else {
            this.largePages.getAndAdd(multiplier - origMultiplier);
        }
        ((VirtualPage)cPage).buffer(newBuffer);
        ((VirtualPage)cPage).multiplier(multiplier);
    }

    public void unpin(ICachedPage page) throws HyracksDataException {
    }

    public void flushDirtyPage(ICachedPage page) throws HyracksDataException {
    }

    public void force(int fileId, boolean metadata) throws HyracksDataException {
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageSizeWithHeader() {
        return this.pageSize;
    }

    public int getNumPages() {
        return this.numPages;
    }

    @Override
    public void open() throws HyracksDataException {
        if (this.open) {
            throw new HyracksDataException("Failed to open virtual buffercache since it is already open.");
        }
        this.pages.trimToSize();
        this.pages.ensureCapacity(this.numPages + 8);
        this.allocator.reserveAllocation(this.pageSize, this.numPages);
        for (int i = 0; i < this.numPages; ++i) {
            this.buckets[i] = new CacheBucket();
        }
        this.nextFree = 0;
        this.largePages.set(0);
        this.open = true;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.numPages; ++i) {
            this.buckets[i].cachedPage = null;
        }
        int excess = this.pages.size() - this.numPages;
        if (excess > 0) {
            for (int i = this.numPages + excess - 1; i >= this.numPages; --i) {
                this.pages.remove(i);
            }
        }
        this.nextFree = 0;
        this.largePages.set(0);
    }

    public void close() throws HyracksDataException {
        if (!this.open) {
            throw new HyracksDataException("Failed to close virtual buffercache since it is already closed.");
        }
        this.pages.clear();
        for (int i = 0; i < this.numPages; ++i) {
            this.buckets[i].cachedPage = null;
        }
        this.open = false;
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Page size = %d\n", this.pageSize));
        sb.append(String.format("Capacity = %d\n", this.numPages));
        sb.append(String.format("Allocated pages = %d\n", this.pages.size()));
        sb.append(String.format("Allocated large pages = %d\n", this.largePages.get()));
        sb.append(String.format("Next free page = %d\n", this.nextFree));
        return sb.toString();
    }

    @Override
    public IFileMapManager getFileMapProvider() {
        return this.fileMapManager;
    }

    @Override
    public boolean isFull() {
        return this.nextFree + this.largePages.get() >= this.numPages;
    }

    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        return -1;
    }

    public void adviseWontNeed(ICachedPage page) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Calling adviseWontNeed on " + this.getClass().getName() + " makes no sense as this BufferCache cannot evict pages");
        }
    }

    public void returnPage(ICachedPage page) {
    }

    public IFIFOPageQueue createFIFOQueue() {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public void finishQueue() {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public void setPageDiskId(ICachedPage page, long dpid) {
    }

    public void returnPage(ICachedPage page, boolean reinsert) {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public int getFileReferenceCount(int fileId) {
        return 0;
    }

    public boolean isReplicationEnabled() {
        return false;
    }

    public IIOReplicationManager getIOReplicationManager() {
        return null;
    }

    public void purgeHandle(int fileId) throws HyracksDataException {
        this.deleteFile(fileId);
    }

    public String toString() {
        return JSONUtil.fromMap(this.toMap());
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("class", this.getClass().getSimpleName());
        map.put("allocator", this.allocator.toString());
        map.put("pageSize", this.pageSize);
        map.put("numPages", this.numPages);
        map.put("open", this.open);
        return map;
    }

    private static class CacheBucket {
        private final ReentrantLock bucketLock = new ReentrantLock();
        private VirtualPage cachedPage;
    }
}

