/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;

public class MemoryComponentMetadata
implements IComponentMetadata {
    private static final byte[] empty = new byte[0];
    private final List<Pair<IValueReference, ArrayBackedValueStorage>> store = new ArrayList<Pair<IValueReference, ArrayBackedValueStorage>>();

    @Override
    public void put(IValueReference key, IValueReference value) {
        ArrayBackedValueStorage stored = this.get(key);
        if (stored == null) {
            stored = new ArrayBackedValueStorage();
        }
        stored.assign(value);
        this.store.add((Pair<IValueReference, ArrayBackedValueStorage>)Pair.of((Object)key, (Object)stored));
    }

    @Override
    public void get(IValueReference key, IPointable value) {
        value.set(empty, 0, 0);
        ArrayBackedValueStorage stored = this.get(key);
        if (stored != null) {
            value.set((IValueReference)stored);
        }
    }

    public ArrayBackedValueStorage get(IValueReference key) {
        for (Pair<IValueReference, ArrayBackedValueStorage> pair : this.store) {
            if (!((IValueReference)pair.getKey()).equals(key)) continue;
            return (ArrayBackedValueStorage)pair.getValue();
        }
        return null;
    }

    public void copy(IMetadataPageManager mdpManager) throws HyracksDataException {
        ITreeIndexMetadataFrame frame = mdpManager.createMetadataFrame();
        for (Pair<IValueReference, ArrayBackedValueStorage> pair : this.store) {
            mdpManager.put(frame, (IValueReference)pair.getKey(), (IValueReference)pair.getValue());
        }
    }

    public void copy(DiskComponentMetadata metadata) throws HyracksDataException {
        metadata.put(this);
    }

    public void reset() {
        this.store.clear();
    }
}

