/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Objects;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractIoOperation;

public class FlushOperation
extends AbstractIoOperation
implements Comparable<FlushOperation> {
    protected final ILSMMemoryComponent flushingComponent;

    public FlushOperation(ILSMIndexAccessor accessor, ILSMMemoryComponent flushingComponent, FileReference target, ILSMIOOperationCallback callback, String indexIdentifier) {
        super(accessor, target, callback, indexIdentifier);
        this.flushingComponent = flushingComponent;
    }

    @Override
    public Boolean call() throws HyracksDataException {
        this.accessor.flush(this);
        return true;
    }

    @Override
    public ILSMIOOperationCallback getCallback() {
        return this.callback;
    }

    @Override
    public FileReference getTarget() {
        return this.target;
    }

    @Override
    public ILSMIndexAccessor getAccessor() {
        return this.accessor;
    }

    public ILSMComponent getFlushingComponent() {
        return this.flushingComponent;
    }

    @Override
    public String getIndexIdentifier() {
        return this.indexIdentifier;
    }

    @Override
    public ILSMIOOperation.LSMIOOpertionType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOpertionType.FLUSH;
    }

    @Override
    public int compareTo(FlushOperation o) {
        return this.target.getFile().getName().compareTo(o.getTarget().getFile().getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlushOperation)) {
            return false;
        }
        return Objects.equals(this.target.getFile().getName(), ((FlushOperation)o).target.getFile().getName());
    }

    public int hashCode() {
        return this.target.getFile().getName().hashCode();
    }
}

