/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class AbstractLSMIndexOperationContext
implements ILSMIndexOperationContext {
    protected final PermutingTupleReference indexTuple;
    protected final MultiComparator filterCmp;
    protected final PermutingTupleReference filterTuple;
    protected final int[] allFields;
    protected final List<ILSMComponent> componentHolder;
    protected final List<ILSMDiskComponent> componentsToBeMerged;
    protected final List<ILSMDiskComponent> componentsToBeReplicated;
    protected final ISearchOperationCallback searchCallback;
    protected final IModificationOperationCallback modificationCallback;
    protected IndexOperation op;
    protected boolean accessingComponents = false;
    protected ISearchPredicate searchPredicate;

    public AbstractLSMIndexOperationContext(int[] treeFields, int[] filterFields, IBinaryComparatorFactory[] filterCmpFactories, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) {
        this.searchCallback = searchCallback;
        this.modificationCallback = modificationCallback;
        this.componentHolder = new LinkedList<ILSMComponent>();
        this.componentsToBeMerged = new LinkedList<ILSMDiskComponent>();
        this.componentsToBeReplicated = new LinkedList<ILSMDiskComponent>();
        if (filterFields != null) {
            int i;
            this.indexTuple = new PermutingTupleReference(treeFields);
            this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])filterCmpFactories);
            this.filterTuple = new PermutingTupleReference(filterFields);
            this.allFields = new int[treeFields.length + filterFields.length];
            for (i = 0; i < treeFields.length; ++i) {
                this.allFields[i] = treeFields[i];
            }
            for (i = treeFields.length; i < treeFields.length + filterFields.length; ++i) {
                this.allFields[i] = filterFields[i - treeFields.length];
            }
        } else {
            this.indexTuple = null;
            this.filterCmp = null;
            this.filterTuple = null;
            this.allFields = null;
        }
    }

    @Override
    public boolean isAccessingComponents() {
        return this.accessingComponents;
    }

    @Override
    public void setAccessingComponents(boolean accessingComponents) {
        this.accessingComponents = accessingComponents;
    }

    @Override
    public final PermutingTupleReference getIndexTuple() {
        return this.indexTuple;
    }

    @Override
    public final PermutingTupleReference getFilterTuple() {
        return this.filterTuple;
    }

    @Override
    public final MultiComparator getFilterCmp() {
        return this.filterCmp;
    }

    public void reset() {
        this.accessingComponents = false;
        this.componentHolder.clear();
        this.componentsToBeMerged.clear();
        this.componentsToBeReplicated.clear();
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    @Override
    public List<ILSMComponent> getComponentHolder() {
        return this.componentHolder;
    }

    @Override
    public ISearchOperationCallback getSearchOperationCallback() {
        return this.searchCallback;
    }

    @Override
    public IModificationOperationCallback getModificationCallback() {
        return this.modificationCallback;
    }

    @Override
    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return this.componentsToBeMerged;
    }

    @Override
    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return this.componentsToBeReplicated;
    }

    public void setOperation(IndexOperation newOp) throws HyracksDataException {
        this.reset();
        this.op = newOp;
    }

    @Override
    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    @Override
    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }
}

