/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.impls.AbstractSearchPredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexReplicationJob;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public abstract class AbstractLSMIndex
implements ILSMIndex {
    protected final ILSMHarness lsmHarness;
    protected final IIOManager ioManager;
    protected final ILSMIOOperationScheduler ioScheduler;
    protected final ILSMIOOperationCallback ioOpCallback;
    protected final List<ILSMMemoryComponent> memoryComponents;
    protected final List<IVirtualBufferCache> virtualBufferCaches;
    protected AtomicInteger currentMutableComponentId;
    protected final IBufferCache diskBufferCache;
    protected final ILSMIndexFileManager fileManager;
    protected final List<ILSMDiskComponent> diskComponents;
    protected final List<ILSMDiskComponent> inactiveDiskComponents;
    protected final double bloomFilterFalsePositiveRate;
    protected final IComponentFilterHelper filterHelper;
    protected final ILSMComponentFilterFrameFactory filterFrameFactory;
    protected final LSMComponentFilterManager filterManager;
    protected final int[] treeFields;
    protected final int[] filterFields;
    protected final boolean durable;
    protected boolean isActive;
    protected final AtomicBoolean[] flushRequests;
    protected boolean memoryComponentsAllocated = false;

    public AbstractLSMIndex(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int[] filterFields, boolean durable, IComponentFilterHelper filterHelper, int[] treeFields) {
        this.ioManager = ioManager;
        this.virtualBufferCaches = virtualBufferCaches;
        this.diskBufferCache = diskBufferCache;
        this.fileManager = fileManager;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.ioScheduler = ioScheduler;
        this.ioOpCallback = ioOpCallback;
        this.ioOpCallback.setNumOfMutableComponents(virtualBufferCaches.size());
        this.filterHelper = filterHelper;
        this.filterFrameFactory = filterFrameFactory;
        this.filterManager = filterManager;
        this.treeFields = treeFields;
        this.filterFields = filterFields;
        this.inactiveDiskComponents = new LinkedList<ILSMDiskComponent>();
        this.durable = durable;
        this.lsmHarness = new LSMHarness(this, mergePolicy, opTracker, diskBufferCache.isReplicationEnabled());
        this.isActive = false;
        this.diskComponents = new ArrayList<ILSMDiskComponent>();
        this.memoryComponents = new ArrayList<ILSMMemoryComponent>();
        this.currentMutableComponentId = new AtomicInteger();
        this.flushRequests = new AtomicBoolean[virtualBufferCaches.size()];
        for (int i = 0; i < virtualBufferCaches.size(); ++i) {
            this.flushRequests[i] = new AtomicBoolean();
        }
    }

    public AbstractLSMIndex(IIOManager ioManager, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean durable) {
        this.ioManager = ioManager;
        this.diskBufferCache = diskBufferCache;
        this.fileManager = fileManager;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.ioScheduler = ioScheduler;
        this.ioOpCallback = ioOpCallback;
        this.durable = durable;
        this.lsmHarness = new ExternalIndexHarness(this, mergePolicy, opTracker, diskBufferCache.isReplicationEnabled());
        this.isActive = false;
        this.diskComponents = new LinkedList<ILSMDiskComponent>();
        this.inactiveDiskComponents = new LinkedList<ILSMDiskComponent>();
        this.virtualBufferCaches = null;
        this.memoryComponents = null;
        this.currentMutableComponentId = null;
        this.flushRequests = null;
        this.filterHelper = null;
        this.filterFrameFactory = null;
        this.filterManager = null;
        this.treeFields = null;
        this.filterFields = null;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((int)49, (Serializable[])new Serializable[0]);
        }
        this.fileManager.createDirs();
        this.diskComponents.clear();
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((int)50, (Serializable[])new Serializable[0]);
        }
        this.loadDiskComponents();
        this.isActive = true;
    }

    protected void loadDiskComponents() throws HyracksDataException {
        this.diskComponents.clear();
        List<LSMComponentFileReferences> validFileReferences = this.fileManager.cleanupAndGetValidFiles();
        for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
            ILSMDiskComponent component = this.loadComponent(lsmComonentFileReference);
            this.diskComponents.add(component);
        }
    }

    public final synchronized void deactivate() throws HyracksDataException {
        this.deactivate(true);
    }

    @Override
    public synchronized void deactivate(boolean flush) throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((int)51, (Serializable[])new Serializable[0]);
        }
        if (flush) {
            this.flushMemoryComponents();
        }
        this.deactivateDiskComponents();
        this.deactivateMemoryComponents();
        this.isActive = false;
    }

    protected void flushMemoryComponents() throws HyracksDataException {
        BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
        ILSMIndexAccessor accessor = this.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        accessor.scheduleFlush(cb);
        try {
            cb.waitForIO();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void deactivateDiskComponents() throws HyracksDataException {
        List<ILSMDiskComponent> immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            this.deactivateDiskComponent(c);
        }
    }

    protected void deactivateMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMMemoryComponent c : this.memoryComponents) {
                this.deactivateMemoryComponent(c);
            }
            this.memoryComponentsAllocated = false;
        }
    }

    public void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((int)52, (Serializable[])new Serializable[0]);
        }
        this.destroyDiskComponents();
        this.fileManager.deleteDirs();
    }

    protected void destroyDiskComponents() throws HyracksDataException {
        List<ILSMDiskComponent> immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            this.destroyDiskComponent(c);
        }
    }

    public void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((int)53, (Serializable[])new Serializable[0]);
        }
        this.clearMemoryComponents();
        this.clearDiskComponents();
    }

    private void clearDiskComponents() throws HyracksDataException {
        for (ILSMDiskComponent c : this.diskComponents) {
            this.clearDiskComponent(c);
        }
        this.diskComponents.clear();
    }

    protected void clearMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMMemoryComponent c : this.memoryComponents) {
                this.clearMemoryComponent(c);
            }
        }
    }

    @Override
    public void getOperationalComponents(ILSMIndexOperationContext ctx) throws HyracksDataException {
        List<ILSMDiskComponent> immutableComponents = this.diskComponents;
        List<ILSMComponent> operationalComponents = ctx.getComponentHolder();
        int cmc = this.currentMutableComponentId.get();
        ctx.setCurrentMutableComponentId(cmc);
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case UPDATE: 
            case PHYSICALDELETE: 
            case FLUSH: 
            case DELETE: 
            case UPSERT: {
                operationalComponents.add(this.memoryComponents.get(cmc));
                break;
            }
            case INSERT: {
                this.addOperationalMutableComponents(operationalComponents);
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case SEARCH: {
                if (this.memoryComponentsAllocated) {
                    this.addOperationalMutableComponents(operationalComponents);
                }
                if (this.filterManager != null) {
                    for (ILSMComponent iLSMComponent : immutableComponents) {
                        if (!iLSMComponent.getLSMComponentFilter().satisfy(((AbstractSearchPredicate)ctx.getSearchPredicate()).getMinFilterTuple(), ((AbstractSearchPredicate)ctx.getSearchPredicate()).getMaxFilterTuple(), ctx.getFilterCmp())) continue;
                        operationalComponents.add(iLSMComponent);
                    }
                    break;
                }
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case DISK_COMPONENT_SCAN: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    @Override
    public void scanDiskComponents(ILSMIndexOperationContext ctx, IIndexCursor cursor) throws HyracksDataException {
        throw HyracksDataException.create((int)56, (Serializable[])new Serializable[0]);
    }

    @Override
    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ILSMMemoryComponent flushingComponent = (ILSMMemoryComponent)ctx.getComponentHolder().get(0);
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        AbstractLSMIndexOperationContext opCtx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        opCtx.setOperation(IndexOperation.FLUSH);
        opCtx.getComponentHolder().add(flushingComponent);
        ILSMIOOperation flushOp = this.createFlushOperation(opCtx, flushingComponent, componentFileRefs, callback);
        this.ioScheduler.scheduleOperation(flushOp);
    }

    @Override
    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        AbstractLSMIndexOperationContext opCtx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        opCtx.setOperation(IndexOperation.MERGE);
        List<ILSMComponent> mergingComponents = ctx.getComponentHolder();
        ILSMDiskComponent firstComponent = (ILSMDiskComponent)mergingComponents.get(0);
        ILSMDiskComponent lastComponent = (ILSMDiskComponent)mergingComponents.get(mergingComponents.size() - 1);
        LSMComponentFileReferences mergeFileRefs = this.getMergeFileReferences(firstComponent, lastComponent);
        ILSMIOOperation mergeOp = this.createMergeOperation(opCtx, mergingComponents, mergeFileRefs, callback);
        this.ioScheduler.scheduleOperation(mergeOp);
    }

    private void addOperationalMutableComponents(List<ILSMComponent> operationalComponents) {
        int cmc = this.currentMutableComponentId.get();
        int numMutableComponents = this.memoryComponents.size();
        for (int i = 0; i < numMutableComponents - 1; ++i) {
            ILSMMemoryComponent c = this.memoryComponents.get((cmc + i + 1) % numMutableComponents);
            if (!c.isReadable()) continue;
            operationalComponents.add(0, c);
        }
        operationalComponents.add(0, this.memoryComponents.get(cmc));
    }

    public final IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws HyracksDataException {
        if (checkIfEmptyIndex && !this.isEmptyIndex()) {
            throw HyracksDataException.create((int)34, (Serializable[])new Serializable[0]);
        }
        return this.createBulkLoader(fillLevel, verifyInput, numElementsHint);
    }

    @Override
    public final synchronized void allocateMemoryComponents() throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((int)54, (Serializable[])new Serializable[0]);
        }
        if (this.memoryComponentsAllocated) {
            return;
        }
        for (ILSMMemoryComponent c : this.memoryComponents) {
            this.allocateMemoryComponent(c);
        }
        this.memoryComponentsAllocated = true;
    }

    protected void markAsValidInternal(ITreeIndex treeIndex) throws HyracksDataException {
        int fileId = treeIndex.getFileId();
        IBufferCache bufferCache = treeIndex.getBufferCache();
        treeIndex.getPageManager().close();
        if (this.durable) {
            bufferCache.force(fileId, true);
        }
    }

    protected void markAsValidInternal(IBufferCache bufferCache, BloomFilter filter) throws HyracksDataException {
        if (this.durable) {
            bufferCache.force(filter.getFileId(), true);
        }
    }

    @Override
    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        this.diskComponents.add(0, c);
    }

    @Override
    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex = this.diskComponents.indexOf(mergedComponents.get(0));
        this.diskComponents.removeAll(mergedComponents);
        this.diskComponents.add(swapIndex, newComponent);
    }

    @Override
    public void changeMutableComponent() {
        this.currentMutableComponentId.set((this.currentMutableComponentId.get() + 1) % this.memoryComponents.size());
        this.memoryComponents.get(this.currentMutableComponentId.get()).activate();
    }

    @Override
    public List<ILSMDiskComponent> getImmutableComponents() {
        return this.diskComponents;
    }

    @Override
    public void changeFlushStatusForCurrentMutableCompoent(boolean needsFlush) {
        this.flushRequests[this.currentMutableComponentId.get()].set(needsFlush);
    }

    @Override
    public boolean hasFlushRequestForCurrentMutableComponent() {
        return this.flushRequests[this.currentMutableComponentId.get()].get();
    }

    @Override
    public ILSMOperationTracker getOperationTracker() {
        return this.lsmHarness.getOperationTracker();
    }

    @Override
    public ILSMIOOperationScheduler getIOScheduler() {
        return this.ioScheduler;
    }

    @Override
    public ILSMIOOperationCallback getIOOperationCallback() {
        return this.ioOpCallback;
    }

    public IBufferCache getBufferCache() {
        return this.diskBufferCache;
    }

    public boolean isEmptyIndex() {
        boolean isModified = false;
        for (ILSMComponent iLSMComponent : this.memoryComponents) {
            AbstractLSMMemoryComponent mutableComponent = (AbstractLSMMemoryComponent)iLSMComponent;
            if (!mutableComponent.isModified()) continue;
            isModified = true;
            break;
        }
        return this.diskComponents.isEmpty() && !isModified;
    }

    public String toString() {
        return "LSMIndex [" + this.fileManager.getBaseDir() + "]";
    }

    public boolean hasMemoryComponents() {
        return true;
    }

    @Override
    public boolean isCurrentMutableComponentEmpty() throws HyracksDataException {
        return !this.memoryComponents.get(this.currentMutableComponentId.get()).isModified();
    }

    public void setCurrentMutableComponentState(ILSMComponent.ComponentState componentState) {
        this.memoryComponents.get(this.currentMutableComponentId.get()).setState(componentState);
    }

    public ILSMComponent.ComponentState getCurrentMutableComponentState() {
        return this.memoryComponents.get(this.currentMutableComponentId.get()).getState();
    }

    public int getCurrentMutableComponentWriterCount() {
        return this.memoryComponents.get(this.currentMutableComponentId.get()).getWriterCount();
    }

    @Override
    public List<ILSMDiskComponent> getInactiveDiskComponents() {
        return this.inactiveDiskComponents;
    }

    @Override
    public void addInactiveDiskComponent(ILSMDiskComponent diskComponent) {
        this.inactiveDiskComponents.add(diskComponent);
    }

    @Override
    public void scheduleReplication(ILSMIndexOperationContext ctx, List<ILSMDiskComponent> lsmComponents, boolean bulkload, IReplicationJob.ReplicationOperation operation, LSMOperationType opType) throws HyracksDataException {
        HashSet<String> componentFiles = new HashSet<String>();
        for (ILSMComponent iLSMComponent : lsmComponents) {
            componentFiles.addAll(this.getLSMComponentPhysicalFiles(iLSMComponent));
        }
        IReplicationJob.ReplicationExecutionType executionType = bulkload ? IReplicationJob.ReplicationExecutionType.SYNC : IReplicationJob.ReplicationExecutionType.ASYNC;
        LSMIndexReplicationJob lSMIndexReplicationJob = new LSMIndexReplicationJob(this, ctx, componentFiles, operation, executionType, opType);
        try {
            this.diskBufferCache.getIOReplicationManager().submitJob((IReplicationJob)lSMIndexReplicationJob);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public boolean isMemoryComponentsAllocated() {
        return this.memoryComponentsAllocated;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public ILSMMemoryComponent getCurrentMemoryComponent() {
        return this.memoryComponents.get(this.currentMutableComponentId.get());
    }

    @Override
    public int getCurrentMemoryComponentIndex() {
        return this.currentMutableComponentId.get();
    }

    @Override
    public List<ILSMMemoryComponent> getMemoryComponents() {
        return this.memoryComponents;
    }

    protected IBinaryComparatorFactory[] getFilterCmpFactories() {
        return this.filterHelper == null ? null : this.filterHelper.getFilterCmpFactories();
    }

    public int getNumOfFilterFields() {
        return this.filterFields == null ? 0 : this.filterFields.length;
    }

    public double bloomFilterFalsePositiveRate() {
        return this.bloomFilterFalsePositiveRate;
    }

    @Override
    public void updateFilter(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException {
        if (ctx.getFilterTuple() != null) {
            ctx.getFilterTuple().reset(tuple);
            this.memoryComponents.get(this.currentMutableComponentId.get()).getLSMComponentFilter().update((ITupleReference)ctx.getFilterTuple(), ctx.getFilterCmp());
        }
    }

    public int[] getFilterFields() {
        return this.filterFields;
    }

    public int[] getTreeFields() {
        return this.treeFields;
    }

    public LSMComponentFilterManager getFilterManager() {
        return this.filterManager;
    }

    public ILSMHarness getLsmHarness() {
        return this.lsmHarness;
    }

    public final void validate() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMMemoryComponent iLSMMemoryComponent : this.memoryComponents) {
                this.validateMemoryComponent(iLSMMemoryComponent);
            }
        }
        for (ILSMDiskComponent iLSMDiskComponent : this.diskComponents) {
            this.validateDiskComponent(iLSMDiskComponent);
        }
    }

    public long getMemoryAllocationSize() {
        long size = 0L;
        for (ILSMMemoryComponent c : this.memoryComponents) {
            size += this.getMemoryComponentSize(c);
        }
        return size;
    }

    public abstract Set<String> getLSMComponentPhysicalFiles(ILSMComponent var1);

    protected abstract void allocateMemoryComponent(ILSMMemoryComponent var1) throws HyracksDataException;

    protected abstract IIndexBulkLoader createBulkLoader(float var1, boolean var2, long var3) throws HyracksDataException;

    protected abstract ILSMDiskComponent loadComponent(LSMComponentFileReferences var1) throws HyracksDataException;

    protected abstract void deactivateMemoryComponent(ILSMMemoryComponent var1) throws HyracksDataException;

    protected abstract void deactivateDiskComponent(ILSMDiskComponent var1) throws HyracksDataException;

    protected abstract void destroyDiskComponent(ILSMDiskComponent var1) throws HyracksDataException;

    protected abstract void clearDiskComponent(ILSMDiskComponent var1) throws HyracksDataException;

    protected abstract void clearMemoryComponent(ILSMMemoryComponent var1) throws HyracksDataException;

    protected abstract void validateMemoryComponent(ILSMMemoryComponent var1) throws HyracksDataException;

    protected abstract void validateDiskComponent(ILSMDiskComponent var1) throws HyracksDataException;

    protected abstract long getMemoryComponentSize(ILSMMemoryComponent var1);

    protected abstract LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent var1, ILSMDiskComponent var2) throws HyracksDataException;

    protected abstract AbstractLSMIndexOperationContext createOpContext(IModificationOperationCallback var1, ISearchOperationCallback var2) throws HyracksDataException;

    protected abstract ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext var1, ILSMMemoryComponent var2, LSMComponentFileReferences var3, ILSMIOOperationCallback var4) throws HyracksDataException;

    protected abstract ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext var1, List<ILSMComponent> var2, LSMComponentFileReferences var3, ILSMIOOperationCallback var4) throws HyracksDataException;
}

