/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class AbstractLSMDiskComponentWithBuddyBulkLoader
extends AbstractLSMDiskComponentBulkLoader {
    protected final IIndexBulkLoader buddyBTreeBulkLoader;

    public AbstractLSMDiskComponentWithBuddyBulkLoader(ILSMDiskComponent component, BloomFilterSpecification bloomFilterSpec, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean cleanupEmptyComponent, ILSMComponentFilterManager filterManager, int[] indexFields, int[] filterFields, MultiComparator filterCmp) throws HyracksDataException {
        super(component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent, filterManager, indexFields, filterFields, filterCmp);
        this.buddyBTreeBulkLoader = this.getBuddyBTree(component).createBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex);
    }

    @Override
    public void add(ITupleReference tuple) throws HyracksDataException {
        try {
            ITupleReference t;
            if (this.indexTuple != null) {
                this.indexTuple.reset(tuple);
                t = this.indexTuple;
            } else {
                t = tuple;
            }
            this.indexBulkLoader.add(t);
            this.updateFilter(tuple);
        }
        catch (Exception e) {
            this.cleanupArtifacts();
            throw e;
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    @Override
    public void delete(ITupleReference tuple) throws HyracksDataException {
        try {
            ITupleReference t;
            if (this.indexTuple != null) {
                this.indexTuple.reset(tuple);
                t = this.indexTuple;
            } else {
                t = tuple;
            }
            this.buddyBTreeBulkLoader.add(t);
            if (this.bloomFilterBuilder != null) {
                this.bloomFilterBuilder.add(t);
            }
            this.updateFilter(tuple);
        }
        catch (HyracksDataException e) {
            if (e.getErrorCode() != 33) {
                this.cleanupArtifacts();
                throw e;
            }
        }
        catch (Exception e) {
            this.cleanupArtifacts();
            throw e;
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    @Override
    public void abort() throws HyracksDataException {
        super.abort();
        if (this.buddyBTreeBulkLoader != null) {
            this.buddyBTreeBulkLoader.abort();
        }
    }

    @Override
    public void end() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            if (this.bloomFilterBuilder != null && !this.endedBloomFilterLoad) {
                this.bloomFilterBuilder.end();
                this.endedBloomFilterLoad = true;
            }
            if (this.filterManager != null && this.component.getLSMComponentFilter() != null) {
                this.filterManager.writeFilter(this.component.getLSMComponentFilter(), this.getTreeIndex(this.component));
            }
            this.indexBulkLoader.end();
            this.buddyBTreeBulkLoader.end();
            if (this.isEmptyComponent && this.cleanupEmptyComponent) {
                this.cleanupArtifacts();
            }
        }
    }

    @Override
    protected void cleanupArtifacts() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            this.cleanedUpArtifacts = true;
            if (this.bloomFilterBuilder != null && !this.endedBloomFilterLoad) {
                this.bloomFilterBuilder.abort();
                this.endedBloomFilterLoad = true;
            }
            this.getIndex(this.component).deactivate();
            this.getIndex(this.component).destroy();
            this.getBuddyBTree(this.component).deactivate();
            this.getBuddyBTree(this.component).destroy();
            if (this.bloomFilterBuilder != null) {
                this.getBloomFilter(this.component).deactivate();
                this.getBloomFilter(this.component).destroy();
            }
        }
    }

    protected abstract ITreeIndex getBuddyBTree(ILSMDiskComponent var1);
}

