/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.nio.ByteBuffer;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class TxnId {
    public boolean isByteArrayPKValue;
    public int jobId;
    public int datasetId;
    public int pkHashValue;
    public int pkSize;
    public byte[] byteArrayPKValue;
    public ITupleReference tupleReferencePKValue;

    public TxnId(int jobId, int datasetId, int pkHashValue, ITupleReference pkValue, int pkSize, boolean isByteArrayPKValue) {
        this.jobId = jobId;
        this.datasetId = datasetId;
        this.pkHashValue = pkHashValue;
        this.pkSize = pkSize;
        this.isByteArrayPKValue = isByteArrayPKValue;
        if (isByteArrayPKValue) {
            this.byteArrayPKValue = new byte[pkSize];
            TxnId.readPKValueIntoByteArray(pkValue, pkSize, this.byteArrayPKValue);
        } else {
            this.tupleReferencePKValue = pkValue;
        }
    }

    public TxnId() {
    }

    private static void readPKValueIntoByteArray(ITupleReference pkValue, int pkSize, byte[] byteArrayPKValue) {
        int readOffset = pkValue.getFieldStart(0);
        byte[] readBuffer = pkValue.getFieldData(0);
        for (int i = 0; i < pkSize; ++i) {
            byteArrayPKValue[i] = readBuffer[readOffset + i];
        }
    }

    public void setTxnId(int jobId, int datasetId, int pkHashValue, ITupleReference pkValue, int pkSize) {
        this.jobId = jobId;
        this.datasetId = datasetId;
        this.pkHashValue = pkHashValue;
        this.tupleReferencePKValue = pkValue;
        this.pkSize = pkSize;
        this.isByteArrayPKValue = false;
    }

    public String toString() {
        return "[" + this.jobId + "," + this.datasetId + "," + this.pkHashValue + "," + this.pkSize + "]";
    }

    public int hashCode() {
        return this.pkHashValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxnId)) {
            return false;
        }
        TxnId txnId = (TxnId)o;
        return txnId.pkHashValue == this.pkHashValue && txnId.datasetId == this.datasetId && txnId.jobId == this.jobId && this.pkSize == txnId.pkSize && this.isEqualTo(txnId);
    }

    private boolean isEqualTo(TxnId txnId) {
        if (this.isByteArrayPKValue && txnId.isByteArrayPKValue) {
            return TxnId.isEqual(this.byteArrayPKValue, txnId.byteArrayPKValue, this.pkSize);
        }
        if (this.isByteArrayPKValue && !txnId.isByteArrayPKValue) {
            return TxnId.isEqual(this.byteArrayPKValue, txnId.tupleReferencePKValue, this.pkSize);
        }
        if (!this.isByteArrayPKValue && txnId.isByteArrayPKValue) {
            return TxnId.isEqual(txnId.byteArrayPKValue, this.tupleReferencePKValue, this.pkSize);
        }
        return TxnId.isEqual(this.tupleReferencePKValue, txnId.tupleReferencePKValue, this.pkSize);
    }

    private static boolean isEqual(byte[] a, byte[] b, int size) {
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(byte[] a, ITupleReference b, int size) {
        int readOffset = b.getFieldStart(0);
        byte[] readBuffer = b.getFieldData(0);
        for (int i = 0; i < size; ++i) {
            if (a[i] == readBuffer[readOffset + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(ITupleReference a, ITupleReference b, int size) {
        int aOffset = a.getFieldStart(0);
        byte[] aBuffer = a.getFieldData(0);
        int bOffset = b.getFieldStart(0);
        byte[] bBuffer = b.getFieldData(0);
        for (int i = 0; i < size; ++i) {
            if (aBuffer[aOffset + i] == bBuffer[bOffset + i]) continue;
            return false;
        }
        return true;
    }

    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.jobId);
        buffer.putInt(this.datasetId);
        buffer.putInt(this.pkHashValue);
        buffer.putInt(this.pkSize);
        buffer.put((byte)(this.isByteArrayPKValue ? 1 : 0));
        if (this.isByteArrayPKValue) {
            buffer.put(this.byteArrayPKValue);
        }
    }

    public static TxnId deserialize(ByteBuffer buffer) {
        TxnId txnId = new TxnId();
        txnId.jobId = buffer.getInt();
        txnId.datasetId = buffer.getInt();
        txnId.pkHashValue = buffer.getInt();
        txnId.pkSize = buffer.getInt();
        boolean bl = txnId.isByteArrayPKValue = buffer.get() == 1;
        if (txnId.isByteArrayPKValue) {
            byte[] byteArrayPKValue = new byte[txnId.pkSize];
            buffer.get(byteArrayPKValue);
            txnId.byteArrayPKValue = byteArrayPKValue;
        }
        return txnId;
    }

    public int getCurrentSize() {
        int size = 17;
        if (this.isByteArrayPKValue && this.byteArrayPKValue != null) {
            size += this.byteArrayPKValue.length;
        }
        return size;
    }
}

