/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.logging.LogManager;

public class LogManagerWithReplication
extends LogManager {
    private IReplicationManager replicationManager;
    private final IReplicationStrategy replicationStrategy;
    private final Set<Integer> replicatedJob = ConcurrentHashMap.newKeySet();

    public LogManagerWithReplication(ITransactionSubsystem txnSubsystem, IReplicationStrategy replicationStrategy) {
        super(txnSubsystem);
        this.replicationStrategy = replicationStrategy;
    }

    @Override
    public void log(ILogRecord logRecord) throws ACIDException {
        boolean shouldReplicate;
        boolean bl = shouldReplicate = logRecord.getLogSource() == 0 && logRecord.getLogType() != 6;
        if (shouldReplicate) {
            switch (logRecord.getLogType()) {
                case 0: 
                case 2: 
                case 4: {
                    shouldReplicate = this.replicationStrategy.isMatch(logRecord.getDatasetId());
                    if (!shouldReplicate || this.replicatedJob.contains(logRecord.getJobId())) break;
                    this.replicatedJob.add(logRecord.getJobId());
                    break;
                }
                case 1: 
                case 3: {
                    shouldReplicate = this.replicatedJob.remove(logRecord.getJobId());
                    break;
                }
                default: {
                    shouldReplicate = false;
                }
            }
        }
        logRecord.setReplicated(shouldReplicate);
        if (logRecord.getLogType() == 4 && logRecord.getLogSource() == 0) {
            this.flushLogsQ.offer(logRecord);
            return;
        }
        this.appendToLogTail(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendToLogTail(ILogRecord logRecord) throws ACIDException {
        this.syncAppendToLogTail(logRecord);
        if (logRecord.isReplicated()) {
            try {
                this.replicationManager.replicateLog(logRecord);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!(logRecord.getLogSource() != 0 || logRecord.getLogType() != 1 && logRecord.getLogType() != 3 && logRecord.getLogType() != 6 || logRecord.isFlushed())) {
            ILogRecord iLogRecord = logRecord;
            synchronized (iLogRecord) {
                while (!logRecord.isFlushed()) {
                    try {
                        logRecord.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (logRecord.isReplicated() && (logRecord.getLogType() == 1 || logRecord.getLogType() == 3)) {
                    while (!this.replicationManager.hasBeenReplicated(logRecord)) {
                        try {
                            logRecord.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
        }
    }

    @Override
    protected synchronized void syncAppendToLogTail(ILogRecord logRecord) throws ACIDException {
        ITransactionContext txnCtx;
        if (logRecord.getLogSource() == 0 && logRecord.getLogType() != 4 && (txnCtx = logRecord.getTxnCtx()).getTxnState() == 2 && logRecord.getLogType() != 3) {
            throw new ACIDException("Aborted job(" + txnCtx.getJobId() + ") tried to write non-abort type log record.");
        }
        int logRecordSize = logRecord.getLogSize();
        if (this.getLogFileOffset(this.appendLSN.get()) + (long)logRecordSize >= this.logFileSize) {
            this.prepareNextLogFile();
            this.prepareNextPage(logRecordSize);
        } else if (!this.appendPage.hasSpace(logRecordSize)) {
            this.prepareNextPage(logRecordSize);
        }
        this.appendPage.append(logRecord, this.appendLSN.get());
        if (logRecord.getLogType() == 4) {
            logRecord.setLSN(this.appendLSN.get());
        }
        this.appendLSN.addAndGet(logRecordSize);
    }

    @Override
    public void setReplicationManager(IReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }
}

