/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.nio.ByteBuffer;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.LogRecord;

public class LogBufferTailReader {
    private final ByteBuffer buffer;
    private final LogRecord logRecord;
    private int endOffset;

    public LogBufferTailReader(ByteBuffer buffer) {
        this.buffer = buffer;
        this.logRecord = new LogRecord();
    }

    public void initializeScan(int beginOffset, int endOffset) {
        this.endOffset = endOffset;
        this.buffer.position(beginOffset);
    }

    public LogRecord next() {
        if (this.buffer.position() == this.endOffset) {
            return null;
        }
        ILogRecord.RecordReadStatus status = this.logRecord.readLogRecord(this.buffer);
        if (status != ILogRecord.RecordReadStatus.OK) {
            throw new IllegalStateException();
        }
        return this.logRecord;
    }
}

