/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IReplicationThread;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILogBuffer;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.transactions.MutableLong;
import org.apache.asterix.transaction.management.service.logging.LogBufferTailReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class LogBuffer
implements ILogBuffer {
    public static final boolean IS_DEBUG_MODE = false;
    private static final Logger LOGGER = Logger.getLogger(LogBuffer.class.getName());
    private final ITransactionSubsystem txnSubsystem;
    private final LogBufferTailReader logBufferTailReader;
    private final int logPageSize;
    private final MutableLong flushLSN;
    private final AtomicBoolean full;
    protected int appendOffset;
    private int flushOffset;
    protected final ByteBuffer appendBuffer;
    private final ByteBuffer flushBuffer;
    private final ByteBuffer unlockBuffer;
    private boolean isLastPage;
    protected final LinkedBlockingQueue<ILogRecord> syncCommitQ;
    protected final LinkedBlockingQueue<ILogRecord> flushQ;
    protected final LinkedBlockingQueue<ILogRecord> remoteJobsQ;
    private FileChannel fileChannel;
    private boolean stop;
    private final JobId reusableJobId;
    private final DatasetId reusableDatasetId;

    public LogBuffer(ITransactionSubsystem txnSubsystem, int logPageSize, MutableLong flushLSN) {
        this.txnSubsystem = txnSubsystem;
        this.logPageSize = logPageSize;
        this.flushLSN = flushLSN;
        this.appendBuffer = ByteBuffer.allocate(logPageSize);
        this.flushBuffer = this.appendBuffer.duplicate();
        this.unlockBuffer = this.appendBuffer.duplicate();
        this.logBufferTailReader = this.getLogBufferTailReader();
        this.full = new AtomicBoolean(false);
        this.appendOffset = 0;
        this.flushOffset = 0;
        this.isLastPage = false;
        this.syncCommitQ = new LinkedBlockingQueue(logPageSize / 14);
        this.flushQ = new LinkedBlockingQueue();
        this.remoteJobsQ = new LinkedBlockingQueue();
        this.reusableJobId = new JobId(-1);
        this.reusableDatasetId = new DatasetId(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ILogRecord logRecord, long appendLsn) {
        logRecord.writeLogRecord(this.appendBuffer);
        if (logRecord.getLogSource() == 0 && logRecord.getLogType() != 4 && logRecord.getLogType() != 6) {
            logRecord.getTxnCtx().setLastLSN(appendLsn);
        }
        LogBuffer logBuffer = this;
        synchronized (logBuffer) {
            this.appendOffset += logRecord.getLogSize();
            if (logRecord.getLogSource() == 0) {
                if (logRecord.getLogType() == 1 || logRecord.getLogType() == 3 || logRecord.getLogType() == 6) {
                    logRecord.isFlushed(false);
                    this.syncCommitQ.offer(logRecord);
                }
                if (logRecord.getLogType() == 4) {
                    logRecord.isFlushed(false);
                    this.flushQ.offer(logRecord);
                }
            } else if (logRecord.getLogSource() == 1 && (logRecord.getLogType() == 1 || logRecord.getLogType() == 3)) {
                this.remoteJobsQ.offer(logRecord);
            }
            this.notify();
        }
    }

    public void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public void setInitialFlushOffset(long offset) {
        try {
            this.fileChannel.position(offset);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void setFull() {
        this.full.set(true);
        this.notify();
    }

    public void setLastPage() {
        this.isLastPage = true;
    }

    public boolean hasSpace(int logSize) {
        return this.appendOffset + logSize <= this.logPageSize;
    }

    public void reset() {
        this.appendBuffer.position(0);
        this.appendBuffer.limit(this.logPageSize);
        this.flushBuffer.position(0);
        this.flushBuffer.limit(this.logPageSize);
        this.unlockBuffer.position(0);
        this.unlockBuffer.limit(this.logPageSize);
        this.full.set(false);
        this.appendOffset = 0;
        this.flushOffset = 0;
        this.isLastPage = false;
        this.stop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            while (!this.full.get()) {
                int endOffset;
                LogBuffer logBuffer = this;
                synchronized (logBuffer) {
                    if (this.appendOffset - this.flushOffset == 0 && !this.full.get()) {
                        try {
                            if (this.stop) {
                                this.fileChannel.close();
                                return;
                            }
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                    }
                    endOffset = this.appendOffset;
                }
                this.internalFlush(this.flushOffset, endOffset);
            }
            this.internalFlush(this.flushOffset, this.appendOffset);
            if (this.isLastPage) {
                this.fileChannel.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlush(int beginOffset, int endOffset) {
        block5: {
            try {
                if (endOffset <= beginOffset) break block5;
                this.flushBuffer.limit(endOffset);
                this.fileChannel.write(this.flushBuffer);
                this.fileChannel.force(false);
                this.flushOffset = endOffset;
                MutableLong mutableLong = this.flushLSN;
                synchronized (mutableLong) {
                    this.flushLSN.set(this.flushLSN.get() + (long)(endOffset - beginOffset));
                    this.flushLSN.notifyAll();
                }
                this.batchUnlock(beginOffset, endOffset);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private LogBufferTailReader getLogBufferTailReader() {
        return new LogBufferTailReader(this.unlockBuffer);
    }

    private void batchUnlock(int beginOffset, int endOffset) throws ACIDException {
        if (endOffset > beginOffset) {
            this.logBufferTailReader.initializeScan(beginOffset, endOffset);
            ITransactionContext txnCtx = null;
            LogRecord logRecord = this.logBufferTailReader.next();
            while (logRecord != null) {
                if (logRecord.getLogSource() == 0) {
                    if (logRecord.getLogType() == 2) {
                        this.reusableJobId.setId(logRecord.getJobId());
                        this.reusableDatasetId.setId(logRecord.getDatasetId());
                        txnCtx = this.txnSubsystem.getTransactionManager().getTransactionContext(this.reusableJobId, false);
                        this.txnSubsystem.getLockManager().unlock(this.reusableDatasetId, logRecord.getPKHashValue(), (byte)-1, txnCtx);
                        txnCtx.notifyOptracker(false);
                        if (this.txnSubsystem.getTransactionProperties().isCommitProfilerEnabled()) {
                            this.txnSubsystem.incrementEntityCommitCount();
                        }
                    } else if (logRecord.getLogType() == 1 || logRecord.getLogType() == 3) {
                        this.reusableJobId.setId(logRecord.getJobId());
                        txnCtx = this.txnSubsystem.getTransactionManager().getTransactionContext(this.reusableJobId, false);
                        txnCtx.notifyOptracker(true);
                        this.notifyJobTermination();
                    } else if (logRecord.getLogType() == 4) {
                        this.notifyFlushTermination();
                    } else if (logRecord.getLogType() == 6) {
                        this.notifyWaitTermination();
                    }
                } else if (logRecord.getLogSource() == 1 && (logRecord.getLogType() == 1 || logRecord.getLogType() == 3)) {
                    this.notifyReplicationTermination();
                }
                logRecord = this.logBufferTailReader.next();
            }
        }
    }

    public void notifyJobTermination() {
        this.notifyToSyncCommitQWaiter();
    }

    public void notifyWaitTermination() {
        this.notifyToSyncCommitQWaiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyToSyncCommitQWaiter() {
        ILogRecord logRecord = null;
        while (logRecord == null) {
            try {
                logRecord = this.syncCommitQ.take();
            }
            catch (InterruptedException interruptedException) {}
        }
        ILogRecord iLogRecord = logRecord;
        synchronized (iLogRecord) {
            logRecord.isFlushed(true);
            logRecord.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFlushTermination() throws ACIDException {
        LogRecord logRecord = null;
        try {
            logRecord = (LogRecord)this.flushQ.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogRecord logRecord2 = logRecord;
        synchronized (logRecord2) {
            logRecord.isFlushed(true);
            logRecord.notifyAll();
        }
        PrimaryIndexOperationTracker opTracker = logRecord.getOpTracker();
        if (opTracker != null) {
            try {
                opTracker.triggerScheduleFlush(logRecord);
            }
            catch (HyracksDataException e) {
                throw new ACIDException((Throwable)e);
            }
        }
    }

    public void notifyReplicationTermination() {
        LogRecord logRecord = null;
        try {
            logRecord = (LogRecord)this.remoteJobsQ.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logRecord.isFlushed(true);
        IReplicationThread replicationThread = logRecord.getReplicationThread();
        if (replicationThread != null) {
            replicationThread.notifyLogReplicationRequester(logRecord);
        }
    }

    public void stop() {
        this.stop = true;
    }

    public int getLogPageSize() {
        return this.logPageSize;
    }
}

