/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import org.apache.asterix.transaction.management.service.locking.PrimitiveIntHashMap;

class ChildIntArrayManager {
    private final int DIM1_SIZE;
    private final int DIM2_SIZE;
    private final int NUM_OF_SLOTS;
    public int[][] cArray;

    public ChildIntArrayManager(PrimitiveIntHashMap parentHashMap) {
        this.DIM1_SIZE = parentHashMap.getNumOfChildBuckets();
        this.DIM2_SIZE = parentHashMap.getNumOfSlots() * 2;
        this.NUM_OF_SLOTS = parentHashMap.getNumOfSlots();
        this.initialize();
    }

    private void initialize() {
        this.cArray = new int[this.DIM1_SIZE][this.DIM2_SIZE];
        for (int i = 0; i < this.DIM1_SIZE; ++i) {
            this.cArray[i][0] = 0;
            for (int j = 1; j < this.NUM_OF_SLOTS; ++j) {
                this.cArray[i][j * 2] = -1;
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.DIM1_SIZE; ++i) {
            if (this.cArray[i][0] == 0) continue;
            this.cArray[i][0] = 0;
            for (int j = 1; j < this.NUM_OF_SLOTS; ++j) {
                this.cArray[i][j * 2] = -1;
            }
        }
    }

    public void deinitialize() {
        this.cArray = null;
    }

    public void allocate() {
        this.initialize();
    }

    public boolean isFull(int bucketNum) {
        return this.cArray[bucketNum][0] == this.NUM_OF_SLOTS - 1;
    }

    public boolean isEmpty(int bucketNum) {
        return this.cArray[bucketNum][0] == 0;
    }

    public int put(int bucketNum, int key, int value, boolean isUpsert) {
        int emptySlot = -1;
        if (this.cArray[bucketNum][0] == 0) {
            this.cArray[bucketNum][2] = key;
            this.cArray[bucketNum][3] = value;
            int[] nArray = this.cArray[bucketNum];
            nArray[0] = nArray[0] + 1;
            return 1;
        }
        for (int i = 1; i < this.NUM_OF_SLOTS; ++i) {
            if (this.cArray[bucketNum][i * 2] == key) {
                if (isUpsert) {
                    this.cArray[bucketNum][i * 2 + 1] = value;
                }
                return 0;
            }
            if (this.cArray[bucketNum][i * 2] != -1) continue;
            emptySlot = i;
        }
        if (emptySlot == -1) {
            throw new UnsupportedOperationException("error");
        }
        this.cArray[bucketNum][emptySlot * 2] = key;
        this.cArray[bucketNum][emptySlot * 2 + 1] = value;
        int[] nArray = this.cArray[bucketNum];
        nArray[0] = nArray[0] + 1;
        return 1;
    }

    public int get(int bucketNum, int key) {
        if (this.cArray[bucketNum][0] == 0) {
            return -1;
        }
        for (int i = 1; i < this.NUM_OF_SLOTS; ++i) {
            if (this.cArray[bucketNum][i * 2] != key) continue;
            return this.cArray[bucketNum][i * 2 + 1];
        }
        return -1;
    }

    public int remove(int bucketNum, int key) {
        if (this.cArray[bucketNum][0] == 0) {
            return 0;
        }
        for (int i = 1; i < this.NUM_OF_SLOTS; ++i) {
            if (this.cArray[bucketNum][i * 2] != key) continue;
            this.cArray[bucketNum][i * 2] = -1;
            int[] nArray = this.cArray[bucketNum];
            nArray[0] = nArray[0] - 1;
            return 1;
        }
        return 0;
    }
}

