/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper.commands;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.asterix.clienthelper.Args;

public abstract class ClientCommand {
    protected final Args args;

    public ClientCommand(Args args) {
        this.args = args;
    }

    protected void log(Level severity, String message) {
        if (!this.args.isQuiet()) {
            System.out.println(severity + ": " + message);
        }
    }

    protected void log(String message) {
        this.log(Level.INFO, message);
    }

    public abstract int execute() throws IOException;

    public static enum Command {
        GET_CLUSTER_STATE("Get state of cluster (errorcode 0 = ACTIVE, 1 = DOWN, 2 = UNUSABLE, 3 = OTHER)"),
        WAIT_FOR_CLUSTER("Wait for cluster to be ready (errorcode 0 = ACTIVE, non-zero = UNKNOWN)"),
        SHUTDOWN_CLUSTER("Instructs the cluster to shut down, leaving NCService processes intact"),
        SHUTDOWN_CLUSTER_ALL("Instructs the cluster to shut down, including NCService processes"),
        SLEEP("Sleep for specified -timeout seconds (-timeout must be set and greater than zero)");

        private final String usage;
        private static final Map<String, Command> nameMap;

        private Command(String usage) {
            this.usage = usage;
        }

        public String usage() {
            return this.usage;
        }

        public static Command valueOfSafe(String name) {
            return nameMap.get(name.toUpperCase());
        }

        static {
            nameMap = new HashMap<String, Command>();
            for (Command command : Command.values()) {
                nameMap.put(command.name(), command);
            }
        }
    }
}

