/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.dataflow;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.transactions.PrimaryIndexLogMarkerCallback;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class LSMInsertDeleteOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    public static final String KEY_INDEX = "Index";
    private final boolean isPrimary;
    private AbstractLSMIndex lsmIndex;
    private int i = 0;
    private boolean flushedPartialTuples;
    private int currentTupleIdx;
    private int lastFlushedTupleIdx;

    public LSMInsertDeleteOperatorNodePushable(IHyracksTaskContext ctx, int partition, int[] fieldPermutation, RecordDescriptor inputRecDesc, IndexOperation op, boolean isPrimary, IIndexDataflowHelperFactory indexHelperFactory, IModificationOperationCallbackFactory modCallbackFactory, ITupleFilterFactory tupleFilterFactory) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, op, modCallbackFactory, tupleFilterFactory);
        this.isPrimary = isPrimary;
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.appender = new FrameTupleAppender(this.writeBuffer);
        this.indexHelper.open();
        this.lsmIndex = (AbstractLSMIndex)this.indexHelper.getIndexInstance();
        try {
            if (this.isPrimary && this.ctx.getSharedObject() != null) {
                PrimaryIndexLogMarkerCallback callback = new PrimaryIndexLogMarkerCallback((ILSMIndex)this.lsmIndex);
                TaskUtil.put((String)"MARKER_CALLBACK", (Object)callback, (IHyracksTaskContext)this.ctx);
            }
            this.writer.open();
            this.modCallback = this.modOpCallbackFactory.createModificationOperationCallback(this.indexHelper.getResource(), this.ctx, (IOperatorNodePushable)this);
            this.indexAccessor = this.lsmIndex.createAccessor(this.modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            if (this.tupleFilterFactory != null) {
                this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
                this.frameTuple = new FrameTupleReference();
            }
            INcApplicationContext runtimeCtx = (INcApplicationContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            LSMIndexUtil.checkAndSetFirstLSN(this.lsmIndex, runtimeCtx.getTransactionSubsystem().getLogManager());
        }
        catch (Throwable th) {
            throw new HyracksDataException(th);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.currentTupleIdx = 0;
        this.lastFlushedTupleIdx = 0;
        this.flushedPartialTuples = false;
        this.accessor.reset(buffer);
        ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessor;
        int tupleCount = this.accessor.getTupleCount();
        try {
            while (this.i < tupleCount) {
                block17: {
                    block16: {
                        if (this.tupleFilter == null) break block16;
                        this.frameTuple.reset((IFrameTupleAccessor)this.accessor, this.i);
                        if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) break block17;
                    }
                    this.tuple.reset((IFrameTupleAccessor)this.accessor, this.i);
                    switch (this.op) {
                        case INSERT: {
                            if (this.i == 0 && this.isPrimary) {
                                lsmAccessor.insert((ITupleReference)this.tuple);
                                break;
                            }
                            lsmAccessor.forceInsert((ITupleReference)this.tuple);
                            break;
                        }
                        case DELETE: {
                            if (this.i == 0 && this.isPrimary) {
                                lsmAccessor.delete((ITupleReference)this.tuple);
                                break;
                            }
                            lsmAccessor.forceDelete((ITupleReference)this.tuple);
                            break;
                        }
                        default: {
                            throw HyracksDataException.create((int)1, (Serializable[])new Serializable[]{this.op.toString(), LSMInsertDeleteOperatorNodePushable.class.getSimpleName()});
                        }
                    }
                }
                ++this.i;
                ++this.currentTupleIdx;
            }
        }
        catch (HyracksDataException e) {
            if (e.getErrorCode() == 1) {
                throw e;
            }
            throw HyracksDataException.create((int)2, (Throwable)e, (Serializable[])new Serializable[]{Integer.valueOf(this.i)});
        }
        catch (Exception e) {
            throw HyracksDataException.create((int)2, (Throwable)e, (Serializable[])new Serializable[]{Integer.valueOf(this.i)});
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        if (this.flushedPartialTuples) {
            this.flushPartialFrame();
        } else {
            FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
            FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
        }
        this.i = 0;
    }

    public void flushPartialFrame() throws HyracksDataException {
        if (this.lastFlushedTupleIdx == this.currentTupleIdx) {
            return;
        }
        for (int i = this.lastFlushedTupleIdx; i < this.currentTupleIdx; ++i) {
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)i);
        }
        this.appender.write(this.writer, true);
        this.lastFlushedTupleIdx = this.currentTupleIdx;
        this.flushedPartialTuples = true;
    }

    public void close() throws HyracksDataException {
        if (this.lsmIndex != null) {
            try {
                this.indexHelper.close();
            }
            finally {
                this.writer.close();
            }
        }
    }

    public void fail() throws HyracksDataException {
        if (this.lsmIndex != null) {
            this.writer.fail();
        }
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }
}

