/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.CorrelatedPrefixMergePolicy;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;

public class CorrelatedPrefixMergePolicyFactory
implements ILSMMergePolicyFactory {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "correlated-prefix";
    public static final String KEY_DATASET_ID = "datasetId";
    public static final String KEY_MAX_COMPONENT_SIZE = "max-mergable-component-size";
    public static final String KEY_MAX_COMPONENT_COUNT = "max-tolerance-component-count";
    private static final String[] SET_VALUES = new String[]{"max-mergable-component-size", "max-tolerance-component-count"};
    private static final Set<String> PROPERTIES_NAMES = new HashSet<String>(Arrays.asList(SET_VALUES));

    public String getName() {
        return NAME;
    }

    public Set<String> getPropertiesNames() {
        return PROPERTIES_NAMES;
    }

    public ILSMMergePolicy createMergePolicy(Map<String, String> configuration, INCServiceContext ctx) {
        IDatasetLifecycleManager dslcManager = ((INcApplicationContext)ctx.getApplicationContext()).getDatasetLifecycleManager();
        int datasetId = Integer.parseInt(configuration.get(KEY_DATASET_ID));
        CorrelatedPrefixMergePolicy policy = new CorrelatedPrefixMergePolicy(dslcManager, datasetId);
        policy.configure(configuration);
        return policy;
    }
}

