/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt8TypeConvertComputer
implements ITypeConvertComputer {
    private static final FloatToInt8TypeConvertComputer INSTANCE_STRICT = new FloatToInt8TypeConvertComputer(true);
    private static final FloatToInt8TypeConvertComputer INSTANCE_LAX = new FloatToInt8TypeConvertComputer(false);
    private final boolean strict;

    private FloatToInt8TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static FloatToInt8TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        byte targetValue = this.convert(sourceValue);
        out.writeByte(ATypeTag.TINYINT.serialize());
        out.writeByte(targetValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject) throws HyracksDataException {
        float sourceValue = ((AFloat)sourceObject).getFloatValue();
        byte targetValue = this.convert(sourceValue);
        return new AInt8(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte convert(float sourceValue) throws HyracksDataException {
        if (Float.isNaN(sourceValue)) {
            if (!this.strict) return 0;
            this.raiseBoundaryException(sourceValue);
            return (byte)Math.floor(sourceValue);
        } else if (sourceValue > 127.0f) {
            if (!this.strict) return 127;
            this.raiseBoundaryException(sourceValue);
            return (byte)Math.floor(sourceValue);
        } else {
            if (!(sourceValue < -128.0f)) return (byte)Math.floor(sourceValue);
            if (!this.strict) return -128;
            this.raiseBoundaryException(sourceValue);
        }
        return (byte)Math.floor(sourceValue);
    }

    private void raiseBoundaryException(float sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(21, new Serializable[]{Float.valueOf(sourceValue), ATypeTag.TINYINT, Byte.valueOf((byte)127), Byte.valueOf((byte)-128)});
    }
}

