/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;

public class FloatToDoubleTypeConvertComputer
implements ITypeConvertComputer {
    private static final FloatToDoubleTypeConvertComputer INSTANCE = new FloatToDoubleTypeConvertComputer();

    private FloatToDoubleTypeConvertComputer() {
    }

    public static FloatToDoubleTypeConvertComputer getInstance() {
        return INSTANCE;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double targetValue = this.convertType(data, start);
        out.writeByte(ATypeTag.DOUBLE.serialize());
        DoubleSerializerDeserializer.write((double)targetValue, (DataOutput)out);
    }

    @Override
    public IAObject convertType(IAObject sourceObject) throws HyracksDataException {
        double targetValue = ((AFloat)sourceObject).getFloatValue();
        return new ADouble(targetValue);
    }

    double convertType(byte[] data, int start) {
        return FloatPointable.getFloat((byte[])data, (int)start);
    }
}

