/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToInt64TypeConvertComputer
implements ITypeConvertComputer {
    private static final DoubleToInt64TypeConvertComputer INSTANCE_STRICT = new DoubleToInt64TypeConvertComputer(true);
    private static final DoubleToInt64TypeConvertComputer INSTANCE_LAX = new DoubleToInt64TypeConvertComputer(false);
    private final boolean strict;

    static DoubleToInt64TypeConvertComputer getInstance() {
        return INSTANCE_STRICT;
    }

    private DoubleToInt64TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static DoubleToInt64TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        long targetValue = this.convertType(data, start);
        out.writeByte(ATypeTag.BIGINT.serialize());
        out.writeLong(targetValue);
    }

    long convertType(byte[] data, int start) throws HyracksDataException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        return this.convert(sourceValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject) throws HyracksDataException {
        double sourceValue = ((ADouble)sourceObject).getDoubleValue();
        long targetValue = this.convert(sourceValue);
        return new AInt64(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long convert(double sourceValue) throws HyracksDataException {
        if (Double.isNaN(sourceValue)) {
            if (!this.strict) return 0L;
            this.raiseBoundaryCheckException(sourceValue);
        }
        if (sourceValue > 9.223372036854776E18) {
            if (!this.strict) return Long.MAX_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
            return (long)Math.floor(sourceValue);
        } else {
            if (!(sourceValue < -9.223372036854776E18)) return (long)Math.floor(sourceValue);
            if (!this.strict) return Long.MIN_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
        }
        return (long)Math.floor(sourceValue);
    }

    private void raiseBoundaryCheckException(double sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(21, new Serializable[]{Double.valueOf(sourceValue), ATypeTag.BIGINT, Long.valueOf(Long.MAX_VALUE), Long.valueOf(Long.MIN_VALUE)});
    }
}

