/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.UnsupportedTypeException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericAggTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericAggTypeComputer INSTANCE = new NumericAggTypeComputer();

    private NumericAggTypeComputer() {
    }

    @Override
    protected void checkArgType(String funcName, int argIndex, IAType type) throws AlgebricksException {
        ATypeTag tag = type.getTypeTag();
        switch (tag) {
            case DOUBLE: 
            case FLOAT: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case ANY: {
                break;
            }
            default: {
                throw new UnsupportedTypeException(funcName, tag);
            }
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        ATypeTag tag = strippedInputTypes[0].getTypeTag();
        IAType type = null;
        switch (tag) {
            case DOUBLE: 
            case FLOAT: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case ANY: {
                type = strippedInputTypes[0];
                break;
            }
        }
        return AUnionType.createNullableType(type, "AggResult");
    }
}

