/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.IncompatibleTypeException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class NumericAddSubMulDivTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericAddSubMulDivTypeComputer INSTANCE = new NumericAddSubMulDivTypeComputer();

    private NumericAddSubMulDivTypeComputer() {
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        BuiltinType type;
        AbstractFunctionCallExpression functionCallExpression = (AbstractFunctionCallExpression)expr;
        String funcName = functionCallExpression.getFunctionIdentifier().getName();
        IAType t1 = strippedInputTypes[0];
        IAType t2 = strippedInputTypes[1];
        ATypeTag tag1 = t1.getTypeTag();
        ATypeTag tag2 = t2.getTypeTag();
        block0 : switch (tag1) {
            case DOUBLE: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case FLOAT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case BIGINT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case INTEGER: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: {
                        type = BuiltinType.AINT32;
                        break block0;
                    }
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case SMALLINT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: {
                        type = BuiltinType.AINT16;
                        break block0;
                    }
                    case INTEGER: {
                        type = BuiltinType.AINT32;
                        break block0;
                    }
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case TINYINT: {
                switch (tag2) {
                    case TINYINT: {
                        type = BuiltinType.AINT8;
                        break block0;
                    }
                    case SMALLINT: {
                        type = BuiltinType.AINT16;
                        break block0;
                    }
                    case INTEGER: {
                        type = BuiltinType.AINT32;
                        break block0;
                    }
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case ANY: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case DATE: {
                switch (tag2) {
                    case DATE: {
                        type = BuiltinType.ADURATION;
                        break block0;
                    }
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: 
                    case DURATION: {
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case TIME: {
                switch (tag2) {
                    case TIME: {
                        type = BuiltinType.ADURATION;
                        break block0;
                    }
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: 
                    case DURATION: {
                        type = BuiltinType.ATIME;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case DATETIME: {
                switch (tag2) {
                    case DATETIME: {
                        type = BuiltinType.ADURATION;
                        break block0;
                    }
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: 
                    case DURATION: {
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case DURATION: {
                switch (tag2) {
                    case DATE: {
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case TIME: {
                        type = BuiltinType.ATIME;
                        break block0;
                    }
                    case DATETIME: {
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case YEARMONTHDURATION: {
                switch (tag2) {
                    case DATE: {
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case TIME: {
                        type = BuiltinType.ATIME;
                        break block0;
                    }
                    case DATETIME: {
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                    case YEARMONTHDURATION: {
                        type = BuiltinType.AYEARMONTHDURATION;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            case DAYTIMEDURATION: {
                switch (tag2) {
                    case DATE: {
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case TIME: {
                        type = BuiltinType.ATIME;
                        break block0;
                    }
                    case DATETIME: {
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                    case DAYTIMEDURATION: {
                        type = BuiltinType.ADAYTIMEDURATION;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
            default: {
                throw new IncompatibleTypeException(funcName, tag1, tag2);
            }
        }
        return type;
    }
}

