/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.nonvisitor;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class ARecordPointable
extends AbstractPointable {
    private final UTF8StringWriter utf8Writer = new UTF8StringWriter();
    public static final ARecordPointableFactory FACTORY = new ARecordPointableFactory();
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return false;
        }

        public int getFixedLength() {
            return 0;
        }
    };
    public static final IObjectFactory<IPointable, ATypeTag> ALLOCATOR = new IObjectFactory<IPointable, ATypeTag>(){

        @Override
        public IPointable create(ATypeTag type) {
            return new ARecordPointable();
        }
    };
    private static final int TAG_SIZE = 1;
    private static final int RECORD_LENGTH_SIZE = 4;
    private static final int EXPANDED_SIZE = 1;
    private static final int OPEN_OFFSET_SIZE = 4;
    private static final int CLOSED_COUNT_SIZE = 4;
    private static final int FIELD_OFFSET_SIZE = 4;
    private static final int OPEN_COUNT_SIZE = 4;
    private static final int OPEN_FIELD_HASH_SIZE = 4;
    private static final int OPEN_FIELD_OFFSET_SIZE = 4;
    private static final int OPEN_FIELD_HEADER = 8;

    private static boolean isOpen(ARecordType recordType) {
        return recordType == null || recordType.isOpen();
    }

    public int getSchemeFieldCount(ARecordType recordType) {
        return recordType.getFieldNames().length;
    }

    public byte getTag() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.getTagOffset());
    }

    public int getTagOffset() {
        return this.start;
    }

    public int getTagSize() {
        return 1;
    }

    public int getLength() {
        return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getLengthOffset());
    }

    public int getLengthOffset() {
        return this.getTagOffset() + this.getTagSize();
    }

    public int getLengthSize() {
        return 4;
    }

    public boolean isExpanded(ARecordType recordType) {
        if (ARecordPointable.isOpen(recordType)) {
            return BooleanPointable.getBoolean((byte[])this.bytes, (int)this.getExpandedOffset(recordType));
        }
        return false;
    }

    public int getExpandedOffset(ARecordType recordType) {
        return this.getLengthOffset() + this.getLengthSize();
    }

    public int getExpandedSize(ARecordType recordType) {
        return ARecordPointable.isOpen(recordType) ? 1 : 0;
    }

    public int getOpenPartOffset(ARecordType recordType) {
        return this.getExpandedOffset(recordType) + this.getExpandedSize(recordType);
    }

    public int getOpenPartSize(ARecordType recordType) {
        return this.isExpanded(recordType) ? 4 : 0;
    }

    public int getClosedFieldCount(ARecordType recordType) {
        return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getClosedFieldCountOffset(recordType));
    }

    public int getClosedFieldCountOffset(ARecordType recordType) {
        return this.getOpenPartOffset(recordType) + this.getOpenPartSize(recordType);
    }

    public int getClosedFieldCountSize(ARecordType recordType) {
        return 4;
    }

    public int getNullBitmapOffset(ARecordType recordType) {
        return this.getClosedFieldCountOffset(recordType) + this.getClosedFieldCountSize(recordType);
    }

    public int getNullBitmapSize(ARecordType recordType) {
        return RecordUtil.computeNullBitmapSize(recordType);
    }

    public boolean isClosedFieldNull(ARecordType recordType, int fieldId) {
        if (this.getNullBitmapSize(recordType) > 0) {
            return (this.bytes[this.getNullBitmapOffset(recordType) + fieldId / 4] & 1 << 7 - 2 * (fieldId % 4)) == 0;
        }
        return false;
    }

    public boolean isClosedFieldMissing(ARecordType recordType, int fieldId) {
        if (this.getNullBitmapSize(recordType) > 0) {
            return (this.bytes[this.getNullBitmapOffset(recordType) + fieldId / 4] & 1 << 7 - 2 * (fieldId % 4) - 1) == 0;
        }
        return false;
    }

    public void getClosedFieldValue(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException, AsterixException {
        if (this.isClosedFieldNull(recordType, fieldId)) {
            dOut.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
        } else if (this.isClosedFieldMissing(recordType, fieldId)) {
            dOut.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
        } else {
            dOut.write(this.getClosedFieldTag(recordType, fieldId));
            dOut.write(this.bytes, this.getClosedFieldOffset(recordType, fieldId), this.getClosedFieldSize(recordType, fieldId));
        }
    }

    public String getClosedFieldName(ARecordType recordType, int fieldId) {
        return recordType.getFieldNames()[fieldId];
    }

    public void getClosedFieldName(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException {
        dOut.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        this.utf8Writer.writeUTF8((CharSequence)this.getClosedFieldName(recordType, fieldId), dOut);
    }

    public byte getClosedFieldTag(ARecordType recordType, int fieldId) {
        return this.getClosedFieldType(recordType, fieldId).getTypeTag().serialize();
    }

    public IAType getClosedFieldType(ARecordType recordType, int fieldId) {
        IAType aType = recordType.getFieldTypes()[fieldId];
        if (NonTaggedFormatUtil.isOptional(aType)) {
            aType = ((AUnionType)aType).getActualType();
        }
        return aType;
    }

    public int getClosedFieldSize(ARecordType recordType, int fieldId) throws HyracksDataException {
        if (this.isClosedFieldNull(recordType, fieldId)) {
            return 0;
        }
        return NonTaggedFormatUtil.getFieldValueLength(this.bytes, this.getClosedFieldOffset(recordType, fieldId), this.getClosedFieldType(recordType, fieldId).getTypeTag(), false);
    }

    public int getClosedFieldOffset(ARecordType recordType, int fieldId) {
        int offset = this.getNullBitmapOffset(recordType) + this.getNullBitmapSize(recordType) + fieldId * 4;
        return this.start + IntegerPointable.getInteger((byte[])this.bytes, (int)offset);
    }

    public int getOpenFieldCount(ARecordType recordType) {
        return this.isExpanded(recordType) ? IntegerPointable.getInteger((byte[])this.bytes, (int)this.getOpenFieldCountOffset(recordType)) : 0;
    }

    public int getOpenFieldCountSize(ARecordType recordType) {
        return this.isExpanded(recordType) ? 4 : 0;
    }

    public int getOpenFieldCountOffset(ARecordType recordType) {
        return this.start + IntegerPointable.getInteger((byte[])this.bytes, (int)this.getOpenPartOffset(recordType));
    }

    public void getOpenFieldValue(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException, AsterixException {
        dOut.write(this.bytes, this.getOpenFieldValueOffset(recordType, fieldId), this.getOpenFieldValueSize(recordType, fieldId));
    }

    public int getOpenFieldValueOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldNameOffset(recordType, fieldId) + this.getOpenFieldNameSize(recordType, fieldId);
    }

    public int getOpenFieldValueSize(ARecordType recordType, int fieldId) throws HyracksDataException {
        int offset = this.getOpenFieldValueOffset(recordType, fieldId);
        ATypeTag tag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.getOpenFieldTag(recordType, fieldId));
        return NonTaggedFormatUtil.getFieldValueLength(this.bytes, offset, tag, true);
    }

    public void getOpenFieldName(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException {
        dOut.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        dOut.write(this.bytes, this.getOpenFieldNameOffset(recordType, fieldId), this.getOpenFieldNameSize(recordType, fieldId));
    }

    public int getOpenFieldNameSize(ARecordType recordType, int fieldId) {
        int utfleng = UTF8StringUtil.getUTFLength((byte[])this.bytes, (int)this.getOpenFieldNameOffset(recordType, fieldId));
        return utfleng + UTF8StringUtil.getNumBytesToStoreLength((int)utfleng);
    }

    public int getOpenFieldNameOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldOffset(recordType, fieldId);
    }

    public byte getOpenFieldTag(ARecordType recordType, int fieldId) {
        return this.bytes[this.getOpenFieldValueOffset(recordType, fieldId)];
    }

    public int getOpenFieldHash(ARecordType recordType, int fieldId) {
        return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getOpenFieldHashOffset(recordType, fieldId));
    }

    public int getOpenFieldHashOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldCountOffset(recordType) + this.getOpenFieldCountSize(recordType) + fieldId * 8;
    }

    public int getOpenFieldHashSize(ARecordType recordType, int fieldId) {
        return 4;
    }

    public int getOpenFieldOffset(ARecordType recordType, int fieldId) {
        return this.start + IntegerPointable.getInteger((byte[])this.bytes, (int)this.getOpenFieldOffsetOffset(recordType, fieldId));
    }

    public int getOpenFieldOffsetOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldHashOffset(recordType, fieldId) + this.getOpenFieldHashSize(recordType, fieldId);
    }

    public int getOpenFieldOffsetSize(ARecordType recordType, int fieldId) {
        return 4;
    }

    public static class ARecordPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        private ARecordPointableFactory() {
        }

        public ARecordPointable createPointable() {
            return new ARecordPointable();
        }

        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    }
}

