/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import java.io.IOException;
import org.apache.asterix.om.base.temporal.ICalendarSystem;

public class GregorianCalendarSystem
implements ICalendarSystem {
    public static final int[] DAYS_OF_MONTH_ORDI = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int[] DAYS_OF_MONTH_LEAP = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int[] DAYS_SINCE_MONTH_BEGIN_ORDI = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    public static final long CHRONON_OF_SECOND = 1000L;
    public static final long CHRONON_OF_MINUTE = 60000L;
    public static final long CHRONON_OF_HOUR = 3600000L;
    public static final long CHRONON_OF_DAY = 86400000L;
    public static final int MONTHS_IN_A_YEAR = 12;
    public static final int[] FIELD_MINS = new int[]{Integer.MIN_VALUE, 1, 1, 0, 0, 0, 0};
    public static final int[] FIELD_MAXS = new int[]{Integer.MAX_VALUE, 12, 31, 23, 59, 59, 999};
    public static final int TIMEZONE_HOUR_MIN = -12;
    public static final int TIMEZONE_HOUR_MAX = 14;
    public static final int TIMEZONE_MIN_MIN = -60;
    public static final int TIMEZONE_MIN_MAX = 60;
    private static final long CHRONON_OF_YEAR = 31556952000L;
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final GregorianCalendarSystem instance = new GregorianCalendarSystem();

    private GregorianCalendarSystem() {
    }

    public static GregorianCalendarSystem getInstance() {
        return instance;
    }

    public boolean validate(int year, int month, int day, int hour, int min, int sec, int millis) {
        if (year < FIELD_MINS[0] || year > FIELD_MAXS[0]) {
            return false;
        }
        if (month < FIELD_MINS[1] || month > FIELD_MAXS[1]) {
            return false;
        }
        if (day < FIELD_MINS[2] || day > FIELD_MAXS[2]) {
            return false;
        }
        if (hour < FIELD_MINS[3] || hour > FIELD_MAXS[3]) {
            return false;
        }
        if (min < FIELD_MINS[4] || min > FIELD_MAXS[4]) {
            return false;
        }
        if (sec < FIELD_MINS[5] || sec > FIELD_MAXS[5]) {
            return false;
        }
        if (millis < FIELD_MINS[6] || millis > FIELD_MAXS[6]) {
            return false;
        }
        return month != 2 || !(this.isLeapYear(year) ? day > DAYS_OF_MONTH_LEAP[1] : day > DAYS_OF_MONTH_ORDI[1]);
    }

    public boolean validateTimeZone(int timezone) {
        return (long)timezone >= -1036800000L && (long)timezone <= 1209600000L;
    }

    @Override
    public boolean validate(int year, int month, int day, int hour, int min, int sec, int millis, int timezone) {
        return this.validate(year, month, day, hour, min, sec, millis) && this.validateTimeZone(timezone);
    }

    @Override
    public long getChronon(int year, int month, int day, int hour, int min, int sec, int millis, int timezone) {
        long chrononTime = this.chrononizeBeginningOfYear(year) + (long)hour * 3600000L + (long)min * 60000L + (long)sec * 1000L + (long)millis + (long)timezone;
        chrononTime += (long)(day - 1 + DAYS_SINCE_MONTH_BEGIN_ORDI[month - 1]) * 86400000L;
        if (month > 2 && this.isLeapYear(year)) {
            chrononTime += 86400000L;
        }
        return chrononTime;
    }

    @Override
    public int getChronon(int hour, int min, int sec, int millis, int timezone) {
        long chrononTime = (long)hour * 3600000L + (long)min * 60000L + (long)sec * 1000L + (long)millis + (long)timezone;
        return (int)chrononTime;
    }

    public long adjustChrononByTimezone(long chronon, int timezone) {
        return chronon - (long)timezone;
    }

    public static int getChrononInDays(long chronon) {
        if (chronon >= 0L) {
            return (int)(chronon / 86400000L);
        }
        if (chronon % 86400000L != 0L) {
            return (int)(chronon / 86400000L - 1L);
        }
        return (int)(chronon / 86400000L);
    }

    public void getExtendStringRepUntilField(long chrononTime, int timezone, Appendable sbder, Fields startField, Fields untilField, boolean withTimezone) throws IOException {
        int year = this.getYear(chrononTime);
        int month = this.getMonthOfYear(chrononTime, year);
        switch (startField) {
            default: {
                sbder.append(String.format(year < 0 ? "%05d" : "%04d", year));
                if (untilField == Fields.YEAR) {
                    return;
                }
            }
            case MONTH: {
                if (startField != Fields.MONTH) {
                    sbder.append("-");
                }
                sbder.append(String.format("%02d", month));
                if (untilField == Fields.MONTH) {
                    return;
                }
            }
            case DAY: {
                if (startField != Fields.DAY) {
                    sbder.append("-");
                }
                sbder.append(String.format("%02d", this.getDayOfMonthYear(chrononTime, year, month)));
                if (untilField == Fields.DAY) break;
            }
            case HOUR: {
                if (startField != Fields.HOUR) {
                    sbder.append("T");
                }
                sbder.append(String.format("%02d", this.getHourOfDay(chrononTime)));
                if (untilField == Fields.HOUR) break;
            }
            case MINUTE: {
                if (startField != Fields.MINUTE) {
                    sbder.append(":");
                }
                sbder.append(String.format("%02d", this.getMinOfHour(chrononTime)));
                if (untilField == Fields.MINUTE) break;
            }
            case SECOND: {
                if (startField != Fields.SECOND) {
                    sbder.append(":");
                }
                sbder.append(String.format("%02d", this.getSecOfMin(chrononTime)));
                sbder.append(".").append(String.format("%03d", this.getMillisOfSec(chrononTime)));
            }
        }
        if (withTimezone) {
            if (timezone == 0) {
                sbder.append("Z");
            } else {
                int tzHr;
                int tzMin = (int)((long)timezone % 3600000L / 60000L);
                if (tzMin < 0) {
                    tzMin = (short)(-1 * tzMin);
                }
                sbder.append((tzHr = (int)((long)timezone / 3600000L)) >= 0 ? "-" : "+").append(String.format("%02d", tzHr < 0 ? -tzHr : tzHr)).append(":").append(String.format("%02d", tzMin));
            }
        }
    }

    public void getBasicStringRepUntilField(long chrononTime, int timezone, Appendable sbder, Fields startField, Fields untilField, boolean withTimezone) throws IOException {
        int year = this.getYear(chrononTime);
        int month = this.getMonthOfYear(chrononTime, year);
        switch (startField) {
            default: {
                sbder.append(String.format(year < 0 ? "%05d" : "%04d", year));
                if (untilField == Fields.YEAR) {
                    return;
                }
            }
            case MONTH: {
                sbder.append(String.format("%02d", month));
                if (untilField == Fields.MONTH) {
                    return;
                }
            }
            case DAY: {
                sbder.append(String.format("%02d", this.getDayOfMonthYear(chrononTime, year, month)));
                if (untilField == Fields.DAY) break;
            }
            case HOUR: {
                sbder.append(String.format("%02d", this.getHourOfDay(chrononTime)));
                if (untilField == Fields.HOUR) break;
            }
            case MINUTE: {
                sbder.append(String.format("%02d", this.getMinOfHour(chrononTime)));
                if (untilField == Fields.MINUTE) break;
            }
            case SECOND: {
                sbder.append(String.format("%02d", this.getSecOfMin(chrononTime)));
                sbder.append(String.format("%03d", this.getMillisOfSec(chrononTime)));
            }
        }
        if (withTimezone) {
            if (timezone == 0) {
                sbder.append("Z");
            } else {
                int tzHr;
                int tzMin = (int)((long)timezone % 3600000L / 60000L);
                if (tzMin < 0) {
                    tzMin = (short)(-1 * tzMin);
                }
                sbder.append((tzHr = (int)((long)timezone / 3600000L)) >= 0 ? "-" : "+").append(String.format("%02d", tzHr < 0 ? -tzHr : tzHr)).append(String.format("%02d", tzMin));
            }
        }
    }

    public void getDurationExtendStringRepWithTimezoneUntilField(long milliseconds, int months, StringBuilder sbder) {
        boolean positive = true;
        if (months < 0 || milliseconds < 0L) {
            months *= -1;
            milliseconds *= -1L;
            positive = false;
        }
        int month = this.getDurationMonth(months);
        int year = this.getDurationYear(months);
        int millisecond = this.getDurationMillisecond(milliseconds);
        int second = this.getDurationSecond(milliseconds);
        int minute = this.getDurationMinute(milliseconds);
        int hour = this.getDurationHour(milliseconds);
        int day = this.getDurationDay(milliseconds);
        if (!positive) {
            sbder.append("-");
        }
        sbder.append("P");
        sbder.append(year != 0 ? year + "Y" : "");
        sbder.append(month != 0 ? month + "M" : "");
        sbder.append(day != 0 ? day + "D" : "");
        sbder.append(hour != 0 || minute != 0 || second != 0 || millisecond != 0 ? "T" : "");
        sbder.append(hour != 0 ? hour + "H" : "");
        sbder.append(minute != 0 ? minute + "M" : "");
        sbder.append(second != 0 || millisecond != 0 ? Integer.valueOf(second) : "");
        if (millisecond > 0) {
            sbder.append("." + millisecond);
        }
        sbder.append(second != 0 || millisecond != 0 ? "S" : "");
    }

    public boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private long chrononizeBeginningOfYear(int year) {
        int leapYears = year / 100;
        if (year < 0) {
            leapYears = (year + 3 >> 2) - leapYears + (leapYears + 3 >> 2) - 1;
        } else {
            leapYears = (year >> 2) - leapYears + (leapYears >> 2);
            if (this.isLeapYear(year)) {
                --leapYears;
            }
        }
        return ((long)year * 365L + (long)(leapYears - 719527)) * 86400000L;
    }

    public int getYear(long chrononTime) {
        long oneYear;
        int year;
        long yearStart;
        long diff;
        long unitMillis = 15778476000L;
        long i2 = (chrononTime >> 1) + 31083597720000L;
        if (i2 < 0L) {
            i2 = i2 - unitMillis + 1L;
        }
        if ((diff = chrononTime - (yearStart = this.chrononizeBeginningOfYear(year = (int)(i2 / unitMillis)))) < 0L) {
            --year;
        } else if (diff >= 31536000000L && (yearStart += (oneYear = this.isLeapYear(year) ? 31622400000L : 31536000000L)) <= chrononTime) {
            ++year;
        }
        return year;
    }

    public int getMonthOfYear(long millis, int year) {
        int i = (int)(millis - this.chrononizeBeginningOfYear(year) >> 10);
        int leap = 0;
        if (this.isLeapYear(year)) {
            leap = 1;
        }
        if (i < (181 + leap) * 84375) {
            if (i < (90 + leap) * 84375) {
                if (i < 2615625) {
                    return 1;
                }
                if (i < (59 + leap) * 84375) {
                    return 2;
                }
                return 3;
            }
            if (i < (120 + leap) * 84375) {
                return 4;
            }
            if (i < (151 + leap) * 84375) {
                return 5;
            }
            return 6;
        }
        if (i < (273 + leap) * 84375) {
            if (i < (212 + leap) * 84375) {
                return 7;
            }
            if (i < (243 + leap) * 84375) {
                return 8;
            }
            return 9;
        }
        if (i < (304 + leap) * 84375) {
            return 10;
        }
        if (i < (334 + leap) * 84375) {
            return 11;
        }
        return 12;
    }

    public int getDayOfMonthYear(long millis, int year, int month) {
        long dateMillis = this.chrononizeBeginningOfYear(year);
        dateMillis += (long)DAYS_SINCE_MONTH_BEGIN_ORDI[month - 1] * 86400000L;
        if (this.isLeapYear(year) && month > 2) {
            dateMillis += 86400000L;
        }
        return (int)((millis - dateMillis) / 86400000L) + 1;
    }

    public int getHourOfDay(long millis) {
        int hour = (int)(millis % 86400000L / 3600000L);
        if (millis < 0L) {
            if (millis % 3600000L == 0L) {
                if (hour < 0) {
                    hour += 24;
                }
            } else {
                hour += 23;
            }
        }
        return hour;
    }

    public int getMinOfHour(long millis) {
        int min = (int)(millis % 3600000L / 60000L);
        if (millis < 0L) {
            if (millis % 60000L == 0L) {
                if (min < 0) {
                    min += 60;
                }
            } else {
                min += 59;
            }
        }
        return min;
    }

    public int getSecOfMin(long millis) {
        int sec = (int)(millis % 60000L / 1000L);
        if (millis < 0L) {
            if (millis % 1000L == 0L) {
                if (sec < 0) {
                    sec += 60;
                }
            } else {
                sec += 59;
            }
        }
        return sec;
    }

    public int getMillisOfSec(long millis) {
        int ms = (int)(millis % 1000L);
        if (millis < 0L && ms < 0) {
            ms += 1000;
        }
        return ms;
    }

    public int getDurationMonth(int months) {
        return months % 12;
    }

    public int getDurationYear(int months) {
        return months / 12;
    }

    public int getDurationMillisecond(long milliseconds) {
        return (int)(milliseconds % 1000L);
    }

    public int getDurationSecond(long milliseconds) {
        return (int)(milliseconds % 60000L / 1000L);
    }

    public int getDurationMinute(long milliseconds) {
        return (int)(milliseconds % 3600000L / 60000L);
    }

    public int getDurationHour(long milliseconds) {
        return (int)(milliseconds % 86400000L / 3600000L);
    }

    public int getDurationDay(long milliseconds) {
        return (int)(milliseconds / 86400000L);
    }

    public static enum Fields {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }
}

