/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TimeZone;
import org.apache.asterix.om.base.temporal.AsterixTemporalTypeParseException;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DateTimeFormatUtils {
    private static final GregorianCalendarSystem CAL;
    private static final Charset ENCODING;
    private static final char HOUR_CHAR = 'h';
    private static final char MINUTE_CHAR = 'm';
    private static final char SECOND_CHAR = 's';
    private static final char MILLISECOND_CHAR = 'n';
    private static final char AMPM_CHAR = 'a';
    private static final char TIMEZONE_CHAR = 'z';
    private static final int MAX_HOUR_CHARS = 2;
    private static final int MAX_MINUTE_CHARS = 2;
    private static final int MAX_SECOND_CHARS = 2;
    private static final int MAX_MILLISECOND_CHARS = 3;
    private static final int MAX_AMPM_CHARS = 1;
    private static final int MAX_TIMEZONE_CHARS = 1;
    private static final char YEAR_CHAR = 'Y';
    private static final char MONTH_CHAR = 'M';
    private static final char DAY_CHAR = 'D';
    private static final char WEEKDAY_CHAR = 'W';
    private static final int MAX_YEAR_CHARS = 4;
    private static final int MAX_MONTH_CHARS = 3;
    private static final int MAX_DAY_CHARS = 2;
    private static final int MAX_WEEKDAY_CHAR = 1;
    private static final byte[][] MONTH_NAMES;
    private static final byte[][] WEEKDAY_FULL_NAMES;
    private static final byte[] UTC_BYTEARRAY;
    private static final byte[] GMT_BYTEARRAY;
    private static final byte[] AM_BYTEARRAY;
    private static final byte[] PM_BYTEARRAY;
    private static final char HYPHEN_CHAR = '-';
    private static final char COLON_CHAR = ':';
    private static final char SOLIDUS_CHAR = '/';
    private static final char PERIOD_CHAR = '.';
    private static final char COMMA_CHAR = ',';
    private static final char T_CHAR = 'T';
    private static final char SKIPPER_CHAR = 'O';
    private static final int MAX_SKIPPER_CHAR = 1;
    private static final int MS_PER_MINUTE = 60000;
    private static final int MS_PER_HOUR = 3600000;
    private static final byte TO_LOWER_OFFSET = -32;
    private static final String[] TZ_IDS;
    private static Comparator<byte[]> byteArrayComparator;
    private static final byte[][] TIMEZONE_IDS;
    private static final int[] TIMEZONE_OFFSETS;

    private DateTimeFormatUtils() {
    }

    public static DateTimeFormatUtils getInstance() {
        return DateTimeFormatUtilsHolder.INSTANCE;
    }

    private int parseFormatField(byte[] format, int formatStart, int formatLength, int formatPointer, char formatChar, int maxAllowedFormatCharCopied) {
        int formatCharCopies = 0;
        ++formatPointer;
        ++formatCharCopies;
        while (formatPointer < formatLength && format[formatStart + formatPointer] == formatChar) {
            ++formatPointer;
            ++formatCharCopies;
        }
        if (formatCharCopies > maxAllowedFormatCharCopied) {
            throw new IllegalStateException("The format string for " + formatChar + " is too long: expected no more than " + maxAllowedFormatCharCopied + " but got " + formatCharCopies);
        }
        return formatCharCopies;
    }

    private boolean byteArrayEqualToString(byte[] barray, int start, int length, byte[] str) {
        if (length != str.length) {
            return false;
        }
        return this.byteArrayBeingWithString(barray, start, length, str);
    }

    private boolean byteArrayBeingWithString(byte[] barray, int start, int length, byte[] str) {
        boolean beginWith = true;
        if (length <= str.length) {
            for (int i = 0; i < length; ++i) {
                if (this.toLower(barray[start + i]) == str[i]) continue;
                beginWith = false;
                break;
            }
        } else {
            beginWith = false;
        }
        return beginWith;
    }

    private int monthIDSearch(byte[] barray, int start, int length) {
        for (int i = 0; i < MONTH_NAMES.length; ++i) {
            if (!this.byteArrayEqualToString(barray, start, length, MONTH_NAMES[i])) continue;
            return i;
        }
        return -1;
    }

    private int weekdayIDSearch(byte[] barray, int start, int length) {
        for (int i = 0; i < WEEKDAY_FULL_NAMES.length; ++i) {
            if (!this.byteArrayBeingWithString(barray, start, length, WEEKDAY_FULL_NAMES[i])) continue;
            return i;
        }
        return -1;
    }

    private int binaryTimezoneIDSearch(byte[] barray, int start, int length) {
        return Arrays.binarySearch(TIMEZONE_IDS, 0, TIMEZONE_IDS.length, Arrays.copyOfRange(barray, start, start + length), byteArrayComparator);
    }

    private int indexOf(byte[] barray, int start, int length, char c) {
        for (int i = 0; i < length; ++i) {
            if (barray[start + i] != c) continue;
            return i;
        }
        return -1;
    }

    private byte toLower(byte b) {
        if (b >= 65 && b <= 90) {
            return (byte)(b - -32);
        }
        return b;
    }

    private byte toUpper(byte b) {
        if (b >= 97 && b <= 122) {
            return (byte)(b + -32);
        }
        return b;
    }

    public long parseDateTime(byte[] data, int dataStart, int dataLength, byte[] format, int formatStart, int formatLength, DateTimeParseMode parseMode) throws AsterixTemporalTypeParseException {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int ms = 0;
        int timezone = 0;
        boolean negativeYear = false;
        int formatCharCopies = 0;
        int dataStringPointer = 0;
        int formatPointer = 0;
        byte separatorChar = 0;
        DateTimeProcessState processState = DateTimeProcessState.INIT;
        int pointerMove = 0;
        block30: while (dataStringPointer < dataLength && formatPointer < formatLength) {
            formatCharCopies = 0;
            switch (format[formatStart + formatPointer]) {
                case 89: {
                    processState = DateTimeProcessState.YEAR;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'Y', 4);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 77: {
                    processState = DateTimeProcessState.MONTH;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'M', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 68: {
                    processState = DateTimeProcessState.DAY;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'D', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 87: {
                    processState = DateTimeProcessState.WEEKDAY;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'W', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 104: {
                    processState = DateTimeProcessState.HOUR;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'h', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 109: {
                    processState = DateTimeProcessState.MINUTE;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'm', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 115: {
                    processState = DateTimeProcessState.SECOND;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 's', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 110: {
                    processState = DateTimeProcessState.MILLISECOND;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'n', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 97: {
                    processState = DateTimeProcessState.AMPM;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'a', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 122: {
                    processState = DateTimeProcessState.TIMEZONE;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'z', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 79: {
                    processState = DateTimeProcessState.SKIPPER;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'O', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 32: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 84: {
                    separatorChar = format[formatStart + formatPointer];
                    processState = DateTimeProcessState.SEPARATOR;
                    ++formatPointer;
                    ++formatCharCopies;
                    while (formatPointer < formatLength && format[formatStart + formatPointer] == separatorChar) {
                        ++formatPointer;
                        ++formatCharCopies;
                    }
                    break;
                }
                default: {
                    throw new AsterixTemporalTypeParseException("Unexpected date format string at " + (formatStart + formatPointer) + ": " + format[formatStart + formatPointer]);
                }
            }
            switch (processState) {
                case YEAR: 
                case MONTH: 
                case DAY: {
                    if (parseMode != DateTimeParseMode.TIME_ONLY) break;
                    throw new AsterixTemporalTypeParseException("Unexpected date format string when parsing a time value");
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: 
                case AMPM: 
                case TIMEZONE: {
                    if (parseMode != DateTimeParseMode.DATE_ONLY) break;
                    throw new AsterixTemporalTypeParseException("Unexpected time format string when parsing a date value");
                }
            }
            switch (processState) {
                case INIT: {
                    continue block30;
                }
                case YEAR: {
                    if (dataStringPointer < dataLength && data[dataStart + dataStringPointer] == 45) {
                        negativeYear = true;
                        ++dataStringPointer;
                    }
                }
                case DAY: {
                    int maxAllowedFormatCharCopies = processState == DateTimeProcessState.YEAR ? 4 : 2;
                    int parsedValue = 0;
                    int processedFieldsCount = 0;
                    for (int i = 0; i < formatCharCopies; ++i) {
                        if (data[dataStart + dataStringPointer] < 48 || data[dataStart + dataStringPointer] > 57) {
                            throw new AsterixTemporalTypeParseException("Unexpected char for year field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        ++processedFieldsCount;
                    }
                    while (processedFieldsCount < maxAllowedFormatCharCopies && dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        ++processedFieldsCount;
                    }
                    if (processState == DateTimeProcessState.YEAR) {
                        year = parsedValue;
                        if (!negativeYear) continue block30;
                        year *= -1;
                        continue block30;
                    }
                    day = parsedValue;
                    continue block30;
                }
                case MONTH: {
                    if (formatCharCopies == 3) {
                        int monthNameMatch = this.monthIDSearch(data, dataStart + dataStringPointer, 3);
                        if (monthNameMatch >= 0) {
                            month = monthNameMatch + 1;
                            dataStringPointer += 3;
                            continue block30;
                        }
                        throw new AsterixTemporalTypeParseException("Unrecognizable month string " + (char)data[dataStart + dataStringPointer] + " " + (char)data[dataStart + dataStringPointer + 1] + " " + (char)data[dataStart + dataStringPointer + 2]);
                    }
                    int processedMonthFieldsCount = 0;
                    for (int i = 0; i < formatCharCopies; ++i) {
                        if (data[dataStart + dataStringPointer] < 48 || data[dataStart + dataStringPointer] > 57) {
                            throw new AsterixTemporalTypeParseException("Unexpected char for month field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        month = month * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        if (processedMonthFieldsCount++ <= 2) continue;
                        throw new AsterixTemporalTypeParseException("Unexpected char for month field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                    }
                    while (processedMonthFieldsCount < 2 && dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        month = month * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        ++processedMonthFieldsCount;
                    }
                    continue block30;
                }
                case WEEKDAY: {
                    int processedWeekdayFieldsCount = 0;
                    while (data[dataStart + dataStringPointer + processedWeekdayFieldsCount] >= 97 && data[dataStart + dataStringPointer + processedWeekdayFieldsCount] <= 122 || data[dataStart + dataStringPointer + processedWeekdayFieldsCount] >= 65 && data[dataStart + dataStringPointer + processedWeekdayFieldsCount] <= 90) {
                        ++processedWeekdayFieldsCount;
                    }
                    if (this.weekdayIDSearch(data, dataStart + dataStringPointer, processedWeekdayFieldsCount) < 0) {
                        throw new AsterixTemporalTypeParseException("Unexpected string for day-of-week: " + new String(Arrays.copyOfRange(data, dataStart + dataStringPointer, dataStart + dataStringPointer + processedWeekdayFieldsCount)));
                    }
                    dataStringPointer += processedWeekdayFieldsCount;
                    continue block30;
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: {
                    int i;
                    int processFieldsCount = 0;
                    int expectedMaxCount = processState == DateTimeProcessState.MILLISECOND ? 3 : 2;
                    int parsedValue = 0;
                    for (i = 0; i < formatCharCopies; ++i) {
                        if (data[dataStart + dataStringPointer] < 48 || data[dataStart + dataStringPointer] > 57) {
                            throw new AsterixTemporalTypeParseException("Unexpected char for " + processState.name() + " field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        if (processFieldsCount++ <= expectedMaxCount) continue;
                        throw new AsterixTemporalTypeParseException("Unexpected char for " + processState.name() + " field at " + dataStringPointer + ": " + data[dataStart + dataStringPointer]);
                    }
                    while (processFieldsCount < expectedMaxCount && dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        ++processFieldsCount;
                    }
                    if (processState == DateTimeProcessState.HOUR) {
                        hour = parsedValue;
                        continue block30;
                    }
                    if (processState == DateTimeProcessState.MINUTE) {
                        min = parsedValue;
                        continue block30;
                    }
                    if (processState == DateTimeProcessState.SECOND) {
                        sec = parsedValue;
                        continue block30;
                    }
                    if (processState != DateTimeProcessState.MILLISECOND) continue block30;
                    ms = parsedValue;
                    for (i = processFieldsCount; i < 3; ++i) {
                        ms *= 10;
                    }
                    continue block30;
                }
                case TIMEZONE: {
                    int timezoneEndField;
                    if (data[dataStart + dataStringPointer] == 90 && (dataStringPointer + 1 >= dataLength || data[dataStart + dataStringPointer + 1] < 65 && data[dataStart + dataStringPointer + 1] > 90 && data[dataStart + dataStringPointer + 1] < 97 && data[dataStart + dataStringPointer + 1] > 122)) {
                        timezone = 0;
                        ++dataStringPointer;
                        continue block30;
                    }
                    if (data[dataStart + dataStringPointer] == 43 || data[dataStart + dataStringPointer] == 45 || dataStringPointer + 3 < dataLength && (data[dataStart + dataStringPointer + 3] == 43 || data[dataStart + dataStringPointer + 3] == 45)) {
                        int i;
                        if (dataStringPointer + 3 < dataLength && (this.byteArrayEqualToString(data, dataStart + dataStringPointer, 3, UTC_BYTEARRAY) || this.byteArrayEqualToString(data, dataStart + dataStringPointer, 3, GMT_BYTEARRAY))) {
                            dataStringPointer += 3;
                        }
                        boolean negativeTimeZone = false;
                        if (data[dataStart + dataStringPointer] == 45) {
                            negativeTimeZone = true;
                            ++dataStringPointer;
                        } else if (data[dataStart + dataStringPointer] == 43) {
                            ++dataStringPointer;
                        } else {
                            throw new AsterixTemporalTypeParseException("Incorrect timezone hour field: expecting sign + or - but got: " + data[dataStart + dataStringPointer]);
                        }
                        for (i = 0; i < 2; ++i) {
                            if (data[dataStart + dataStringPointer + i] >= 48 && data[dataStart + dataStringPointer + i] <= 57) {
                                timezone += (data[dataStart + dataStringPointer + i] - 48) * 3600000;
                                continue;
                            }
                            throw new AsterixTemporalTypeParseException("Unexpected character for timezone hour field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        if (data[dataStart + (dataStringPointer += 2)] == 58) {
                            ++dataStringPointer;
                        }
                        for (i = 0; i < 2; ++i) {
                            if (data[dataStart + dataStringPointer + i] >= 48 && data[dataStart + dataStringPointer + i] <= 57) {
                                timezone += (data[dataStart + dataStringPointer + i] - 48) * 60000;
                                continue;
                            }
                            throw new AsterixTemporalTypeParseException("Unexpected character for timezone minute field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        dataStringPointer += 2;
                        if (negativeTimeZone) continue block30;
                        timezone *= -1;
                        continue block30;
                    }
                    for (timezoneEndField = dataStringPointer; timezoneEndField < dataLength && (data[dataStart + timezoneEndField] >= 48 && data[dataStart + timezoneEndField] <= 57 || data[dataStart + timezoneEndField] >= 97 && data[dataStart + timezoneEndField] <= 122 || data[dataStart + timezoneEndField] >= 65 && data[dataStart + timezoneEndField] <= 90 || data[dataStart + timezoneEndField] == 47 || data[dataStart + timezoneEndField] == 95); ++timezoneEndField) {
                    }
                    int searchIdx = this.binaryTimezoneIDSearch(data, dataStart + dataStringPointer, timezoneEndField - dataStringPointer);
                    if (searchIdx < 0) {
                        throw new AsterixTemporalTypeParseException("Unexpected timezone string: " + new String(Arrays.copyOfRange(data, dataStart + dataStringPointer, dataStart + timezoneEndField)));
                    }
                    timezone = TIMEZONE_OFFSETS[searchIdx];
                    dataStringPointer = timezoneEndField;
                    continue block30;
                }
                case AMPM: {
                    if (dataStringPointer + 1 < dataLength) {
                        if (hour > 12 || hour <= 0) {
                            throw new IllegalStateException("Hour " + hour + " cannot be a time for AM.");
                        }
                        if (!this.byteArrayEqualToString(data, dataStart + dataStringPointer, 2, AM_BYTEARRAY)) {
                            if (this.byteArrayEqualToString(data, dataStart + dataStringPointer, 2, PM_BYTEARRAY)) {
                                if ((hour += 12) == 24) {
                                    hour = 0;
                                }
                            } else {
                                throw new AsterixTemporalTypeParseException("Unexpected string for AM/PM marker " + new String(Arrays.copyOfRange(data, dataStart + dataStringPointer, dataStart + dataStringPointer + 2)));
                            }
                        }
                        dataStringPointer += 2;
                        continue block30;
                    }
                    throw new AsterixTemporalTypeParseException("Cannot find valid AM/PM marker.");
                }
                case SKIPPER: {
                    while (data[dataStart + dataStringPointer] >= 97 && data[dataStart + dataStringPointer] <= 122 || data[dataStart + dataStringPointer] >= 65 && data[dataStart + dataStringPointer] <= 90 || data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        ++dataStringPointer;
                    }
                    continue block30;
                }
                case SEPARATOR: {
                    int i;
                    if (separatorChar == 0) {
                        throw new AsterixTemporalTypeParseException("Incorrect separator char in date string as " + data[dataStart + dataStringPointer]);
                    }
                    for (i = 0; i < formatCharCopies; ++i) {
                        if (data[dataStart + dataStringPointer] != separatorChar) {
                            throw new AsterixTemporalTypeParseException("Expecting separator " + separatorChar + " but got " + data[dataStart + dataStringPointer]);
                        }
                        ++dataStringPointer;
                    }
                    continue block30;
                }
            }
            throw new AsterixTemporalTypeParseException("Unexpected time format information when parsing a date value");
        }
        if (dataStringPointer < dataLength) {
            throw new AsterixTemporalTypeParseException("The given data string is not fully parsed by the given format string");
        }
        if (formatPointer < formatLength) {
            throw new AsterixTemporalTypeParseException("The given format string is not fully used for the given format string");
        }
        if (parseMode == DateTimeParseMode.TIME_ONLY) {
            return CAL.getChronon(hour, min, sec, ms, timezone);
        }
        return CAL.getChronon(year, month, day, hour, min, sec, ms, timezone);
    }

    public void printDateTime(long chronon, int timezone, byte[] format, int formatStart, int formatLength, Appendable appender, DateTimeParseMode parseMode) throws HyracksDataException {
        int year = CAL.getYear(chronon);
        int month = CAL.getMonthOfYear(chronon, year);
        int day = CAL.getDayOfMonthYear(chronon, year, month);
        int hour = CAL.getHourOfDay(chronon);
        int min = CAL.getMinOfHour(chronon);
        int sec = CAL.getSecOfMin(chronon);
        int ms = CAL.getMillisOfSec(chronon);
        int formatCharCopies = 0;
        int formatPointer = 0;
        byte separatorChar = 0;
        DateTimeProcessState processState = DateTimeProcessState.INIT;
        int pointerMove = 0;
        boolean usePM = false;
        if (this.indexOf(format, formatStart, formatLength, 'a') >= 0) {
            if (hour >= 12) {
                usePM = true;
                hour -= 12;
            }
            if (hour == 0) {
                hour = 12;
            }
        }
        block29: while (formatPointer < formatLength) {
            formatCharCopies = 0;
            switch (format[formatStart + formatPointer]) {
                case 89: {
                    processState = DateTimeProcessState.YEAR;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'Y', 4);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 77: {
                    processState = DateTimeProcessState.MONTH;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'M', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 68: {
                    processState = DateTimeProcessState.DAY;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'D', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 104: {
                    processState = DateTimeProcessState.HOUR;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'h', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 109: {
                    processState = DateTimeProcessState.MINUTE;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'm', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 115: {
                    processState = DateTimeProcessState.SECOND;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 's', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 110: {
                    processState = DateTimeProcessState.MILLISECOND;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'n', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 97: {
                    processState = DateTimeProcessState.AMPM;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'a', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 122: {
                    processState = DateTimeProcessState.TIMEZONE;
                    pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'z', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 32: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 84: {
                    separatorChar = format[formatStart + formatPointer];
                    processState = DateTimeProcessState.SEPARATOR;
                    ++formatPointer;
                    ++formatCharCopies;
                    while (formatPointer < formatLength && format[formatStart + formatPointer] == separatorChar) {
                        ++formatPointer;
                        ++formatCharCopies;
                    }
                    break;
                }
                default: {
                    throw new HyracksDataException("Unexpected format string at " + (formatStart + formatPointer) + ": " + format[formatStart + formatPointer]);
                }
            }
            switch (processState) {
                case YEAR: 
                case MONTH: 
                case DAY: {
                    if (parseMode != DateTimeParseMode.TIME_ONLY) break;
                    throw new HyracksDataException("Unexpected date format string when parsing a time value");
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: 
                case AMPM: 
                case TIMEZONE: {
                    if (parseMode != DateTimeParseMode.DATE_ONLY) break;
                    throw new HyracksDataException("Unexpected time format string when parsing a date value");
                }
            }
            try {
                switch (processState) {
                    case INIT: {
                        break;
                    }
                    case YEAR: {
                        if (year < 0) {
                            appender.append('-');
                            year *= -1;
                        }
                    }
                    case MONTH: {
                        if (processState == DateTimeProcessState.MONTH && formatCharCopies == 3) {
                            for (byte b : MONTH_NAMES[month - 1]) {
                                appender.append((char)this.toUpper(b));
                            }
                            continue block29;
                        }
                    }
                    case DAY: {
                        int val = 0;
                        val = processState == DateTimeProcessState.YEAR ? year : (processState == DateTimeProcessState.MONTH ? month : day);
                        String strVal = String.valueOf(val);
                        int valFieldCount = strVal.length();
                        for (int i = 0; i < formatCharCopies - valFieldCount; ++i) {
                            appender.append('0');
                        }
                        appender.append(strVal);
                        break;
                    }
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: {
                        int val = 0;
                        if (processState == DateTimeProcessState.HOUR) {
                            val = hour;
                        } else if (processState == DateTimeProcessState.MINUTE) {
                            val = min;
                        } else if (processState == DateTimeProcessState.SECOND) {
                            val = sec;
                        }
                        if (val < 10) {
                            for (int i = 0; i < formatCharCopies - 1; ++i) {
                                appender.append('0');
                            }
                        }
                        appender.append(String.valueOf(val));
                        break;
                    }
                    case MILLISECOND: {
                        String strMS = String.valueOf(ms);
                        int msFieldCount = strMS.length();
                        for (int i = 0; i < 3 - msFieldCount; ++i) {
                            appender.append('0');
                        }
                        if (formatCharCopies < 3) {
                            if (formatCharCopies == 1) {
                                if (ms % 100 == 0) {
                                    ms /= 100;
                                } else if (ms % 10 == 0) {
                                    ms /= 10;
                                }
                            } else if (ms % 10 == 0) {
                                ms /= 10;
                            }
                            appender.append(String.valueOf(ms));
                            break;
                        }
                        appender.append(strMS);
                        break;
                    }
                    case TIMEZONE: {
                        int timezoneField;
                        if (timezone == 0) {
                            appender.append('Z');
                            break;
                        }
                        if (timezone < 0) {
                            appender.append('-');
                            timezone *= -1;
                        }
                        if ((timezoneField = timezone / 3600000) < 10) {
                            appender.append('0');
                        }
                        appender.append(String.valueOf(timezoneField));
                        timezoneField = timezone % 3600000 / 60000;
                        if (timezoneField < 10) {
                            appender.append('0');
                        }
                        appender.append(String.valueOf(timezoneField));
                        break;
                    }
                    case AMPM: {
                        if (usePM) {
                            appender.append("PM");
                            break;
                        }
                        appender.append("AM");
                        break;
                    }
                    case SEPARATOR: {
                        if (separatorChar == 0) {
                            throw new HyracksDataException("Incorrect separator: separator char is not initialized properly!");
                        }
                        for (int i = 0; i < formatCharCopies; ++i) {
                            appender.append((char)separatorChar);
                        }
                        continue block29;
                    }
                    default: {
                        throw new HyracksDataException("Unexpected time state when printing a date value");
                    }
                }
            }
            catch (IOException ex) {
                throw new HyracksDataException((Throwable)ex);
            }
        }
    }

    static {
        int i;
        CAL = GregorianCalendarSystem.getInstance();
        ENCODING = Charset.forName("UTF-8");
        MONTH_NAMES = new byte[][]{"jan".getBytes(ENCODING), "feb".getBytes(ENCODING), "mar".getBytes(ENCODING), "apr".getBytes(ENCODING), "may".getBytes(ENCODING), "jun".getBytes(ENCODING), "jul".getBytes(ENCODING), "aug".getBytes(ENCODING), "sep".getBytes(ENCODING), "oct".getBytes(ENCODING), "nov".getBytes(ENCODING), "dec".getBytes(ENCODING)};
        WEEKDAY_FULL_NAMES = new byte[][]{"monday".getBytes(ENCODING), "tuesday".getBytes(ENCODING), "wednesday".getBytes(ENCODING), "thursday".getBytes(ENCODING), "friday".getBytes(ENCODING), "saturday".getBytes(ENCODING), "sunday".getBytes(ENCODING)};
        UTC_BYTEARRAY = "utc".getBytes(ENCODING);
        GMT_BYTEARRAY = "gmt".getBytes(ENCODING);
        AM_BYTEARRAY = "am".getBytes(ENCODING);
        PM_BYTEARRAY = "pm".getBytes(ENCODING);
        TZ_IDS = TimeZone.getAvailableIDs();
        byteArrayComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                int i;
                for (i = 0; i < o1.length && i < o2.length; ++i) {
                    if (o1[i] == o2[i]) continue;
                    return o1[i] - o2[i];
                }
                if (i < o1.length) {
                    return -1;
                }
                if (i < o2.length) {
                    return 1;
                }
                return 0;
            }
        };
        TIMEZONE_IDS = new byte[TZ_IDS.length][];
        for (i = 0; i < TIMEZONE_IDS.length; ++i) {
            DateTimeFormatUtils.TIMEZONE_IDS[i] = TZ_IDS[i].getBytes(ENCODING);
        }
        Arrays.sort(TIMEZONE_IDS, byteArrayComparator);
        TIMEZONE_OFFSETS = new int[TIMEZONE_IDS.length];
        for (i = 0; i < TIMEZONE_IDS.length; ++i) {
            DateTimeFormatUtils.TIMEZONE_OFFSETS[i] = TimeZone.getTimeZone(new String(TIMEZONE_IDS[i], ENCODING)).getRawOffset();
        }
    }

    public static enum DateTimeParseMode {
        DATE_ONLY,
        TIME_ONLY,
        DATETIME;

    }

    private static class DateTimeFormatUtilsHolder {
        private static final DateTimeFormatUtils INSTANCE = new DateTimeFormatUtils();

        private DateTimeFormatUtilsHolder() {
        }
    }

    private static enum DateTimeProcessState {
        INIT,
        YEAR,
        MONTH,
        DAY,
        WEEKDAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND,
        AMPM,
        TIMEZONE,
        SKIPPER,
        SEPARATOR;

    }
}

