/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class ATimeParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new ATimeParserFactory();
    private static final long serialVersionUID = 1L;
    private static final String timeErrorMessage = "Wrong Input Format for a Time Value";

    private ATimeParserFactory() {
    }

    public IValueParser createValueParser() {
        return new IValueParser(){

            public void parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                try {
                    out.writeInt(ATimeParserFactory.parseTimePart(buffer, start, length));
                }
                catch (IOException ex) {
                    throw new HyracksDataException((Throwable)ex);
                }
            }
        };
    }

    public static int parseTimePart(String timeString, int start, int length) throws HyracksDataException {
        int i;
        int offset = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int millis = 0;
        int timezone = 0;
        boolean isExtendedForm = false;
        if (timeString.charAt(start + offset + 2) == ':') {
            isExtendedForm = true;
        }
        if (isExtendedForm && (timeString.charAt(start + offset + 2) != ':' || timeString.charAt(start + offset + 5) != ':')) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: Missing colon in an extended time format.");
        }
        for (i = 0; i < 2; ++i) {
            if (timeString.charAt(start + offset + i) < '0' || timeString.charAt(start + offset + i) > '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in hour field");
            }
            hour = hour * 10 + timeString.charAt(start + offset + i) - 48;
        }
        if (hour < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.HOUR.ordinal()] || hour > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.HOUR.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: hour " + hour);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (timeString.charAt(start + offset + i) < '0' || timeString.charAt(start + offset + i) > '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in minute field");
            }
            min = min * 10 + timeString.charAt(start + offset + i) - 48;
        }
        if (min < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MINUTE.ordinal()] || min > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.MINUTE.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: min " + min);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (timeString.charAt(start + offset + i) < '0' || timeString.charAt(start + offset + i) > '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in second field");
            }
            sec = sec * 10 + timeString.charAt(start + offset + i) - 48;
        }
        if (sec < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.SECOND.ordinal()] || sec > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.SECOND.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: sec " + sec);
        }
        if (isExtendedForm && length > (offset += 2) && timeString.charAt(start + offset) == '.' || !isExtendedForm && length > offset) {
            offset += isExtendedForm ? 1 : 0;
            for (i = 0; i < 3 && offset + i < length && timeString.charAt(start + offset + i) >= '0' && timeString.charAt(start + offset + i) <= '9'; ++i) {
                millis = millis * 10 + timeString.charAt(start + offset + i) - 48;
            }
            offset += i;
            while (i < 3) {
                millis *= 10;
                ++i;
            }
            if (length > offset && timeString.charAt(start + offset) >= '0' && timeString.charAt(start + offset) <= '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: too many fields for millisecond.");
            }
        }
        if (length > offset) {
            timezone = ATimeParserFactory.parseTimezonePart(timeString, start + offset);
        }
        return GregorianCalendarSystem.getInstance().getChronon(hour, min, sec, millis, timezone);
    }

    public static int parseTimezonePart(String timeString, int start) throws HyracksDataException {
        int timezone = 0;
        if (timeString.charAt(start) != 'Z') {
            if (timeString.charAt(start) != '+' && timeString.charAt(start) != '-') {
                throw new HyracksDataException("Wrong timezone format: missing sign or missing colon for a time zone");
            }
            int timezoneHour = 0;
            int timezoneMinute = 0;
            for (int i = 0; i < 2; ++i) {
                if (timeString.charAt(start + 1 + i) < '0' || timeString.charAt(start + 1 + i) > '9') {
                    throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in timezone hour field");
                }
                timezoneHour = (short)(timezoneHour * 10 + timeString.charAt(start + 1 + i) - 48);
            }
            int temp_offset = timeString.charAt(start + 3) == ':' ? 1 : 0;
            for (int i = 0; i < 2; ++i) {
                if (timeString.charAt(start + temp_offset + 3 + i) < '0' || timeString.charAt(start + temp_offset + 3 + i) > '9') {
                    throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in timezone minute field");
                }
                timezoneMinute = (short)(timezoneMinute * 10 + timeString.charAt(start + temp_offset + 3 + i) - 48);
            }
            timezone = (int)((long)timezoneHour * 3600000L + (long)timezoneMinute * 60000L);
            if (timeString.charAt(start) == '+') {
                timezone *= -1;
            }
        }
        return timezone;
    }

    public static int parseTimePart(char[] timeString, int start, int length) throws HyracksDataException {
        int i;
        int offset = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int millis = 0;
        int timezone = 0;
        boolean isExtendedForm = false;
        if (timeString[start + offset + 2] == ':') {
            isExtendedForm = true;
        }
        if (isExtendedForm && (timeString[start + offset + 2] != ':' || timeString[start + offset + 5] != ':')) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: Missing colon in an extended time format.");
        }
        for (i = 0; i < 2; ++i) {
            if (timeString[start + offset + i] < '0' || timeString[start + offset + i] > '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in hour field");
            }
            hour = hour * 10 + timeString[start + offset + i] - 48;
        }
        if (hour < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.HOUR.ordinal()] || hour > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.HOUR.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: hour " + hour);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (timeString[start + offset + i] < '0' || timeString[start + offset + i] > '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in minute field");
            }
            min = min * 10 + timeString[start + offset + i] - 48;
        }
        if (min < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MINUTE.ordinal()] || min > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.MINUTE.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: min " + min);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (timeString[start + offset + i] < '0' || timeString[start + offset + i] > '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in second field");
            }
            sec = sec * 10 + timeString[start + offset + i] - 48;
        }
        if (sec < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.SECOND.ordinal()] || sec > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.SECOND.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: sec " + sec);
        }
        if (isExtendedForm && length > (offset += 2) && timeString[start + offset] == '.' || !isExtendedForm && length > offset) {
            offset += isExtendedForm ? 1 : 0;
            for (i = 0; i < 3 && offset + i < length && timeString[start + offset + i] >= '0' && timeString[start + offset + i] <= '9'; ++i) {
                millis = millis * 10 + timeString[start + offset + i] - 48;
            }
            offset += i;
            while (i < 3) {
                millis *= 10;
                ++i;
            }
            if (length > offset && timeString[start + offset] >= '0' && timeString[start + offset] <= '9') {
                throw new HyracksDataException("Wrong Input Format for a Time Value: too many fields for millisecond.");
            }
        }
        if (length > offset) {
            timezone = ATimeParserFactory.parseTimezonePart(timeString, start + offset);
        }
        return GregorianCalendarSystem.getInstance().getChronon(hour, min, sec, millis, timezone);
    }

    public static int parseTimezonePart(char[] timeString, int start) throws HyracksDataException {
        int timezone = 0;
        if (timeString[start] != 'Z') {
            if (timeString[start] != '+' && timeString[start] != '-') {
                throw new HyracksDataException("Wrong timezone format: missing sign or missing colon for a time zone");
            }
            int timezoneHour = 0;
            int timezoneMinute = 0;
            for (int i = 0; i < 2; ++i) {
                if (timeString[start + 1 + i] < '0' || timeString[start + 1 + i] > '9') {
                    throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in timezone hour field");
                }
                timezoneHour = (short)(timezoneHour * 10 + timeString[start + 1 + i] - 48);
            }
            int temp_offset = timeString[start + 3] == ':' ? 1 : 0;
            for (int i = 0; i < 2; ++i) {
                if (timeString[start + temp_offset + 3 + i] < '0' || timeString[start + temp_offset + 3 + i] > '9') {
                    throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in timezone minute field");
                }
                timezoneMinute = (short)(timezoneMinute * 10 + timeString[start + temp_offset + 3 + i] - 48);
            }
            timezone = (int)((long)timezoneHour * 3600000L + (long)timezoneMinute * 60000L);
            if (timeString[start] == '+') {
                timezone *= -1;
            }
        }
        return timezone;
    }

    public static int parseTimePart(byte[] timeString, int start, int length) throws HyracksDataException {
        int i;
        int offset = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int millis = 0;
        int timezone = 0;
        boolean isExtendedForm = false;
        if (timeString[start + offset + 2] == 58) {
            isExtendedForm = true;
        }
        if (isExtendedForm && (timeString[start + offset + 2] != 58 || timeString[start + offset + 5] != 58)) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: Missing colon in an extended time format.");
        }
        for (i = 0; i < 2; ++i) {
            if (timeString[start + offset + i] < 48 || timeString[start + offset + i] > 57) {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in hour field");
            }
            hour = hour * 10 + timeString[start + offset + i] - 48;
        }
        if (hour < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.HOUR.ordinal()] || hour > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.HOUR.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: hour " + hour);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (timeString[start + offset + i] < 48 || timeString[start + offset + i] > 57) {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in minute field");
            }
            min = min * 10 + timeString[start + offset + i] - 48;
        }
        if (min < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MINUTE.ordinal()] || min > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.MINUTE.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: min " + min);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (timeString[start + offset + i] < 48 || timeString[start + offset + i] > 57) {
                throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in second field");
            }
            sec = sec * 10 + timeString[start + offset + i] - 48;
        }
        if (sec < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.SECOND.ordinal()] || sec > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.SECOND.ordinal()]) {
            throw new HyracksDataException("Wrong Input Format for a Time Value: sec " + sec);
        }
        if (isExtendedForm && length > (offset += 2) && timeString[start + offset] == 46 || !isExtendedForm && length > offset) {
            offset += isExtendedForm ? 1 : 0;
            for (i = 0; i < 3 && offset + i < length && timeString[start + offset + i] >= 48 && timeString[start + offset + i] <= 57; ++i) {
                millis = millis * 10 + timeString[start + offset + i] - 48;
            }
            offset += i;
            while (i < 3) {
                millis *= 10;
                ++i;
            }
            if (length > offset && timeString[start + offset] >= 48 && timeString[start + offset] <= 57) {
                throw new HyracksDataException("Wrong Input Format for a Time Value: too many fields for millisecond.");
            }
        }
        if (length > offset) {
            timezone = ATimeParserFactory.parseTimezonePart(timeString, start + offset);
        }
        return GregorianCalendarSystem.getInstance().getChronon(hour, min, sec, millis, timezone);
    }

    public static int parseTimezonePart(byte[] timeString, int start) throws HyracksDataException {
        int timezone = 0;
        if (timeString[start] != 90) {
            if (timeString[start] != 43 && timeString[start] != 45) {
                throw new HyracksDataException("Wrong timezone format: missing sign or missing colon for a time zone");
            }
            int timezoneHour = 0;
            int timezoneMinute = 0;
            for (int i = 0; i < 2; ++i) {
                if (timeString[start + 1 + i] < 48 || timeString[start + 1 + i] > 57) {
                    throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in timezone hour field");
                }
                timezoneHour = (short)(timezoneHour * 10 + timeString[start + 1 + i] - 48);
            }
            int temp_offset = timeString[start + 3] == 58 ? 1 : 0;
            for (int i = 0; i < 2; ++i) {
                if (timeString[start + temp_offset + 3 + i] < 48 || timeString[start + temp_offset + 3 + i] > 57) {
                    throw new HyracksDataException("Wrong Input Format for a Time Value: Non-numeric value in timezone minute field");
                }
                timezoneMinute = (short)(timezoneMinute * 10 + timeString[start + temp_offset + 3 + i] - 48);
            }
            timezone = (int)((long)timezoneHour * 3600000L + (long)timezoneMinute * 60000L);
            if (timeString[start] == 43) {
                timezone *= -1;
            }
        }
        return timezone;
    }
}

