/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.AMutableDayTimeDuration;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.AMutableYearMonthDuration;
import org.apache.asterix.om.base.IAObject;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class ADurationParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new ADurationParserFactory();
    private static final long serialVersionUID = 1L;
    private static final String durationErrorMessage = "Wrong Input Format for a duration/year-month-duration/day-time-duration Value";
    private static final String onlyYearMonthErrorMessage = "Only year-month fields are allowed";
    private static final String onlyDayTimeErrorMessage = "Only day-time fields are allowed";
    private static final int DECIMAL_UNIT = 10;

    private ADurationParserFactory() {
    }

    public IValueParser createValueParser() {
        final AMutableDuration aMutableDuration = new AMutableDuration(0, 0L);
        return new IValueParser(){

            public void parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                ADurationParserFactory.parseDuration(buffer, start, length, aMutableDuration, ADurationParseOption.All);
                try {
                    out.writeInt(aMutableDuration.getMonths());
                    out.writeLong(aMutableDuration.getMilliseconds());
                }
                catch (IOException ex) {
                    throw new HyracksDataException((Throwable)ex);
                }
            }
        };
    }

    public static void parseDuration(final Object durationString, final int start, int length, IAObject mutableObject, ADurationParseOption parseOption) throws HyracksDataException {
        IStringAccessor charAccessor;
        int offset = 0;
        int value = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        State state = State.NOTHING_READ;
        if (durationString instanceof char[]) {
            charAccessor = new IStringAccessor(){

                @Override
                public char getCharAt(int index) {
                    return ((char[])durationString)[start + index];
                }
            };
        } else if (durationString instanceof byte[]) {
            charAccessor = new IStringAccessor(){

                @Override
                public char getCharAt(int index) {
                    return (char)((byte[])durationString)[start + index];
                }
            };
        } else if (durationString instanceof String) {
            charAccessor = new IStringAccessor(){

                @Override
                public char getCharAt(int index) {
                    return ((String)durationString).charAt(start + index);
                }
            };
        } else {
            throw new HyracksDataException(durationErrorMessage);
        }
        int sign = 1;
        if (charAccessor.getCharAt(offset) == '-') {
            ++offset;
            sign = -1;
        }
        if (charAccessor.getCharAt(offset) != 'P') {
            throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: Missing leading 'P'.");
        }
        ++offset;
        while (offset < length) {
            if (charAccessor.getCharAt(offset) >= '0' && charAccessor.getCharAt(offset) <= '9') {
                value = value * 10 + charAccessor.getCharAt(offset) - 48;
            } else {
                switch (charAccessor.getCharAt(offset)) {
                    case 'Y': {
                        if (state.compareTo(State.YEAR) < 0) {
                            if (parseOption == ADurationParseOption.DAY_TIME) {
                                throw new HyracksDataException(onlyDayTimeErrorMessage);
                            }
                            year = value;
                            state = State.YEAR;
                            break;
                        }
                        throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong YEAR feild.");
                    }
                    case 'M': {
                        if (state.compareTo(State.TIME) < 0) {
                            if (state.compareTo(State.MONTH) < 0) {
                                if (parseOption == ADurationParseOption.DAY_TIME) {
                                    throw new HyracksDataException(onlyDayTimeErrorMessage);
                                }
                                month = value;
                                state = State.MONTH;
                                break;
                            }
                            throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong MONTH field.");
                        }
                        if (state.compareTo(State.MIN) < 0) {
                            if (parseOption == ADurationParseOption.YEAR_MONTH) {
                                throw new HyracksDataException(onlyYearMonthErrorMessage);
                            }
                            minute = value;
                            state = State.MIN;
                            break;
                        }
                        throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong MIN field.");
                    }
                    case 'D': {
                        if (state.compareTo(State.DAY) < 0) {
                            if (parseOption == ADurationParseOption.YEAR_MONTH) {
                                throw new HyracksDataException(onlyYearMonthErrorMessage);
                            }
                            day = value;
                            state = State.DAY;
                            break;
                        }
                        throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong DAY field");
                    }
                    case 'T': {
                        if (state.compareTo(State.TIME) < 0) {
                            if (parseOption == ADurationParseOption.YEAR_MONTH) {
                                throw new HyracksDataException(onlyYearMonthErrorMessage);
                            }
                            state = State.TIME;
                            break;
                        }
                        throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong TIME field.");
                    }
                    case 'H': {
                        if (state.compareTo(State.HOUR) < 0) {
                            if (parseOption == ADurationParseOption.YEAR_MONTH) {
                                throw new HyracksDataException(onlyYearMonthErrorMessage);
                            }
                            hour = value;
                            state = State.HOUR;
                            break;
                        }
                        throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong HOUR field.");
                    }
                    case '.': {
                        if (state.compareTo(State.MILLISEC) < 0) {
                            if (parseOption == ADurationParseOption.YEAR_MONTH) {
                                throw new HyracksDataException(onlyYearMonthErrorMessage);
                            }
                            int i = 1;
                            while (offset + i < length && charAccessor.getCharAt(offset + i) >= '0' && charAccessor.getCharAt(offset + i) <= '9') {
                                if (i >= 4) {
                                    throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong MILLISECOND field.");
                                }
                                millisecond = millisecond * 10 + (charAccessor.getCharAt(offset + i) - 48);
                                ++i;
                            }
                            offset += i;
                            state = State.MILLISEC;
                        } else {
                            throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong MILLISECOND field.");
                        }
                    }
                    case 'S': {
                        if (state.compareTo(State.SEC) < 0) {
                            if (parseOption == ADurationParseOption.YEAR_MONTH) {
                                throw new HyracksDataException(onlyYearMonthErrorMessage);
                            }
                            second = value;
                            state = State.SEC;
                            break;
                        }
                        throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong SECOND field.");
                    }
                    default: {
                        throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: wrong format for duration.");
                    }
                }
                value = 0;
            }
            ++offset;
        }
        if (state.compareTo(State.TIME) == 0) {
            throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: no time fields after time separator.");
        }
        int totalMonths = sign * (year * 12 + month);
        long totalMilliseconds = (long)sign * ((long)day * 86400000L + (long)hour * 3600000L + (long)minute * 60000L + (long)second * 1000L + (long)millisecond);
        if (sign > 0) {
            if (totalMonths < 0) {
                throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: total number of months is beyond its max value (-2147483647 to 2147483647).");
            }
            if (totalMilliseconds < 0L) {
                throw new HyracksDataException("Wrong Input Format for a duration/year-month-duration/day-time-duration Value: total number of milliseconds is beyond its max value (-9223372036854775808 to 9223372036854775807).");
            }
        }
        if (mutableObject instanceof AMutableDuration) {
            ((AMutableDuration)mutableObject).setValue(totalMonths, totalMilliseconds);
        } else if (mutableObject instanceof AMutableYearMonthDuration) {
            ((AMutableYearMonthDuration)mutableObject).setMonths(totalMonths);
        } else if (mutableObject instanceof AMutableDayTimeDuration) {
            ((AMutableDayTimeDuration)mutableObject).setMilliseconds(totalMilliseconds);
        }
    }

    static interface IStringAccessor {
        public char getCharAt(int var1);
    }

    public static enum ADurationParseOption {
        YEAR_MONTH,
        DAY_TIME,
        All;

    }

    private static enum State {
        NOTHING_READ,
        YEAR,
        MONTH,
        DAY,
        TIME,
        HOUR,
        MIN,
        MILLISEC,
        SEC;

    }
}

