/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class AYearMonthDuration
implements IAObject {
    protected int chrononInMonth;

    public AYearMonthDuration(int months) {
        this.chrononInMonth = months;
    }

    public int getMonths() {
        return this.chrononInMonth;
    }

    public String toString() {
        StringBuilder sbder = new StringBuilder();
        sbder.append("year_month_duration: {");
        GregorianCalendarSystem.getInstance().getDurationMonth(this.chrononInMonth);
        sbder.append(" }");
        return sbder.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ObjectNode duration = om.createObjectNode();
        duration.put("months", this.chrononInMonth);
        json.set("ADuration", (JsonNode)duration);
        return json;
    }

    @Override
    public IAType getType() {
        return BuiltinType.AYEARMONTHDURATION;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AYearMonthDuration) {
            return ((AYearMonthDuration)o).chrononInMonth == this.chrononInMonth;
        }
        return false;
    }

    public int hashCode() {
        return this.chrononInMonth;
    }
}

