/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.om.base.APoint3D;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;

public class APoint3DSerializerDeserializer
implements ISerializerDeserializer<APoint3D> {
    private static final long serialVersionUID = 1L;
    public static final APoint3DSerializerDeserializer INSTANCE = new APoint3DSerializerDeserializer();

    private APoint3DSerializerDeserializer() {
    }

    public APoint3D deserialize(DataInput in) throws HyracksDataException {
        double x = DoubleSerializerDeserializer.read((DataInput)in);
        double y = DoubleSerializerDeserializer.read((DataInput)in);
        double z = DoubleSerializerDeserializer.read((DataInput)in);
        return new APoint3D(x, y, z);
    }

    public void serialize(APoint3D instance, DataOutput out) throws HyracksDataException {
        DoubleSerializerDeserializer.write((double)instance.getX(), (DataOutput)out);
        DoubleSerializerDeserializer.write((double)instance.getY(), (DataOutput)out);
        DoubleSerializerDeserializer.write((double)instance.getZ(), (DataOutput)out);
    }

    public static final int getCoordinateOffset(Coordinate coordinate) throws HyracksDataException {
        switch (coordinate) {
            case X: {
                return 1;
            }
            case Y: {
                return 9;
            }
            case Z: {
                return 17;
            }
        }
        throw new HyracksDataException("Wrong coordinate");
    }
}

