/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.hash;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.FloatToDoubleTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToDoubleTypeConvertComputer;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.MurmurHash3BinaryHash;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class AMurmurHash3BinaryHashFunctionFamily
implements IBinaryHashFunctionFamily {
    public static final IBinaryHashFunctionFamily INSTANCE = new AMurmurHash3BinaryHashFunctionFamily();
    private static final long serialVersionUID = 1L;

    private AMurmurHash3BinaryHashFunctionFamily() {
    }

    public IBinaryHashFunction createBinaryHashFunction(final int seed) {
        return new IBinaryHashFunction(){
            private ArrayBackedValueStorage fieldValueBuffer = new ArrayBackedValueStorage();
            private DataOutput fieldValueBufferOutput = this.fieldValueBuffer.getDataOutput();
            private ATypeTag sourceTag = null;
            private boolean numericTypePromotionApplied = false;

            public int hash(byte[] bytes, int offset, int length) throws HyracksDataException {
                this.fieldValueBuffer.reset();
                this.sourceTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
                switch (this.sourceTag) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: {
                        try {
                            IntegerToDoubleTypeConvertComputer.getInstance().convertType(bytes, offset + 1, length - 1, this.fieldValueBufferOutput);
                        }
                        catch (IOException e) {
                            throw new HyracksDataException("A numeric type promotion error has occurred before doing hash(). Can't continue process. Detailed Error message:" + e.getMessage());
                        }
                        this.numericTypePromotionApplied = true;
                        break;
                    }
                    case FLOAT: {
                        try {
                            FloatToDoubleTypeConvertComputer.getInstance().convertType(bytes, offset + 1, length - 1, this.fieldValueBufferOutput);
                        }
                        catch (IOException e) {
                            throw new HyracksDataException("A numeric type promotion error has occurred before doing hash(). Can't continue process. Detailed Error message:" + e.getMessage());
                        }
                        this.numericTypePromotionApplied = true;
                        break;
                    }
                    default: {
                        this.numericTypePromotionApplied = false;
                    }
                }
                if (this.numericTypePromotionApplied) {
                    return MurmurHash3BinaryHash.hash((byte[])this.fieldValueBuffer.getByteArray(), (int)this.fieldValueBuffer.getStartOffset(), (int)this.fieldValueBuffer.getLength(), (int)seed);
                }
                return MurmurHash3BinaryHash.hash((byte[])bytes, (int)offset, (int)length, (int)seed);
            }
        };
    }
}

