/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.comm.channels;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.IBufferAcceptor;
import org.apache.hyracks.api.comm.IBufferFactory;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.ICloseableBufferAcceptor;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;
import org.apache.hyracks.comm.channels.ReadBufferFactory;

public class NetworkInputChannel
implements IInputChannel {
    private static final Logger LOGGER = Logger.getLogger(NetworkInputChannel.class.getName());
    static final int INITIAL_MESSAGE_SIZE = 20;
    private final IChannelConnectionFactory netManager;
    private final SocketAddress remoteAddress;
    private final PartitionId partitionId;
    private final Queue<ByteBuffer> fullQueue;
    private final int nBuffers;
    private IChannelControlBlock ccb;
    private IInputChannelMonitor monitor;
    private Object attachment;

    public NetworkInputChannel(IChannelConnectionFactory netManager, SocketAddress remoteAddress, PartitionId partitionId, int nBuffers) {
        this.netManager = netManager;
        this.remoteAddress = remoteAddress;
        this.partitionId = partitionId;
        this.fullQueue = new ArrayDeque<ByteBuffer>(nBuffers);
        this.nBuffers = nBuffers;
    }

    public void registerMonitor(IInputChannelMonitor monitor) {
        this.monitor = monitor;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public synchronized ByteBuffer getNextBuffer() {
        return this.fullQueue.poll();
    }

    public void recycleBuffer(ByteBuffer buffer) {
        buffer.clear();
        this.ccb.getReadInterface().getEmptyBufferAcceptor().accept(buffer);
    }

    public void open(IHyracksCommonContext ctx) throws HyracksDataException {
        try {
            this.ccb = this.netManager.connect(this.remoteAddress);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.ccb.getReadInterface().setFullBufferAcceptor((ICloseableBufferAcceptor)new ReadFullBufferAcceptor());
        this.ccb.getWriteInterface().setEmptyBufferAcceptor((IBufferAcceptor)new WriteEmptyBufferAcceptor());
        this.ccb.getReadInterface().setBufferFactory((IBufferFactory)new ReadBufferFactory(this.nBuffers, ctx), this.nBuffers, ctx.getInitialFrameSize());
        ByteBuffer writeBuffer = ByteBuffer.allocate(20);
        writeBuffer.putLong(this.partitionId.getJobId().getId());
        writeBuffer.putInt(this.partitionId.getConnectorDescriptorId().getId());
        writeBuffer.putInt(this.partitionId.getSenderIndex());
        writeBuffer.putInt(this.partitionId.getReceiverIndex());
        writeBuffer.flip();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sending partition request: " + this.partitionId + " on channel: " + this.ccb);
        }
        this.ccb.getWriteInterface().getFullBufferAcceptor().accept(writeBuffer);
        this.ccb.getWriteInterface().getFullBufferAcceptor().close();
    }

    public void close() throws HyracksDataException {
    }

    private class WriteEmptyBufferAcceptor
    implements IBufferAcceptor {
        private WriteEmptyBufferAcceptor() {
        }

        public void accept(ByteBuffer buffer) {
        }
    }

    private class ReadFullBufferAcceptor
    implements ICloseableBufferAcceptor {
        private ReadFullBufferAcceptor() {
        }

        public void accept(ByteBuffer buffer) {
            NetworkInputChannel.this.fullQueue.add(buffer);
            NetworkInputChannel.this.monitor.notifyDataAvailability((IInputChannel)NetworkInputChannel.this, 1);
        }

        public void close() {
            NetworkInputChannel.this.monitor.notifyEndOfStream((IInputChannel)NetworkInputChannel.this);
        }

        public void error(int ecode) {
            NetworkInputChannel.this.monitor.notifyFailure((IInputChannel)NetworkInputChannel.this);
        }
    }
}

