/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class SplitsAndConstraintsUtil {
    private SplitsAndConstraintsUtil() {
    }

    private static FileSplit[] getDataverseSplits(String dataverseName) {
        File relPathFile = new File(dataverseName);
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        ClusterPartition[] clusterPartition = ClusterStateManager.INSTANCE.getClusterPartitons();
        String storageDirName = ClusterProperties.INSTANCE.getStorageDirectoryName();
        for (int j = 0; j < clusterPartition.length; ++j) {
            File f = new File(StoragePathUtil.prepareStoragePartitionPath((String)storageDirName, (int)clusterPartition[j].getPartitionId()) + File.separator + relPathFile);
            splits.add(StoragePathUtil.getFileSplitForClusterPartition((ClusterPartition)clusterPartition[j], (String)f.getPath()));
        }
        return splits.toArray(new FileSplit[0]);
    }

    public static FileSplit[] getIndexSplits(Dataset dataset, String indexName, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        try {
            NodeGroup nodeGroup = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, dataset.getNodeGroupName());
            if (nodeGroup == null) {
                throw new AlgebricksException("Couldn't find node group " + dataset.getNodeGroupName());
            }
            List<String> nodeList = nodeGroup.getNodeNames();
            return SplitsAndConstraintsUtil.getIndexSplits(dataset, indexName, nodeList);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)me);
        }
    }

    public static FileSplit[] getIndexSplits(Dataset dataset, String indexName, List<String> nodes) {
        File relPathFile = new File(StoragePathUtil.prepareDataverseIndexName((String)dataset.getDataverseName(), (String)dataset.getDatasetName(), (String)indexName, (long)dataset.getRebalanceCount()));
        String storageDirName = ClusterProperties.INSTANCE.getStorageDirectoryName();
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (String nd : nodes) {
            int numPartitions = ClusterStateManager.INSTANCE.getNodePartitionsCount(nd);
            ClusterPartition[] nodePartitions = ClusterStateManager.INSTANCE.getNodePartitions(nd);
            if (dataset.getNodeGroupName().compareTo("MetadataGroup") == 0) {
                numPartitions = 1;
            }
            for (int k = 0; k < numPartitions; ++k) {
                File f = new File(StoragePathUtil.prepareStoragePartitionPath((String)storageDirName, (int)nodePartitions[k].getPartitionId()) + (dataset.isTemp() ? File.separator + "temp" : "") + File.separator + relPathFile);
                splits.add(StoragePathUtil.getFileSplitForClusterPartition((ClusterPartition)nodePartitions[k], (String)f.getPath()));
            }
        }
        return splits.toArray(new FileSplit[0]);
    }

    public static Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getDataverseSplitProviderAndConstraints(String dataverse) {
        FileSplit[] splits = SplitsAndConstraintsUtil.getDataverseSplits(dataverse);
        return StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
    }

    public static String getIndexPath(String partitionPath, int partition, String dataverse, String fullIndexName) {
        String storageDirName = ClusterProperties.INSTANCE.getStorageDirectoryName();
        return partitionPath + StoragePathUtil.prepareStoragePartitionPath((String)storageDirName, (int)partition) + File.separator + StoragePathUtil.prepareDataverseIndexName((String)dataverse, (String)fullIndexName);
    }
}

