/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.metadata.IMetadataLock;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.metadata.lock.DatasetLock;
import org.apache.asterix.metadata.lock.MetadataLock;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class MetadataLockManager
implements IMetadataLockManager {
    private static final Function<String, MetadataLock> LOCK_FUNCTION = MetadataLock::new;
    private static final Function<String, DatasetLock> DATASET_LOCK_FUNCTION = DatasetLock::new;
    private final ConcurrentHashMap<String, IMetadataLock> mdlocks = new ConcurrentHashMap();
    private static final String DATAVERSE_PREFIX = "Dataverse:";
    private static final String DATASET_PREFIX = "Dataset:";
    private static final String FUNCTION_PREFIX = "Function:";
    private static final String NODE_GROUP_PREFIX = "NodeGroup:";
    private static final String ACTIVE_PREFIX = "Active:";
    private static final String FEED_POLICY_PREFIX = "FeedPolicy:";
    private static final String MERGE_POLICY_PREFIX = "MergePolicy:";
    private static final String DATATYPE_PREFIX = "DataType:";
    private static final String EXTENSION_PREFIX = "Extension:";

    public void acquireDataverseReadLock(LockList locks, String dataverseName) throws AsterixException {
        String key = DATAVERSE_PREFIX + dataverseName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataverseWriteLock(LockList locks, String dataverseName) throws AsterixException {
        String key = DATAVERSE_PREFIX + dataverseName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDatasetReadLock(LockList locks, String datasetName) throws AsterixException {
        String key = DATASET_PREFIX + datasetName;
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, (IMetadataLock)lock);
    }

    public void acquireDatasetWriteLock(LockList locks, String datasetName) throws AsterixException {
        String key = DATASET_PREFIX + datasetName;
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, (IMetadataLock)lock);
    }

    public void acquireDatasetModifyLock(LockList locks, String datasetName) throws AsterixException {
        String key = DATASET_PREFIX + datasetName;
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.MODIFY, (IMetadataLock)lock);
    }

    public void acquireDatasetCreateIndexLock(LockList locks, String datasetName) throws AsterixException {
        String dsKey = DATASET_PREFIX + datasetName;
        DatasetLock lock = this.mdlocks.computeIfAbsent(dsKey, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.INDEX_BUILD, (IMetadataLock)lock);
    }

    public void acquireDatasetExclusiveModificationLock(LockList locks, String datasetName) throws AsterixException {
        String key = DATASET_PREFIX + datasetName;
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.EXCLUSIVE_MODIFY, (IMetadataLock)lock);
    }

    public void acquireFunctionReadLock(LockList locks, String functionName) throws AsterixException {
        String key = FUNCTION_PREFIX + functionName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFunctionWriteLock(LockList locks, String functionName) throws AsterixException {
        String key = FUNCTION_PREFIX + functionName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireNodeGroupReadLock(LockList locks, String nodeGroupName) throws AsterixException {
        String key = NODE_GROUP_PREFIX + nodeGroupName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireNodeGroupWriteLock(LockList locks, String nodeGroupName) throws AsterixException {
        String key = NODE_GROUP_PREFIX + nodeGroupName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireActiveEntityReadLock(LockList locks, String entityName) throws AsterixException {
        String key = ACTIVE_PREFIX + entityName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireActiveEntityWriteLock(LockList locks, String entityName) throws AsterixException {
        String key = ACTIVE_PREFIX + entityName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedPolicyWriteLock(LockList locks, String feedPolicyName) throws AsterixException {
        String key = FEED_POLICY_PREFIX + feedPolicyName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedPolicyReadLock(LockList locks, String feedPolicyName) throws AsterixException {
        String key = FEED_POLICY_PREFIX + feedPolicyName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireMergePolicyReadLock(LockList locks, String mergePolicyName) throws AsterixException {
        String key = MERGE_POLICY_PREFIX + mergePolicyName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireMergePolicyWriteLock(LockList locks, String mergePolicyName) throws AsterixException {
        String key = MERGE_POLICY_PREFIX + mergePolicyName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDataTypeReadLock(LockList locks, String datatypeName) throws AsterixException {
        String key = DATATYPE_PREFIX + datatypeName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataTypeWriteLock(LockList locks, String datatypeName) throws AsterixException {
        String key = DATATYPE_PREFIX + datatypeName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireExtensionReadLock(LockList locks, String extension, String entityName) throws AsterixException {
        String key = EXTENSION_PREFIX + extension + entityName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireExtensionWriteLock(LockList locks, String extension, String entityName) throws AsterixException {
        String key = EXTENSION_PREFIX + extension + entityName;
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void upgradeDatasetLockToWrite(LockList locks, String fullyQualifiedName) throws AlgebricksException {
        String key = DATASET_PREFIX + fullyQualifiedName;
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.upgrade(IMetadataLock.Mode.UPGRADED_WRITE, (IMetadataLock)lock);
    }

    public void downgradeDatasetLockToExclusiveModify(LockList locks, String fullyQualifiedName) throws AlgebricksException {
        String key = DATASET_PREFIX + fullyQualifiedName;
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.downgrade(IMetadataLock.Mode.EXCLUSIVE_MODIFY, (IMetadataLock)lock);
    }
}

