/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.dataflow.LSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.external.adapter.factory.LookupAdapterFactory;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalBTreeSearchOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalLookupOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalRTreeSearchOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.LinearizeComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.FileSplitDataSink;
import org.apache.asterix.metadata.declared.FileSplitSinkId;
import org.apache.asterix.metadata.declared.MetadataManagerUtil;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.SplitsAndConstraintsUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.base.AsterixTupleFilterFactory;
import org.apache.asterix.runtime.formats.FormatUtils;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.runtime.operators.LSMSecondaryUpsertOperatorDescriptor;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.SinkWriterRuntimeFactory;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IResultSerializerFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.ShortSerializerDeserializer;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.result.ResultWriterOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.BinaryTokenizerOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.rtree.dataflow.RTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.common.IStorageManager;

public class MetadataProvider
implements IMetadataProvider<DataSourceId, String> {
    private final ICcApplicationContext appCtx;
    private final IStorageComponentProvider storageComponentProvider;
    private final StorageProperties storageProperties;
    private final Dataverse defaultDataverse;
    private final LockList locks;
    private MetadataTransactionContext mdTxnCtx;
    private boolean isWriteTransaction;
    private Map<String, String> config;
    private IAWriterFactory writerFactory;
    private FileSplit outputFile;
    private boolean asyncResults;
    private ResultSetId resultSetId;
    private IResultSerializerFactoryProvider resultSerializerFactoryProvider;
    private JobId jobId;
    private Map<String, Integer> externalDataLocks;
    private boolean isTemporaryDatasetWriteJob = true;
    private boolean blockingOperatorDisabled = false;

    public MetadataProvider(ICcApplicationContext appCtx, Dataverse defaultDataverse) {
        this.appCtx = appCtx;
        this.defaultDataverse = defaultDataverse;
        this.storageComponentProvider = appCtx.getStorageComponentProvider();
        this.storageProperties = appCtx.getStorageProperties();
        this.locks = new LockList();
    }

    public String getPropertyValue(String propertyName) {
        return this.config.get(propertyName);
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public void disableBlockingOperator() {
        this.blockingOperatorDisabled = true;
    }

    public boolean isBlockingOperatorDisabled() {
        return this.blockingOperatorDisabled;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public Dataverse getDefaultDataverse() {
        return this.defaultDataverse;
    }

    public String getDefaultDataverseName() {
        return this.defaultDataverse == null ? null : this.defaultDataverse.getDataverseName();
    }

    public void setWriteTransaction(boolean writeTransaction) {
        this.isWriteTransaction = writeTransaction;
    }

    public void setWriterFactory(IAWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void setMetadataTxnContext(MetadataTransactionContext mdTxnCtx) {
        this.mdTxnCtx = mdTxnCtx;
    }

    public MetadataTransactionContext getMetadataTxnContext() {
        return this.mdTxnCtx;
    }

    public IAWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public FileSplit getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(FileSplit outputFile) {
        this.outputFile = outputFile;
    }

    public boolean getResultAsyncMode() {
        return this.asyncResults;
    }

    public void setResultAsyncMode(boolean asyncResults) {
        this.asyncResults = asyncResults;
    }

    public ResultSetId getResultSetId() {
        return this.resultSetId;
    }

    public void setResultSetId(ResultSetId resultSetId) {
        this.resultSetId = resultSetId;
    }

    public void setResultSerializerFactoryProvider(IResultSerializerFactoryProvider rafp) {
        this.resultSerializerFactoryProvider = rafp;
    }

    public IResultSerializerFactoryProvider getResultSerializerFactoryProvider() {
        return this.resultSerializerFactoryProvider;
    }

    public boolean isWriteTransaction() {
        return this.isWriteTransaction;
    }

    public boolean isTemporaryDatasetWriteJob() {
        return this.isTemporaryDatasetWriteJob;
    }

    public IDataFormat getFormat() {
        return FormatUtils.getDefaultFormat();
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public Map<String, Integer> getExternalDataLocks() {
        return this.externalDataLocks;
    }

    public void setExternalDataLocks(Map<String, Integer> locks) {
        this.externalDataLocks = locks;
    }

    public ARecordType findOutputRecordType() throws AlgebricksException {
        return MetadataManagerUtil.findOutputRecordType(this.mdTxnCtx, this.getDefaultDataverseName(), this.getPropertyValue("output-record-type"));
    }

    public Dataset findDataset(String dataverse, String dataset) throws AlgebricksException {
        String dv;
        Object object = dataverse == null ? (this.defaultDataverse == null ? null : this.defaultDataverse.getDataverseName()) : (dv = dataverse);
        if (dv == null) {
            return null;
        }
        String fqName = dv + '.' + dataset;
        this.appCtx.getMetadataLockManager().acquireDataverseReadLock(this.locks, dv);
        this.appCtx.getMetadataLockManager().acquireDatasetReadLock(this.locks, fqName);
        return MetadataManagerUtil.findDataset(this.mdTxnCtx, dv, dataset);
    }

    public INodeDomain findNodeDomain(String nodeGroupName) throws AlgebricksException {
        return MetadataManagerUtil.findNodeDomain(this.mdTxnCtx, nodeGroupName);
    }

    public List<String> findNodes(String nodeGroupName) throws AlgebricksException {
        return MetadataManagerUtil.findNodes(this.mdTxnCtx, nodeGroupName);
    }

    public IAType findType(String dataverse, String typeName) throws AlgebricksException {
        return MetadataManagerUtil.findType(this.mdTxnCtx, dataverse, typeName);
    }

    public IAType findType(Dataset dataset) throws AlgebricksException {
        return this.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
    }

    public IAType findMetaType(Dataset dataset) throws AlgebricksException {
        return this.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
    }

    public Feed findFeed(String dataverse, String feedName) throws AlgebricksException {
        return MetadataManagerUtil.findFeed(this.mdTxnCtx, dataverse, feedName);
    }

    public FeedConnection findFeedConnection(String dataverseName, String feedName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.findFeedConnection(this.mdTxnCtx, dataverseName, feedName, datasetName);
    }

    public FeedPolicyEntity findFeedPolicy(String dataverse, String policyName) throws AlgebricksException {
        return MetadataManagerUtil.findFeedPolicy(this.mdTxnCtx, dataverse, policyName);
    }

    public DataSource findDataSource(DataSourceId id) throws AlgebricksException {
        return MetadataManagerUtil.findDataSource(this.mdTxnCtx, id);
    }

    public DataSource lookupSourceInMetadata(DataSourceId aqlId) throws AlgebricksException {
        return MetadataManagerUtil.lookupSourceInMetadata(this.mdTxnCtx, aqlId);
    }

    public IDataSourceIndex<String, DataSourceId> findDataSourceIndex(String indexId, DataSourceId dataSourceId) throws AlgebricksException {
        DataSource source = this.findDataSource(dataSourceId);
        Dataset dataset = ((DatasetDataSource)source).getDataset();
        String indexName = indexId;
        Index secondaryIndex = this.getIndex(dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        return secondaryIndex != null ? new DataSourceIndex(secondaryIndex, dataset.getDataverseName(), dataset.getDatasetName(), this) : null;
    }

    public Index getIndex(String dataverseName, String datasetName, String indexName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataverseName, datasetName, indexName);
    }

    public List<Index> getDatasetIndexes(String dataverseName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.getDatasetIndexes(this.mdTxnCtx, dataverseName, datasetName);
    }

    public IFunctionInfo lookupFunction(FunctionIdentifier fid) {
        return BuiltinFunctions.lookupFunction((FunctionIdentifier)fid);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getScannerRuntime(IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig) throws AlgebricksException {
        try {
            return ((DataSource)dataSource).buildDatasourceScanRuntime(this, dataSource, scanVariables, projectVariables, projectPushed, minFilterVars, maxFilterVars, opSchema, typeEnv, context, jobSpec, implConfig);
        }
        catch (AsterixException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    protected Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildLoadableDatasetScan(JobSpecification jobSpec, IAdapterFactory adapterFactory, RecordDescriptor rDesc) throws AlgebricksException {
        AlgebricksAbsolutePartitionConstraint constraint;
        ExternalScanOperatorDescriptor dataScanner = new ExternalScanOperatorDescriptor(jobSpec, rDesc, adapterFactory);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    public Dataverse findDataverse(String dataverseName) throws CompilationException {
        return MetadataManager.INSTANCE.getDataverse(this.mdTxnCtx, dataverseName);
    }

    public Triple<IOperatorDescriptor, AlgebricksPartitionConstraint, IAdapterFactory> buildFeedIntakeRuntime(JobSpecification jobSpec, Feed feed, FeedPolicyAccessor policyAccessor) throws Exception {
        Triple<IAdapterFactory, RecordDescriptor, IDataSourceAdapter.AdapterType> factoryOutput = FeedMetadataUtil.getPrimaryFeedFactoryAndOutput(feed, policyAccessor, this.mdTxnCtx, this.getApplicationContext());
        ARecordType recordType = FeedMetadataUtil.getOutputType(feed, feed.getAdapterConfiguration(), "type-name");
        IAdapterFactory adapterFactory = (IAdapterFactory)factoryOutput.first;
        FeedIntakeOperatorDescriptor feedIngestor = null;
        switch ((IDataSourceAdapter.AdapterType)factoryOutput.third) {
            case INTERNAL: {
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, adapterFactory, recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
                break;
            }
            case EXTERNAL: {
                String libraryName = feed.getAdapterName().trim().split("#")[0];
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, libraryName, adapterFactory.getClass().getName(), recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
                break;
            }
        }
        AlgebricksAbsolutePartitionConstraint partitionConstraint = adapterFactory.getPartitionConstraint();
        return new Triple(feedIngestor, (Object)partitionConstraint, (Object)adapterFactory);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildBtreeRuntime(JobSpecification jobSpec, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, Dataset dataset, String indexName, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, boolean propagateFilter, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes) throws AlgebricksException {
        boolean isSecondary = true;
        try {
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            if (primaryIndex != null && dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
                isSecondary = !indexName.equals(primaryIndex.getIndexName());
            }
            Index theIndex = isSecondary ? MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName) : primaryIndex;
            int numPrimaryKeys = dataset.getPrimaryKeys().size();
            RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = this.getSplitProviderAndConstraints(dataset, theIndex.getIndexName());
            int[] primaryKeyFields = new int[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                primaryKeyFields[i] = i;
            }
            ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, theIndex, this.jobId, IndexOperation.SEARCH, primaryKeyFields);
            IStorageManager storageManager = this.getStorageComponentProvider().getStorageManager();
            IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(storageManager, (IFileSplitProvider)spPc.first);
            Object btreeSearchOp = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, propagateFilter) : new ExternalBTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this));
            return new Pair(btreeSearchOp, spPc.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)me);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildRtreeRuntime(JobSpecification jobSpec, List<LogicalVariable> outputVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, Dataset dataset, String indexName, int[] keyFields, boolean propagateFilter, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes) throws AlgebricksException {
        try {
            int numPrimaryKeys = dataset.getPrimaryKeys().size();
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            if (secondaryIndex == null) {
                throw new AlgebricksException("Code generation error: no index " + indexName + " for dataset " + dataset.getDatasetName());
            }
            RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
            int[] primaryKeyFields = new int[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                primaryKeyFields[i] = i;
            }
            ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, secondaryIndex, this.jobId, IndexOperation.SEARCH, primaryKeyFields);
            IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)spPc.first);
            Object rtreeSearchOp = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? new RTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, keyFields, true, true, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, propagateFilter) : new ExternalRTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, keyFields, true, true, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this));
            return new Pair(rtreeSearchOp, spPc.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)me);
        }
    }

    public Pair<IPushRuntimeFactory, AlgebricksPartitionConstraint> getWriteFileRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc) {
        FileSplitDataSink fsds = (FileSplitDataSink)sink;
        FileSplitSinkId fssi = fsds.getId();
        FileSplit fs = fssi.getFileSplit();
        File outFile = new File(fs.getPath());
        String nodeId = fs.getNodeName();
        SinkWriterRuntimeFactory runtime = new SinkWriterRuntimeFactory(printColumns, printerFactories, outFile, this.getWriterFactory(), inputDesc);
        AlgebricksAbsolutePartitionConstraint apc = new AlgebricksAbsolutePartitionConstraint(new String[]{nodeId});
        return new Pair((Object)runtime, (Object)apc);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getResultHandleRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc, boolean ordered, JobSpecification spec) throws AlgebricksException {
        ResultSetDataSink rsds = (ResultSetDataSink)sink;
        ResultSetSinkId rssId = rsds.getId();
        ResultSetId rsId = rssId.getResultSetId();
        ResultWriterOperatorDescriptor resultWriter = null;
        try {
            IResultSerializerFactory resultSerializedAppenderFactory = this.resultSerializerFactoryProvider.getAqlResultSerializerFactoryProvider(printColumns, printerFactories, this.getWriterFactory());
            resultWriter = new ResultWriterOperatorDescriptor((IOperatorDescriptorRegistry)spec, rsId, ordered, this.getResultAsyncMode(), resultSerializedAppenderFactory);
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)resultWriter, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getWriteResultRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        String dataverseName = ((DataSourceId)dataSource.getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        int numKeys = keys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            int idx;
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        fieldPermutation[numKeys] = propagatedSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx;
            fieldPermutation[numKeys + 1] = idx = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        try {
            boolean temp = dataset.getDatasetDetails().isTemp();
            this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset);
            long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
            IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
            TreeIndexBulkLoadOperatorDescriptor btreeBulkLoad = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, null, fieldPermutation, 1.0f, false, numElementsHint, true, (IIndexDataflowHelperFactory)indexHelperFactory);
            return new Pair((Object)btreeBulkLoad, splitsAndConstraint.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)me);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, List<LogicalVariable> additionalNonFilteringFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.INSERT, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, inputRecordDesc, context, spec, bulkload, additionalNonFilteringFields);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getDeleteRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.DELETE, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, inputRecordDesc, context, spec, false, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.INSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, bulkload, null, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexDeleteRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.DELETE, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, false, null, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexUpsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalFilteringKeys, ILogicalExpression filterExpr, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.UPSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalFilteringKeys, filterExpr, recordDesc, context, spec, false, prevSecondaryKeys, prevAdditionalFilteringKey);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getTokenizerRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        Index secondaryIndex;
        String indexName = (String)dataSourceIndex.getId();
        String dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        if (inputSchemas.length <= 0) {
            throw new AlgebricksException("TokenizeOperator can not operate without any input variable.");
        }
        IOperatorSchema inputSchema = inputSchemas[0];
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        try {
            secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        switch (secondaryIndex.getIndexType()) {
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getBinaryTokenizerRuntime(dataverseName, datasetName, indexName, inputSchema, propagatedSchema, primaryKeys, secondaryKeys, recordDesc, spec, secondaryIndex.getIndexType());
            }
        }
        throw new AlgebricksException("Currently, we do not support TokenizeOperator for the index type: " + secondaryIndex.getIndexType());
    }

    public long getCardinalityPerPartitionHint(Dataset dataset) throws AlgebricksException {
        String numElementsHintString = dataset.getHints().get("CARDINALITY");
        long numElementsHint = numElementsHintString == null ? 1000000L : Long.parseLong(numElementsHintString);
        int numPartitions = 0;
        List<String> nodeGroup = MetadataManager.INSTANCE.getNodegroup(this.mdTxnCtx, dataset.getNodeGroupName()).getNodeNames();
        for (String nd : nodeGroup) {
            numPartitions += ClusterStateManager.INSTANCE.getNodePartitionsCount(nd);
        }
        return numElementsHint / (long)numPartitions;
    }

    protected IAdapterFactory getConfiguredAdapterFactory(Dataset dataset, String adapterName, Map<String, String> configuration, ARecordType itemType, ARecordType metaType) throws AlgebricksException {
        try {
            configuration.put("dataverse", dataset.getDataverseName());
            IAdapterFactory adapterFactory = AdapterFactoryProvider.getAdapterFactory((IServiceContext)this.getApplicationContext().getServiceContext(), (String)adapterName, configuration, (ARecordType)itemType, (ARecordType)metaType);
            Index filesIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName().concat("FilesIndex"));
            if (filesIndex != null && filesIndex.getPendingOp() == 0) {
                List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(this.mdTxnCtx, dataset);
                Iterator<ExternalFile> iterator = files.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getPendingOp() == DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                    iterator.remove();
                }
            }
            return adapterFactory;
        }
        catch (Exception e) {
            throw new AlgebricksException("Unable to create adapter", (Throwable)e);
        }
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public static ILinearizeComparatorFactory proposeLinearizer(ATypeTag keyType, int numKeyFields) throws AlgebricksException {
        return LinearizeComparatorFactoryProvider.INSTANCE.getLinearizeComparatorFactory((Object)keyType, true, numKeyFields / 2);
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitAndConstraints(String dataverse) {
        return SplitsAndConstraintsUtil.getDataverseSplitProviderAndConstraints(dataverse);
    }

    public FileSplit[] splitsForIndex(MetadataTransactionContext mdTxnCtx, Dataset dataset, String indexName) throws AlgebricksException {
        return SplitsAndConstraintsUtil.getIndexSplits(dataset, indexName, mdTxnCtx);
    }

    public DatasourceAdapter getAdapter(MetadataTransactionContext mdTxnCtx, String dataverseName, String adapterName) throws MetadataException {
        DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "Metadata", adapterName);
        if (adapter == null) {
            adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, dataverseName, adapterName);
        }
        return adapter;
    }

    public AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        return ClusterStateManager.INSTANCE.getClusterLocations();
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDataLookupRuntime(JobSpecification jobSpec, Dataset dataset, int[] ridIndexes, boolean retainInput, IVariableTypeEnvironment typeEnv, IOperatorSchema opSchema, JobGenContext context, MetadataProvider metadataProvider, boolean retainMissing) throws AlgebricksException {
        try {
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getItemTypeName()).getDatatype();
            ExternalDatasetDetails datasetDetails = (ExternalDatasetDetails)dataset.getDatasetDetails();
            LookupAdapterFactory adapterFactory = AdapterFactoryProvider.getLookupAdapterFactory((IServiceContext)this.getApplicationContext().getServiceContext(), datasetDetails.getProperties(), (ARecordType)itemType, (int[])ridIndexes, (boolean)retainInput, (boolean)retainMissing, (IMissingWriterFactory)context.getMissingWriterFactory());
            String fileIndexName = IndexingConstants.getFilesIndexName((String)dataset.getDatasetName());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = metadataProvider.getSplitProviderAndConstraints(dataset, fileIndexName);
            Index fileIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), fileIndexName);
            IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)spPc.first);
            RecordDescriptor outRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            ISearchOperationCallbackFactory searchOpCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, fileIndex, this.jobId, IndexOperation.SEARCH, null);
            ExternalLookupOperatorDescriptor op = new ExternalLookupOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, adapterFactory, outRecDesc, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, searchOpCallbackFactory, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this));
            return new Pair((Object)op, spPc.second);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getUpsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema inputSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, LogicalVariable payload, List<LogicalVariable> filterKeys, List<LogicalVariable> additionalNonFilterFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        int idx;
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = this.findDataset(((DataSourceId)dataSource.getId()).getDataverseName(), datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + ((DataSourceId)dataSource.getId()).getDataverseName());
        }
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int numOfAdditionalFields = additionalNonFilterFields == null ? 0 : additionalNonFilterFields.size();
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + numOfAdditionalFields];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = inputSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = inputSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx2 = inputSchema.findVariable(filterKeys.get(0));
            fieldPermutation[i++] = idx2;
        }
        if (additionalNonFilterFields != null) {
            for (LogicalVariable var : additionalNonFilterFields) {
                idx = inputSchema.findVariable(var);
                fieldPermutation[i++] = idx;
            }
        }
        return DatasetUtil.createPrimaryIndexUpsertOp(spec, this, dataset, recordDesc, fieldPermutation, context.getMissingWriterFactory());
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDatasetDataScannerRuntime(JobSpecification jobSpec, IAType itemType, IAdapterFactory adapterFactory, IDataFormat format) throws AlgebricksException {
        AlgebricksAbsolutePartitionConstraint constraint;
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new AlgebricksException("Can only scan datasets of records.");
        }
        ISerializerDeserializer payloadSerde = format.getSerdeProvider().getSerializerDeserializer((Object)itemType);
        RecordDescriptor scannerDesc = new RecordDescriptor(new ISerializerDeserializer[]{payloadSerde});
        ExternalScanOperatorDescriptor dataScanner = new ExternalScanOperatorDescriptor(jobSpec, scannerDesc, adapterFactory);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    private Pair<IBinaryComparatorFactory[], ITypeTraits[]> getComparatorFactoriesAndTypeTraitsOfSecondaryBTreeIndex(List<List<String>> sidxKeyFieldNames, List<IAType> sidxKeyFieldTypes, List<List<String>> pidxKeyFieldNames, ARecordType recType, DatasetConfig.DatasetType dsType, boolean hasMeta, List<Integer> primaryIndexKeyIndicators, List<Integer> secondaryIndexIndicators, ARecordType metaType) throws AlgebricksException {
        IAType keyType;
        int i;
        int sidxKeyFieldCount = sidxKeyFieldNames.size();
        int pidxKeyFieldCount = pidxKeyFieldNames.size();
        ITypeTraits[] typeTraits = new ITypeTraits[sidxKeyFieldCount + pidxKeyFieldCount];
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[sidxKeyFieldCount + pidxKeyFieldCount];
        for (i = 0; i < sidxKeyFieldCount; ++i) {
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(sidxKeyFieldTypes.get(i), sidxKeyFieldNames.get(i), hasMeta && secondaryIndexIndicators.get(i) == 1 ? metaType : recType);
            keyType = (IAType)keyPairType.first;
            comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
        }
        int j = 0;
        while (j < pidxKeyFieldCount) {
            keyType = null;
            try {
                switch (dsType) {
                    case INTERNAL: {
                        keyType = hasMeta && primaryIndexKeyIndicators.get(j) == 1 ? metaType.getSubFieldType(pidxKeyFieldNames.get(j)) : recType.getSubFieldType(pidxKeyFieldNames.get(j));
                        break;
                    }
                    case EXTERNAL: {
                        keyType = IndexingConstants.getFieldType((int)j);
                        break;
                    }
                    default: {
                        throw new AlgebricksException("Unknown Dataset Type");
                    }
                }
            }
            catch (AsterixException e) {
                throw new AlgebricksException((Throwable)e);
            }
            comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            ++j;
            ++i;
        }
        return new Pair((Object)comparatorFactories, (Object)typeTraits);
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertOrDeleteRuntime(IndexOperation indexOp, IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<LogicalVariable> additionalNonFilteringFields) throws AlgebricksException {
        int idx;
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, ((DataSourceId)dataSource.getId()).getDataverseName(), datasetName);
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = keys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + (additionalNonFilteringFields == null ? 0 : additionalNonFilteringFields.size())];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = propagatedSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
            fieldPermutation[i++] = idx2;
        }
        if (additionalNonFilteringFields != null) {
            for (LogicalVariable variable : additionalNonFilteringFields) {
                idx = propagatedSchema.findVariable(variable);
                fieldPermutation[i++] = idx;
            }
        }
        try {
            LSMTreeInsertDeleteOperatorDescriptor op;
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset);
            int[] primaryKeyFields = new int[numKeys];
            for (i = 0; i < numKeys; ++i) {
                primaryKeyFields[i] = i;
            }
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, primaryIndex, this.jobId, indexOp, primaryKeyFields);
            IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, 1.0f, true, numElementsHint, true, (IIndexDataflowHelperFactory)idfh);
            } else {
                op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, null, true, modificationCallbackFactory);
            }
            return new Pair((Object)op, splitsAndConstraint.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)me);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation indexOp, IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey) throws AlgebricksException {
        Index secondaryIndex;
        String indexName = (String)dataSourceIndex.getId();
        String dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        try {
            secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        ArrayList<LogicalVariable> prevAdditionalFilteringKeys = null;
        if (indexOp == IndexOperation.UPSERT && prevAdditionalFilteringKey != null) {
            prevAdditionalFilteringKeys = new ArrayList<LogicalVariable>();
            prevAdditionalFilteringKeys.add(prevAdditionalFilteringKey);
        }
        AsterixTupleFilterFactory filterFactory = this.createTupleFilterFactory(inputSchemas, typeEnv, filterExpr, context);
        switch (secondaryIndex.getIndexType()) {
            case BTREE: {
                return this.getBTreeRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, inputRecordDesc, context, spec, indexOp, bulkload, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case RTREE: {
                return this.getRTreeRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, inputRecordDesc, context, spec, indexOp, bulkload, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getInvertedIndexRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, inputRecordDesc, context, spec, indexOp, secondaryIndex.getIndexType(), bulkload, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
        }
        throw new AlgebricksException(indexOp.name() + "Insert, upsert, and delete not implemented for index type: " + secondaryIndex.getIndexType());
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBTreeRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            int idx3;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            int k = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            for (LogicalVariable varKey : primaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            if (numFilterFields > 0) {
                int idx4;
                prevFieldPermutation[numKeys] = idx4 = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        try {
            Object op;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, jobId, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)idfh);
            } else {
                op = indexOp == IndexOperation.UPSERT ? new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, (ITupleFilterFactory)filterFactory, modificationCallbackFactory, prevFieldPermutation) : new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory);
            }
            return new Pair(op, splitsAndConstraint.second);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getRTreeRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        try {
            Object op;
            int idx;
            Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
            boolean temp = dataset.getDatasetDetails().isTemp();
            this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
            String itemTypeName = dataset.getItemTypeName();
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            this.validateRecordType(itemType);
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyExprs.get(0), recType);
            IAType spatialType = (IAType)keyPairType.first;
            int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
            int numSecondaryKeys = dimension * 2;
            int numPrimaryKeys = primaryKeys.size();
            int numKeys = numSecondaryKeys + numPrimaryKeys;
            int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
            int[] fieldPermutation = new int[numKeys + numFilterFields];
            int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
            int i = 0;
            int j = 0;
            for (LogicalVariable logicalVariable : secondaryKeys) {
                fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
                ++i;
            }
            for (LogicalVariable logicalVariable : primaryKeys) {
                fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
                modificationCallbackPrimaryKeyFields[j] = i++;
                ++j;
            }
            if (numFilterFields > 0) {
                int idx2;
                fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
            }
            int[] prevFieldPermutation = null;
            if (indexOp == IndexOperation.UPSERT) {
                void var36_44;
                prevFieldPermutation = new int[numKeys + numFilterFields];
                i = 0;
                for (LogicalVariable varKey : prevSecondaryKeys) {
                    int idx3;
                    prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                    ++i;
                }
                boolean bl = false;
                while (var36_44 < numPrimaryKeys) {
                    prevFieldPermutation[var36_44 + i] = fieldPermutation[var36_44 + i];
                    ++i;
                    ++var36_44;
                }
                if (numFilterFields > 0) {
                    int n;
                    prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
                }
            }
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> pair = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, jobId, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)pair.first);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)indexDataflowHelperFactory);
            } else {
                op = indexOp == IndexOperation.UPSERT ? new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, (ITupleFilterFactory)filterFactory, modificationCallbackFactory, prevFieldPermutation) : new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory);
            }
            return new Pair(op, pair.second);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInvertedIndexRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, DatasetConfig.IndexType indexType, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot create inverted index on dataset with composite primary key.");
        }
        if (secondaryKeys.size() > 1 && !isPartitioned || secondaryKeys.size() > 2 && isPartitioned) {
            throw new AlgebricksException("Cannot create composite inverted index on multiple fields.");
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable logicalVariable : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            ++i;
        }
        for (LogicalVariable logicalVariable : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            void var27_34;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            i = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                int idx3;
                prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                ++i;
            }
            boolean bl = false;
            while (var27_34 < primaryKeys.size()) {
                prevFieldPermutation[var27_34 + i] = fieldPermutation[var27_34 + i];
                ++i;
                ++var27_34;
            }
            if (numFilterFields > 0) {
                int n;
                prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        try {
            Object op;
            Index index = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset, index.getIndexName());
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, index, jobId, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory indexDataFlowFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)indexDataFlowFactory);
            } else {
                op = indexOp == IndexOperation.UPSERT ? new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, modificationCallbackFactory, prevFieldPermutation) : new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory);
            }
            return new Pair(op, splitsAndConstraint.second);
        }
        catch (Exception exception) {
            throw new AlgebricksException((Throwable)exception);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBinaryTokenizerRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema inputSchema, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, RecordDescriptor recordDesc, JobSpecification spec, DatasetConfig.IndexType indexType) throws AlgebricksException {
        int idx;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite primary key.");
        }
        if (secondaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite secondary key fields.");
        }
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        int numKeys = inputSchema.getSize();
        ArrayList<LogicalVariable> otherKeys = new ArrayList<LogicalVariable>();
        if (inputSchema.getSize() > 0) {
            for (int k = 0; k < inputSchema.getSize(); ++k) {
                boolean found = false;
                for (LogicalVariable varKey : primaryKeys) {
                    if (varKey.equals((Object)inputSchema.getVariable(k))) {
                        found = true;
                        break;
                    }
                    found = false;
                }
                if (!found) {
                    for (LogicalVariable varKey : secondaryKeys) {
                        if (varKey.equals((Object)inputSchema.getVariable(k))) {
                            found = true;
                            break;
                        }
                        found = false;
                    }
                }
                if (found) continue;
                otherKeys.add(inputSchema.getVariable(k));
            }
        }
        int numTokenKeyPairFields = !isPartitioned ? 1 + numKeys : 2 + numKeys;
        int[] fieldPermutation = new int[numKeys];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        for (LogicalVariable varKey : otherKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        String itemTypeName = dataset.getItemTypeName();
        try {
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.OBJECT) {
                throw new AlgebricksException("Only record types can be tokenized.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypeEntries = secondaryIndex.getKeyFieldTypes();
            int numTokenFields = !isPartitioned ? secondaryKeys.size() : secondaryKeys.size() + 1;
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
            ITypeTraits[] invListsTypeTraits = new ITypeTraits[primaryKeys.size()];
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypeEntries.get(0), secondaryKeyExprs.get(0), recType);
            IAType secondaryKeyType = (IAType)keyPairType.first;
            List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
            i = 0;
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                invListsTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            if (isPartitioned) {
                tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
            }
            IBinaryTokenizerFactory tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)secondaryIndex.getGramLength());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
            ISerializerDeserializer[] tokenKeyPairFields = new ISerializerDeserializer[numTokenKeyPairFields];
            ITypeTraits[] tokenKeyPairTypeTraits = new ITypeTraits[numTokenKeyPairFields];
            ISerializerDeserializerProvider serdeProvider = FormatUtils.getDefaultFormat().getSerdeProvider();
            for (int k = 0; k < recordDesc.getFieldCount(); ++k) {
                tokenKeyPairFields[k] = recordDesc.getFields()[k];
                tokenKeyPairTypeTraits[k] = recordDesc.getTypeTraits()[k];
            }
            int tokenOffset = recordDesc.getFieldCount();
            tokenKeyPairFields[tokenOffset] = serdeProvider.getSerializerDeserializer((Object)secondaryKeyType);
            tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[0];
            ++tokenOffset;
            if (isPartitioned) {
                tokenKeyPairFields[tokenOffset] = ShortSerializerDeserializer.INSTANCE;
                tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[1];
            }
            RecordDescriptor tokenKeyPairRecDesc = new RecordDescriptor(tokenKeyPairFields, tokenKeyPairTypeTraits);
            int docField = fieldPermutation[fieldPermutation.length - 1];
            int[] keyFields = new int[numKeys];
            for (int k = 0; k < keyFields.length; ++k) {
                keyFields[k] = k;
            }
            BinaryTokenizerOperatorDescriptor tokenizerOp = new BinaryTokenizerOperatorDescriptor((IOperatorDescriptorRegistry)spec, tokenKeyPairRecDesc, tokenizerFactory, docField, keyFields, isPartitioned, true, false, (IMissingWriterFactory)MissingWriterFactory.INSTANCE);
            return new Pair((Object)tokenizerOp, splitsAndConstraint.second);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private AsterixTupleFilterFactory createTupleFilterFactory(IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, ILogicalExpression filterExpr, JobGenContext context) throws AlgebricksException {
        if (filterExpr == null) {
            return null;
        }
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory filterEvalFactory = expressionRuntimeProvider.createEvaluatorFactory(filterExpr, typeEnv, inputSchemas, context);
        return new AsterixTupleFilterFactory(filterEvalFactory, context.getBinaryBooleanInspectorFactory());
    }

    private void validateRecordType(IAType itemType) throws AlgebricksException {
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new AlgebricksException("Only record types can be indexed.");
        }
    }

    public IStorageComponentProvider getStorageComponentProvider() {
        return this.storageComponentProvider;
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getSplitProviderAndConstraints(Dataset ds) throws AlgebricksException {
        return this.getSplitProviderAndConstraints(ds, ds.getDatasetName());
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getSplitProviderAndConstraints(Dataset ds, String indexName) throws AlgebricksException {
        FileSplit[] splits = this.splitsForIndex(this.mdTxnCtx, ds, indexName);
        return StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
    }

    public LockList getLocks() {
        return this.locks;
    }

    public ICcApplicationContext getApplicationContext() {
        return this.appCtx;
    }
}

