/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.GarbageCollector;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IExtensionMetadataEntity;
import org.apache.asterix.metadata.api.IExtensionMetadataSearchKey;
import org.apache.asterix.metadata.api.IMetadataManager;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.service.transaction.JobIdFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class MetadataManager
implements IMetadataManager {
    private final MetadataCache cache = new MetadataCache();
    protected final IAsterixStateProxy proxy;
    protected IMetadataNode metadataNode;
    private final ReadWriteLock metadataLatch;
    protected boolean rebindMetadataNode = false;
    public static IMetadataManager INSTANCE;

    private MetadataManager(IAsterixStateProxy proxy, IMetadataNode metadataNode) {
        this(proxy);
        if (metadataNode == null) {
            throw new IllegalArgumentException("Null metadataNode given to MetadataManager");
        }
        this.metadataNode = metadataNode;
    }

    private MetadataManager(IAsterixStateProxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Null proxy given to MetadataManager");
        }
        this.proxy = proxy;
        this.metadataLatch = new ReentrantReadWriteLock(true);
    }

    public void init() throws HyracksDataException {
        GarbageCollector.ensure();
    }

    @Override
    public MetadataTransactionContext beginTransaction() throws RemoteException, ACIDException {
        JobId jobId = JobIdFactory.generateJobId();
        this.metadataNode.beginTransaction(jobId);
        return new MetadataTransactionContext(jobId);
    }

    @Override
    public void commitTransaction(MetadataTransactionContext ctx) throws RemoteException, ACIDException {
        this.metadataNode.commitTransaction(ctx.getJobId());
        this.cache.commit(ctx);
    }

    @Override
    public void abortTransaction(MetadataTransactionContext ctx) throws RemoteException, ACIDException {
        this.metadataNode.abortTransaction(ctx.getJobId());
    }

    @Override
    public void lock(MetadataTransactionContext ctx, byte lockMode) throws RemoteException, ACIDException {
        this.metadataNode.lock(ctx.getJobId(), lockMode);
    }

    @Override
    public void unlock(MetadataTransactionContext ctx, byte lockMode) throws RemoteException, ACIDException {
        this.metadataNode.unlock(ctx.getJobId(), lockMode);
    }

    @Override
    public void addDataverse(MetadataTransactionContext ctx, Dataverse dataverse) throws MetadataException {
        try {
            this.metadataNode.addDataverse(ctx.getJobId(), dataverse);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.addDataverse(dataverse);
    }

    @Override
    public void dropDataverse(MetadataTransactionContext ctx, String dataverseName) throws MetadataException {
        try {
            this.metadataNode.dropDataverse(ctx.getJobId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataverse(dataverseName);
    }

    @Override
    public List<Dataverse> getDataverses(MetadataTransactionContext ctx) throws MetadataException {
        try {
            return this.metadataNode.getDataverses(ctx.getJobId());
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public Dataverse getDataverse(MetadataTransactionContext ctx, String dataverseName) throws MetadataException {
        Dataverse dataverse = ctx.getDataverse(dataverseName);
        if (dataverse != null) {
            return dataverse;
        }
        if (ctx.dataverseIsDropped(dataverseName)) {
            return null;
        }
        dataverse = this.cache.getDataverse(dataverseName);
        if (dataverse != null) {
            return dataverse;
        }
        try {
            dataverse = this.metadataNode.getDataverse(ctx.getJobId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        if (dataverse != null) {
            ctx.addDataverse(dataverse);
        }
        return dataverse;
    }

    @Override
    public List<Dataset> getDataverseDatasets(MetadataTransactionContext ctx, String dataverseName) throws MetadataException {
        ArrayList<Dataset> dataverseDatasets = new ArrayList<Dataset>();
        for (Dataset dataset : ctx.getDataverseDatasets(dataverseName)) {
            if (!dataset.getDatasetDetails().isTemp()) continue;
            dataverseDatasets.add(dataset);
        }
        for (Dataset dataset : this.cache.getDataverseDatasets(dataverseName)) {
            if (!dataset.getDatasetDetails().isTemp()) continue;
            dataverseDatasets.add(dataset);
        }
        try {
            dataverseDatasets.addAll(this.metadataNode.getDataverseDatasets(ctx.getJobId(), dataverseName));
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return dataverseDatasets;
    }

    @Override
    public void addDataset(MetadataTransactionContext ctx, Dataset dataset) throws MetadataException {
        if (!dataset.getDatasetDetails().isTemp()) {
            try {
                this.metadataNode.addDataset(ctx.getJobId(), dataset);
            }
            catch (RemoteException e) {
                throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
            }
        }
        ctx.addDataset(dataset);
    }

    @Override
    public void dropDataset(MetadataTransactionContext ctx, String dataverseName, String datasetName) throws MetadataException {
        Dataset dataset = this.findDataset(ctx, dataverseName, datasetName);
        if (dataset == null || !dataset.getDatasetDetails().isTemp()) {
            try {
                this.metadataNode.dropDataset(ctx.getJobId(), dataverseName, datasetName);
            }
            catch (RemoteException e) {
                throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
            }
        }
        ctx.dropDataset(dataverseName, datasetName);
    }

    @Override
    public Dataset getDataset(MetadataTransactionContext ctx, String dataverseName, String datasetName) throws MetadataException {
        Dataset dataset = ctx.getDataset(dataverseName, datasetName);
        if (dataset != null) {
            return dataset;
        }
        if (ctx.datasetIsDropped(dataverseName, datasetName)) {
            return null;
        }
        dataset = this.cache.getDataset(dataverseName, datasetName);
        if (dataset != null) {
            return dataset;
        }
        try {
            dataset = this.metadataNode.getDataset(ctx.getJobId(), dataverseName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        if (dataset != null) {
            ctx.addDataset(dataset);
        }
        return dataset;
    }

    @Override
    public List<Index> getDatasetIndexes(MetadataTransactionContext ctx, String dataverseName, String datasetName) throws MetadataException {
        List<Index> datasetIndexes = new ArrayList<Index>();
        Dataset dataset = this.findDataset(ctx, dataverseName, datasetName);
        if (dataset == null) {
            return datasetIndexes;
        }
        if (dataset.getDatasetDetails().isTemp()) {
            datasetIndexes = this.cache.getDatasetIndexes(dataverseName, datasetName);
        } else {
            try {
                datasetIndexes = this.metadataNode.getDatasetIndexes(ctx.getJobId(), dataverseName, datasetName);
            }
            catch (RemoteException e) {
                throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
            }
        }
        return datasetIndexes;
    }

    @Override
    public void addCompactionPolicy(MetadataTransactionContext mdTxnCtx, CompactionPolicy compactionPolicy) throws MetadataException {
        try {
            this.metadataNode.addCompactionPolicy(mdTxnCtx.getJobId(), compactionPolicy);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addCompactionPolicy(compactionPolicy);
    }

    @Override
    public CompactionPolicy getCompactionPolicy(MetadataTransactionContext ctx, String dataverse, String policyName) throws MetadataException {
        CompactionPolicy compactionPolicy;
        try {
            compactionPolicy = this.metadataNode.getCompactionPolicy(ctx.getJobId(), dataverse, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return compactionPolicy;
    }

    @Override
    public void addDatatype(MetadataTransactionContext ctx, Datatype datatype) throws MetadataException {
        try {
            this.metadataNode.addDatatype(ctx.getJobId(), datatype);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        try {
            ctx.addDatatype(this.metadataNode.getDatatype(ctx.getJobId(), datatype.getDataverseName(), datatype.getDatatypeName()));
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropDatatype(MetadataTransactionContext ctx, String dataverseName, String datatypeName) throws MetadataException {
        try {
            this.metadataNode.dropDatatype(ctx.getJobId(), dataverseName, datatypeName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataDatatype(dataverseName, datatypeName);
    }

    @Override
    public Datatype getDatatype(MetadataTransactionContext ctx, String dataverseName, String datatypeName) throws MetadataException {
        Datatype datatype = ctx.getDatatype(dataverseName, datatypeName);
        if (datatype != null) {
            return datatype;
        }
        if (ctx.datatypeIsDropped(dataverseName, datatypeName)) {
            return null;
        }
        datatype = this.cache.getDatatype(dataverseName, datatypeName);
        if (datatype != null) {
            ARecordType aRecType = (ARecordType)datatype.getDatatype();
            return new Datatype(datatype.getDataverseName(), datatype.getDatatypeName(), (IAType)new ARecordType(aRecType.getTypeName(), aRecType.getFieldNames(), aRecType.getFieldTypes(), aRecType.isOpen()), datatype.getIsAnonymous());
        }
        try {
            datatype = this.metadataNode.getDatatype(ctx.getJobId(), dataverseName, datatypeName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        if (datatype != null) {
            ctx.addDatatype(datatype);
        }
        return datatype;
    }

    @Override
    public void addIndex(MetadataTransactionContext ctx, Index index) throws MetadataException {
        String datasetName;
        String dataverseName = index.getDataverseName();
        Dataset dataset = this.findDataset(ctx, dataverseName, datasetName = index.getDatasetName());
        if (dataset == null || !dataset.getDatasetDetails().isTemp()) {
            try {
                this.metadataNode.addIndex(ctx.getJobId(), index);
            }
            catch (RemoteException e) {
                throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
            }
        }
        ctx.addIndex(index);
    }

    @Override
    public void addAdapter(MetadataTransactionContext mdTxnCtx, DatasourceAdapter adapter) throws MetadataException {
        try {
            this.metadataNode.addAdapter(mdTxnCtx.getJobId(), adapter);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addAdapter(adapter);
    }

    @Override
    public void dropIndex(MetadataTransactionContext ctx, String dataverseName, String datasetName, String indexName) throws MetadataException {
        Dataset dataset = this.findDataset(ctx, dataverseName, datasetName);
        if (dataset == null || !dataset.getDatasetDetails().isTemp()) {
            try {
                this.metadataNode.dropIndex(ctx.getJobId(), dataverseName, datasetName, indexName);
            }
            catch (RemoteException e) {
                throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
            }
        }
        ctx.dropIndex(dataverseName, datasetName, indexName);
    }

    @Override
    public Index getIndex(MetadataTransactionContext ctx, String dataverseName, String datasetName, String indexName) throws MetadataException {
        Index index = ctx.getIndex(dataverseName, datasetName, indexName);
        if (index != null) {
            return index;
        }
        if (ctx.indexIsDropped(dataverseName, datasetName, indexName)) {
            return null;
        }
        index = this.cache.getIndex(dataverseName, datasetName, indexName);
        if (index != null) {
            return index;
        }
        try {
            index = this.metadataNode.getIndex(ctx.getJobId(), dataverseName, datasetName, indexName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        if (index != null) {
            ctx.addIndex(index);
        }
        return index;
    }

    @Override
    public void addNode(MetadataTransactionContext ctx, Node node) throws MetadataException {
        try {
            this.metadataNode.addNode(ctx.getJobId(), node);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void addNodegroup(MetadataTransactionContext ctx, NodeGroup nodeGroup) throws MetadataException {
        try {
            this.metadataNode.addNodeGroup(ctx.getJobId(), nodeGroup);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.addNodeGroup(nodeGroup);
    }

    @Override
    public void dropNodegroup(MetadataTransactionContext ctx, String nodeGroupName, boolean failSilently) throws MetadataException {
        boolean dropped;
        try {
            dropped = this.metadataNode.dropNodegroup(ctx.getJobId(), nodeGroupName, failSilently);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        if (dropped) {
            ctx.dropNodeGroup(nodeGroupName);
        }
    }

    @Override
    public NodeGroup getNodegroup(MetadataTransactionContext ctx, String nodeGroupName) throws MetadataException {
        NodeGroup nodeGroup = ctx.getNodeGroup(nodeGroupName);
        if (nodeGroup != null) {
            return nodeGroup;
        }
        if (ctx.nodeGroupIsDropped(nodeGroupName)) {
            return null;
        }
        nodeGroup = this.cache.getNodeGroup(nodeGroupName);
        if (nodeGroup != null) {
            return nodeGroup;
        }
        try {
            nodeGroup = this.metadataNode.getNodeGroup(ctx.getJobId(), nodeGroupName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        if (nodeGroup != null) {
            ctx.addNodeGroup(nodeGroup);
        }
        return nodeGroup;
    }

    @Override
    public void addFunction(MetadataTransactionContext mdTxnCtx, Function function) throws MetadataException {
        try {
            this.metadataNode.addFunction(mdTxnCtx.getJobId(), function);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFunction(function);
    }

    @Override
    public void dropFunction(MetadataTransactionContext ctx, FunctionSignature functionSignature) throws MetadataException {
        try {
            this.metadataNode.dropFunction(ctx.getJobId(), functionSignature);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFunction(functionSignature);
    }

    @Override
    public Function getFunction(MetadataTransactionContext ctx, FunctionSignature functionSignature) throws MetadataException {
        Function function = ctx.getFunction(functionSignature);
        if (function != null) {
            return function;
        }
        if (ctx.functionIsDropped(functionSignature)) {
            return null;
        }
        if (ctx.getDataverse(functionSignature.getNamespace()) != null) {
            return null;
        }
        function = this.cache.getFunction(functionSignature);
        if (function != null) {
            return function;
        }
        try {
            function = this.metadataNode.getFunction(ctx.getJobId(), functionSignature);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        if (function != null) {
            ctx.addFunction(function);
        }
        return function;
    }

    @Override
    public List<Function> getFunctions(MetadataTransactionContext ctx, String dataverseName) throws MetadataException {
        try {
            return this.metadataNode.getFunctions(ctx.getJobId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public void addFeedPolicy(MetadataTransactionContext mdTxnCtx, FeedPolicyEntity feedPolicy) throws MetadataException {
        try {
            this.metadataNode.addFeedPolicy(mdTxnCtx.getJobId(), feedPolicy);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFeedPolicy(feedPolicy);
    }

    @Override
    public void initializeDatasetIdFactory(MetadataTransactionContext ctx) throws MetadataException {
        try {
            this.metadataNode.initializeDatasetIdFactory(ctx.getJobId());
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public int getMostRecentDatasetId() throws MetadataException {
        try {
            return this.metadataNode.getMostRecentDatasetId();
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<Function> getDataverseFunctions(MetadataTransactionContext ctx, String dataverseName) throws MetadataException {
        List<Function> dataverseFunctions;
        try {
            dataverseFunctions = this.metadataNode.getDataverseFunctions(ctx.getJobId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return dataverseFunctions;
    }

    @Override
    public void dropAdapter(MetadataTransactionContext ctx, String dataverseName, String name) throws MetadataException {
        try {
            this.metadataNode.dropAdapter(ctx.getJobId(), dataverseName, name);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public DatasourceAdapter getAdapter(MetadataTransactionContext ctx, String dataverseName, String name) throws MetadataException {
        DatasourceAdapter adapter;
        try {
            adapter = this.metadataNode.getAdapter(ctx.getJobId(), dataverseName, name);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return adapter;
    }

    @Override
    public void dropLibrary(MetadataTransactionContext ctx, String dataverseName, String libraryName) throws MetadataException {
        try {
            this.metadataNode.dropLibrary(ctx.getJobId(), dataverseName, libraryName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.dropLibrary(dataverseName, libraryName);
    }

    @Override
    public List<Library> getDataverseLibraries(MetadataTransactionContext ctx, String dataverseName) throws MetadataException {
        List<Library> dataverseLibaries;
        try {
            dataverseLibaries = this.metadataNode.getDataverseLibraries(ctx.getJobId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return dataverseLibaries;
    }

    @Override
    public void addLibrary(MetadataTransactionContext ctx, Library library) throws MetadataException {
        try {
            this.metadataNode.addLibrary(ctx.getJobId(), library);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.addLibrary(library);
    }

    @Override
    public Library getLibrary(MetadataTransactionContext ctx, String dataverseName, String libraryName) throws MetadataException, RemoteException {
        Library library;
        try {
            library = this.metadataNode.getLibrary(ctx.getJobId(), dataverseName, libraryName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return library;
    }

    @Override
    public void acquireWriteLatch() {
        this.metadataLatch.writeLock().lock();
    }

    @Override
    public void releaseWriteLatch() {
        this.metadataLatch.writeLock().unlock();
    }

    @Override
    public void acquireReadLatch() {
        this.metadataLatch.readLock().lock();
    }

    @Override
    public void releaseReadLatch() {
        this.metadataLatch.readLock().unlock();
    }

    @Override
    public FeedPolicyEntity getFeedPolicy(MetadataTransactionContext ctx, String dataverse, String policyName) throws MetadataException {
        FeedPolicyEntity feedPolicy;
        try {
            feedPolicy = this.metadataNode.getFeedPolicy(ctx.getJobId(), dataverse, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return feedPolicy;
    }

    @Override
    public Feed getFeed(MetadataTransactionContext ctx, String dataverse, String feedName) throws MetadataException {
        Feed feed;
        try {
            feed = this.metadataNode.getFeed(ctx.getJobId(), dataverse, feedName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return feed;
    }

    @Override
    public List<Feed> getFeeds(MetadataTransactionContext ctx, String dataverse) throws MetadataException {
        List<Feed> feeds;
        try {
            feeds = this.metadataNode.getFeeds(ctx.getJobId(), dataverse);
        }
        catch (RemoteException e) {
            throw new MetadataException((Throwable)e);
        }
        return feeds;
    }

    @Override
    public void dropFeed(MetadataTransactionContext ctx, String dataverse, String feedName) throws MetadataException {
        Feed feed = null;
        List<FeedConnection> feedConnections = null;
        try {
            feed = this.metadataNode.getFeed(ctx.getJobId(), dataverse, feedName);
            feedConnections = this.metadataNode.getFeedConnections(ctx.getJobId(), dataverse, feedName);
            this.metadataNode.dropFeed(ctx.getJobId(), dataverse, feedName);
            for (FeedConnection feedConnection : feedConnections) {
                this.metadataNode.dropFeedConnection(ctx.getJobId(), dataverse, feedName, feedConnection.getDatasetName());
                ctx.dropFeedConnection(dataverse, feedName, feedConnection.getDatasetName());
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFeed(feed);
    }

    @Override
    public void addFeed(MetadataTransactionContext ctx, Feed feed) throws MetadataException {
        try {
            this.metadataNode.addFeed(ctx.getJobId(), feed);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.addFeed(feed);
    }

    @Override
    public void addFeedConnection(MetadataTransactionContext ctx, FeedConnection feedConnection) throws MetadataException {
        try {
            this.metadataNode.addFeedConnection(ctx.getJobId(), feedConnection);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.addFeedConnection(feedConnection);
    }

    @Override
    public void dropFeedConnection(MetadataTransactionContext ctx, String dataverseName, String feedName, String datasetName) throws MetadataException {
        try {
            this.metadataNode.dropFeedConnection(ctx.getJobId(), dataverseName, feedName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFeedConnection(dataverseName, feedName, datasetName);
    }

    @Override
    public FeedConnection getFeedConnection(MetadataTransactionContext ctx, String dataverseName, String feedName, String datasetName) throws MetadataException {
        try {
            return this.metadataNode.getFeedConnection(ctx.getJobId(), dataverseName, feedName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<FeedConnection> getFeedConections(MetadataTransactionContext ctx, String dataverseName, String feedName) throws MetadataException {
        try {
            return this.metadataNode.getFeedConnections(ctx.getJobId(), dataverseName, feedName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<DatasourceAdapter> getDataverseAdapters(MetadataTransactionContext mdTxnCtx, String dataverse) throws MetadataException {
        List<DatasourceAdapter> dataverseAdapters;
        try {
            dataverseAdapters = this.metadataNode.getDataverseAdapters(mdTxnCtx.getJobId(), dataverse);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return dataverseAdapters;
    }

    @Override
    public void dropFeedPolicy(MetadataTransactionContext mdTxnCtx, String dataverseName, String policyName) throws MetadataException {
        FeedPolicyEntity feedPolicy;
        try {
            feedPolicy = this.metadataNode.getFeedPolicy(mdTxnCtx.getJobId(), dataverseName, policyName);
            this.metadataNode.dropFeedPolicy(mdTxnCtx.getJobId(), dataverseName, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.dropFeedPolicy(feedPolicy);
    }

    public List<FeedPolicyEntity> getDataversePolicies(MetadataTransactionContext mdTxnCtx, String dataverse) throws MetadataException {
        List<FeedPolicyEntity> dataverseFeedPolicies;
        try {
            dataverseFeedPolicies = this.metadataNode.getDataversePolicies(mdTxnCtx.getJobId(), dataverse);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return dataverseFeedPolicies;
    }

    @Override
    public List<ExternalFile> getDatasetExternalFiles(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws MetadataException {
        List<ExternalFile> externalFiles;
        try {
            externalFiles = this.metadataNode.getExternalFiles(mdTxnCtx.getJobId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return externalFiles;
    }

    @Override
    public void addExternalFile(MetadataTransactionContext ctx, ExternalFile externalFile) throws MetadataException {
        try {
            this.metadataNode.addExternalFile(ctx.getJobId(), externalFile);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropExternalFile(MetadataTransactionContext ctx, ExternalFile externalFile) throws MetadataException {
        try {
            this.metadataNode.dropExternalFile(ctx.getJobId(), externalFile.getDataverseName(), externalFile.getDatasetName(), externalFile.getFileNumber());
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public ExternalFile getExternalFile(MetadataTransactionContext ctx, String dataverseName, String datasetName, Integer fileNumber) throws MetadataException {
        ExternalFile file;
        try {
            file = this.metadataNode.getExternalFile(ctx.getJobId(), dataverseName, datasetName, fileNumber);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        return file;
    }

    @Override
    public void dropDatasetExternalFiles(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws MetadataException {
        try {
            this.metadataNode.dropExternalFiles(mdTxnCtx.getJobId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void updateDataset(MetadataTransactionContext ctx, Dataset dataset) throws MetadataException {
        try {
            this.metadataNode.updateDataset(ctx.getJobId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataset(dataset.getDataverseName(), dataset.getDatasetName());
        ctx.addDataset(dataset);
    }

    @Override
    public void cleanupTempDatasets() {
        this.cache.cleanupTempDatasets();
    }

    public Dataset findDataset(MetadataTransactionContext ctx, String dataverseName, String datasetName) {
        Dataset dataset = ctx.getDataset(dataverseName, datasetName);
        if (dataset == null) {
            dataset = this.cache.getDataset(dataverseName, datasetName);
        }
        return dataset;
    }

    @Override
    public <T extends IExtensionMetadataEntity> void addEntity(MetadataTransactionContext mdTxnCtx, T entity) throws MetadataException {
        try {
            this.metadataNode.addEntity(mdTxnCtx.getJobId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void upsertEntity(MetadataTransactionContext mdTxnCtx, T entity) throws MetadataException {
        try {
            this.metadataNode.upsertEntity(mdTxnCtx.getJobId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void deleteEntity(MetadataTransactionContext mdTxnCtx, T entity) throws MetadataException {
        try {
            this.metadataNode.deleteEntity(mdTxnCtx.getJobId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> List<T> getEntities(MetadataTransactionContext mdTxnCtx, IExtensionMetadataSearchKey searchKey) throws MetadataException {
        try {
            return this.metadataNode.getEntities(mdTxnCtx.getJobId(), searchKey);
        }
        catch (RemoteException e) {
            throw new MetadataException(1044, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void rebindMetadataNode() {
        this.rebindMetadataNode = true;
    }

    public static void initialize(IAsterixStateProxy proxy, MetadataProperties metadataProperties) {
        INSTANCE = new CCMetadataManagerImpl(proxy, metadataProperties);
    }

    public static void initialize(IAsterixStateProxy proxy, MetadataNode metadataNode) {
        INSTANCE = new MetadataManager(proxy, metadataNode);
    }

    private static class CCMetadataManagerImpl
    extends MetadataManager {
        private final MetadataProperties metadataProperties;

        public CCMetadataManagerImpl(IAsterixStateProxy proxy, MetadataProperties metadataProperties) {
            super(proxy);
            this.metadataProperties = metadataProperties;
        }

        @Override
        public synchronized void init() throws HyracksDataException {
            if (this.metadataNode != null && !this.rebindMetadataNode) {
                return;
            }
            try {
                this.metadataNode = this.proxy.waitForMetadataNode(this.metadataProperties.getRegistrationTimeoutSecs(), TimeUnit.SECONDS);
                if (this.metadataNode == null) {
                    throw new HyracksDataException("The MetadataNode failed to bind before the configured timeout (" + this.metadataProperties.getRegistrationTimeoutSecs() + " seconds); the MetadataNode was configured to run on NC: " + this.metadataProperties.getMetadataNodeName());
                }
                this.rebindMetadataNode = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
            catch (RemoteException e) {
                throw new RuntimeDataException(1044, (Throwable)e, new Serializable[0]);
            }
            super.init();
        }
    }
}

