/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active.message;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.IActiveNotificationHandler;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;

public class ActivePartitionMessage
implements ICcAddressedMessage {
    private static final long serialVersionUID = 1L;
    public static final byte ACTIVE_RUNTIME_REGISTERED = 0;
    public static final byte ACTIVE_RUNTIME_DEREGISTERED = 1;
    public static final byte GENERIC_EVENT = 2;
    private final ActiveRuntimeId activeRuntimeId;
    private final JobId jobId;
    private final Serializable payload;
    private final byte event;

    public ActivePartitionMessage(ActiveRuntimeId activeRuntimeId, JobId jobId, byte event, Serializable payload) {
        this.activeRuntimeId = activeRuntimeId;
        this.jobId = jobId;
        this.event = event;
        this.payload = payload;
    }

    public ActiveRuntimeId getActiveRuntimeId() {
        return this.activeRuntimeId;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Serializable getPayload() {
        return this.payload;
    }

    public byte getEvent() {
        return this.event;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        IActiveNotificationHandler activeListener = (IActiveNotificationHandler)appCtx.getActiveNotificationHandler();
        activeListener.receive(this);
    }

    public String toString() {
        return ActivePartitionMessage.class.getSimpleName() + this.event;
    }

    public int hashCode() {
        return Objects.hash(this.activeRuntimeId, this.jobId, this.payload, this.event);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ActivePartitionMessage)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ActivePartitionMessage other = (ActivePartitionMessage)o;
        return Objects.equals(other.activeRuntimeId, this.activeRuntimeId) && Objects.equals(other.jobId, this.jobId) && Objects.equals(other.payload, this.payload);
    }
}

