/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.IActiveRuntime;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;

public abstract class ActiveSourceOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable
implements IActiveRuntime {
    private static final Logger LOGGER = Logger.getLogger(ActiveSourceOperatorNodePushable.class.getName());
    protected final IHyracksTaskContext ctx;
    protected final ActiveManager activeManager;
    protected final ActiveRuntimeId runtimeId;
    private volatile boolean done = false;

    public ActiveSourceOperatorNodePushable(IHyracksTaskContext ctx, ActiveRuntimeId runtimeId) {
        this.ctx = ctx;
        this.activeManager = (ActiveManager)((INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getActiveManager();
        this.runtimeId = runtimeId;
    }

    @Override
    public ActiveRuntimeId getRuntimeId() {
        return this.runtimeId;
    }

    protected abstract void start() throws HyracksDataException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() throws HyracksDataException, InterruptedException {
        this.abort();
        ActiveSourceOperatorNodePushable activeSourceOperatorNodePushable = this;
        synchronized (activeSourceOperatorNodePushable) {
            while (!this.done) {
                this.wait();
            }
        }
    }

    protected abstract void abort() throws HyracksDataException, InterruptedException;

    public String toString() {
        return this.runtimeId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() throws HyracksDataException {
        LOGGER.log(Level.INFO, "initialize() called on ActiveSourceOperatorNodePushable");
        this.activeManager.registerRuntime(this);
        try {
            this.ctx.sendApplicationMessageToCC((Serializable)((Object)new ActivePartitionMessage(this.runtimeId, this.ctx.getJobletContext().getJobId(), 0, null)), null);
            this.start();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.INFO, "initialize() interrupted on ActiveSourceOperatorNodePushable", e);
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "initialize() failed on ActiveSourceOperatorNodePushable", e);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            ActiveSourceOperatorNodePushable activeSourceOperatorNodePushable = this;
            synchronized (activeSourceOperatorNodePushable) {
                this.done = true;
                this.notifyAll();
            }
            LOGGER.log(Level.INFO, "initialize() returning on ActiveSourceOperatorNodePushable");
        }
    }

    public final void deinitialize() throws HyracksDataException {
        this.activeManager.deregisterRuntime(this.runtimeId);
        try {
            this.ctx.sendApplicationMessageToCC((Serializable)((Object)new ActivePartitionMessage(this.runtimeId, this.ctx.getJobletContext().getJobId(), 1, null)), null);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "deinitialize() failed on ActiveSourceOperatorNodePushable", e);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            LOGGER.log(Level.INFO, "deinitialize() returning on ActiveSourceOperatorNodePushable");
        }
    }

    public final IFrameWriter getInputFrameWriter(int index) {
        return null;
    }

    @Override
    public JobId getJobId() {
        return this.ctx.getJobletContext().getJobId();
    }
}

