/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.IActiveRuntime;
import org.apache.asterix.active.message.ActiveManagerMessage;
import org.apache.asterix.active.message.ActiveStatsResponse;
import org.apache.asterix.active.message.StatsRequestMessage;
import org.apache.asterix.common.api.ThreadExecutor;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.log4j.Logger;

public class ActiveManager {
    private static final Logger LOGGER = Logger.getLogger((String)ActiveManager.class.getName());
    private static final int SHUTDOWN_TIMEOUT_SECS = 60;
    private final ThreadExecutor executor;
    private final ConcurrentMap<ActiveRuntimeId, IActiveRuntime> runtimes;
    private final ConcurrentFramePool activeFramePool;
    private final String nodeId;
    private final INCServiceContext serviceCtx;
    private volatile boolean shutdown;

    public ActiveManager(ThreadExecutor executor, String nodeId, long activeMemoryBudget, int frameSize, INCServiceContext serviceCtx) throws HyracksDataException {
        this.executor = executor;
        this.nodeId = nodeId;
        this.activeFramePool = new ConcurrentFramePool(nodeId, activeMemoryBudget, frameSize);
        this.runtimes = new ConcurrentHashMap<ActiveRuntimeId, IActiveRuntime>();
        this.serviceCtx = serviceCtx;
    }

    public ConcurrentFramePool getFramePool() {
        return this.activeFramePool;
    }

    public void registerRuntime(IActiveRuntime runtime) throws HyracksDataException {
        if (this.shutdown) {
            throw new RuntimeDataException(3079, new Serializable[0]);
        }
        this.runtimes.putIfAbsent(runtime.getRuntimeId(), runtime);
    }

    public void deregisterRuntime(ActiveRuntimeId id) {
        this.runtimes.remove(id);
    }

    public IActiveRuntime getRuntime(ActiveRuntimeId runtimeId) {
        return (IActiveRuntime)this.runtimes.get(runtimeId);
    }

    public String toString() {
        return ActiveManager.class.getSimpleName() + "[" + this.nodeId + "]";
    }

    public void submit(ActiveManagerMessage message) throws HyracksDataException {
        switch (message.getKind()) {
            case 0: {
                this.stopRuntime(message);
                break;
            }
            case 1: {
                this.requestStats((StatsRequestMessage)message);
                break;
            }
            default: {
                LOGGER.warn((Object)("Unknown message type received: " + message.getKind()));
            }
        }
    }

    private void requestStats(StatsRequestMessage message) throws HyracksDataException {
        try {
            ActiveRuntimeId runtimeId = (ActiveRuntimeId)message.getPayload();
            IActiveRuntime runtime = (IActiveRuntime)this.runtimes.get(runtimeId);
            long reqId = message.getReqId();
            if (runtime == null) {
                LOGGER.warn((Object)("Request stats of a runtime that is not registered " + runtimeId));
                ((NodeControllerService)this.serviceCtx.getControllerService()).sendApplicationMessageToCC(JavaSerializationUtils.serialize((Serializable)((Object)new ActiveStatsResponse(reqId, null, (Exception)new RuntimeDataException(3088, new Serializable[]{runtimeId.toString()})))), null);
                return;
            }
            String stats = runtime.getStats();
            ActiveStatsResponse response = new ActiveStatsResponse(reqId, stats, null);
            ((NodeControllerService)this.serviceCtx.getControllerService()).sendApplicationMessageToCC(JavaSerializationUtils.serialize((Serializable)((Object)response)), null);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void shutdown() {
        LOGGER.warn((Object)("Shutting down ActiveManager on node " + this.nodeId));
        HashMap stopFutures = new HashMap();
        this.shutdown = true;
        this.runtimes.forEach((runtimeId, runtime) -> stopFutures.put(runtimeId, this.executor.submit(() -> {
            this.stopIfRunning((ActiveRuntimeId)runtimeId, (IActiveRuntime)runtime);
            return null;
        })));
        stopFutures.entrySet().parallelStream().forEach(entry -> {
            try {
                ((Future)entry.getValue()).get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn((Object)("Interrupted waiting to stop runtime: " + entry.getKey()));
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOGGER.warn((Object)("Exception while stopping runtime: " + entry.getKey()), (Throwable)e);
            }
            catch (TimeoutException e) {
                LOGGER.warn((Object)("Timed out waiting to stop runtime: " + entry.getKey()), (Throwable)e);
            }
        });
        LOGGER.warn((Object)("Shutdown ActiveManager on node " + this.nodeId + " complete"));
    }

    private void stopRuntime(ActiveManagerMessage message) {
        ActiveRuntimeId runtimeId = (ActiveRuntimeId)message.getPayload();
        IActiveRuntime runtime = (IActiveRuntime)this.runtimes.get(runtimeId);
        if (runtime == null) {
            LOGGER.warn((Object)("Request to stop a runtime that is not registered " + runtimeId));
        } else {
            this.executor.execute(() -> {
                try {
                    this.stopIfRunning(runtimeId, runtime);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Failed to stop runtime: " + runtimeId), (Throwable)e);
                }
            });
        }
    }

    private void stopIfRunning(ActiveRuntimeId runtimeId, IActiveRuntime runtime) throws HyracksDataException, InterruptedException {
        if (this.runtimes.remove(runtimeId) != null) {
            runtime.stop();
        } else {
            LOGGER.info((Object)("Not stopping already stopped runtime " + runtimeId));
        }
    }
}

