/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleWriter;
import org.apache.hyracks.storage.am.lsm.rtree.tuples.LSMRTreeTupleReferenceForPointMBR;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriter;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class LSMRTreeTupleWriterForPointMBR
extends RTreeTypeAwareTupleWriter
implements ILSMTreeTupleWriter {
    private final int inputKeyFieldCount;
    private final int valueFieldCount;
    private final int inputTotalFieldCount;
    private final int storedKeyFieldCount;
    private final int storedTotalFieldCount;
    private final boolean antimatterAware;
    private boolean isAntimatter;

    public LSMRTreeTupleWriterForPointMBR(ITypeTraits[] typeTraits, int keyFieldCount, int valueFieldCount, boolean antimatterAware, boolean isAntimatter) {
        super(typeTraits);
        this.inputKeyFieldCount = keyFieldCount;
        this.valueFieldCount = valueFieldCount;
        this.inputTotalFieldCount = keyFieldCount + valueFieldCount;
        this.storedKeyFieldCount = keyFieldCount / 2;
        this.storedTotalFieldCount = this.storedKeyFieldCount + valueFieldCount;
        this.antimatterAware = antimatterAware;
        this.isAntimatter = isAntimatter;
    }

    public int bytesRequired(ITupleReference tuple) {
        int i;
        int bytes = this.getNullFlagsBytes(tuple) + this.getFieldSlotsBytes(tuple);
        for (i = 0; i < this.storedKeyFieldCount; ++i) {
            bytes += tuple.getFieldLength(i);
        }
        for (i = this.inputKeyFieldCount; i < this.inputTotalFieldCount; ++i) {
            bytes += tuple.getFieldLength(i);
        }
        return bytes;
    }

    public ITreeIndexTupleReference createTupleReference() {
        return new LSMRTreeTupleReferenceForPointMBR(this.typeTraits, this.inputKeyFieldCount, this.valueFieldCount, this.antimatterAware);
    }

    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int i;
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(tuple);
        for (i = 0; i < nullFlagsBytes; ++i) {
            targetBuf[runner++] = 0;
        }
        for (i = this.inputKeyFieldCount; i < this.inputTotalFieldCount; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            runner += VarLenIntEncoderDecoder.encode((int)tuple.getFieldLength(i), (byte[])targetBuf, (int)runner);
        }
        for (i = 0; i < this.storedKeyFieldCount; ++i) {
            System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), targetBuf, runner, tuple.getFieldLength(i));
            runner += tuple.getFieldLength(i);
        }
        for (i = this.inputKeyFieldCount; i < this.inputTotalFieldCount; ++i) {
            System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), targetBuf, runner, tuple.getFieldLength(i));
            runner += tuple.getFieldLength(i);
        }
        if (this.antimatterAware && tuple instanceof ILSMTreeTupleReference && ((ILSMTreeTupleReference)tuple).isAntimatter()) {
            this.setAntimatterBit(targetBuf, targetOff);
        }
        if (this.isAntimatter) {
            this.setAntimatterBit(targetBuf, targetOff);
        }
        return runner - targetOff;
    }

    public int writeTupleFields(ITupleReference tuple, int startField, int numFields, byte[] targetBuf, int targetOff) {
        throw new UnsupportedOperationException("writeTupleFields(ITupleReference, int, int, byte[], int) not implemented for RTreeTypeAwareTupleWriterForPointMBR class.");
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        return (int)Math.ceil((double)(this.storedTotalFieldCount + (this.antimatterAware ? 1 : 0)) / 8.0);
    }

    protected int getFieldSlotsBytes(ITupleReference tuple) {
        int fieldSlotBytes = 0;
        for (int i = this.inputKeyFieldCount; i < this.inputTotalFieldCount; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            fieldSlotBytes += VarLenIntEncoderDecoder.getBytesRequired((int)tuple.getFieldLength(i));
        }
        return fieldSlotBytes;
    }

    public int getCopySpaceRequired(ITupleReference tuple) {
        return this.bytesRequired(tuple);
    }

    protected void setAntimatterBit(byte[] targetBuf, int targetOff) {
        targetBuf[targetOff] = (byte)(targetBuf[targetOff] | 0x80);
    }

    public void setAntimatter(boolean isAntimatter) {
        this.isAntimatter = isAntimatter;
    }
}

