/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleWriter;
import org.apache.hyracks.storage.am.lsm.rtree.tuples.LSMRTreeTupleReference;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriter;

public class LSMRTreeTupleWriter
extends RTreeTypeAwareTupleWriter
implements ILSMTreeTupleWriter {
    private boolean isAntimatter;

    public LSMRTreeTupleWriter(ITypeTraits[] typeTraits, boolean isAntimatter) {
        super(typeTraits);
        this.isAntimatter = isAntimatter;
    }

    public ITreeIndexTupleReference createTupleReference() {
        return new LSMRTreeTupleReference(this.typeTraits);
    }

    public int bytesRequired(ITupleReference tuple) {
        return super.bytesRequired(tuple);
    }

    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int bytesWritten = super.writeTuple(tuple, targetBuf, targetOff);
        if (this.isAntimatter) {
            this.setAntimatterBit(targetBuf, targetOff);
        }
        return bytesWritten;
    }

    protected int getNullFlagsBytes(int numFields) {
        return (int)Math.ceil(((double)numFields + 1.0) / 8.0);
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        return (int)Math.ceil(((double)tuple.getFieldCount() + 1.0) / 8.0);
    }

    protected void setAntimatterBit(byte[] targetBuf, int targetOff) {
        targetBuf[targetOff] = (byte)(targetBuf[targetOff] | 0x80);
    }

    public void setAntimatter(boolean isAntimatter) {
        this.isAntimatter = isAntimatter;
    }
}

