/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class LSMRTreeTupleReferenceForPointMBR
implements ILSMTreeTupleReference {
    private final int inputKeyFieldCount;
    private final int inputTotalFieldCount;
    private final int storedKeyFieldCount;
    private final ITypeTraits[] typeTraits;
    private final int nullFlagsBytes;
    private final int[] decodedFieldSlots;
    private byte[] buf;
    private int tupleStartOff;
    private int dataStartOff;
    private final boolean antimatterAware;
    private VarLenIntEncoderDecoder.VarLenIntDecoder encDec = VarLenIntEncoderDecoder.createDecoder();

    public LSMRTreeTupleReferenceForPointMBR(ITypeTraits[] typeTraits, int keyFieldCount, int valueFieldCount, boolean antimatterAware) {
        this.inputKeyFieldCount = keyFieldCount;
        this.inputTotalFieldCount = keyFieldCount + valueFieldCount;
        this.storedKeyFieldCount = keyFieldCount / 2;
        this.typeTraits = typeTraits;
        this.nullFlagsBytes = this.getNullFlagsBytes();
        this.decodedFieldSlots = new int[this.inputTotalFieldCount];
        this.antimatterAware = antimatterAware;
    }

    public void resetByTupleOffset(byte[] buf, int tupleStartOff) {
        int i;
        this.buf = buf;
        this.tupleStartOff = tupleStartOff;
        int field = 0;
        int cumul = 0;
        for (i = 0; i < this.storedKeyFieldCount; ++i) {
            this.decodedFieldSlots[field++] = cumul += this.typeTraits[i].getFixedLength();
        }
        for (i = 0; i < this.storedKeyFieldCount; ++i) {
            this.decodedFieldSlots[field++] = this.decodedFieldSlots[i];
        }
        this.encDec.reset(buf, tupleStartOff + this.nullFlagsBytes);
        for (i = this.inputKeyFieldCount; i < this.inputTotalFieldCount; ++i) {
            this.decodedFieldSlots[field++] = !this.typeTraits[i].isFixedLength() ? (cumul += this.encDec.decode()) : (cumul += this.typeTraits[i].getFixedLength());
        }
        this.dataStartOff = this.encDec.getPos();
    }

    public void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        this.resetByTupleOffset(frame.getBuffer().array(), frame.getTupleOffset(tupleIndex));
    }

    public void setFieldCount(int fieldCount) {
    }

    public void setFieldCount(int fieldStartIndex, int fieldCount) {
    }

    public int getFieldCount() {
        return this.inputTotalFieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        return this.buf;
    }

    public int getFieldLength(int fIdx) {
        if (this.getInternalFieldIdx(fIdx) == 0) {
            return this.decodedFieldSlots[0];
        }
        return this.decodedFieldSlots[this.getInternalFieldIdx(fIdx)] - this.decodedFieldSlots[this.getInternalFieldIdx(fIdx) - 1];
    }

    public int getFieldStart(int fIdx) {
        if (this.getInternalFieldIdx(fIdx) == 0) {
            return this.dataStartOff;
        }
        return this.dataStartOff + this.decodedFieldSlots[this.getInternalFieldIdx(fIdx) - 1];
    }

    private int getInternalFieldIdx(int fIdx) {
        if (fIdx >= this.storedKeyFieldCount && fIdx < this.inputKeyFieldCount) {
            return fIdx % this.storedKeyFieldCount;
        }
        return fIdx;
    }

    private int getNullFlagsBytes() {
        return (int)Math.ceil((double)(this.inputTotalFieldCount + (this.antimatterAware ? 1 : 0)) / 8.0);
    }

    public int getTupleSize() {
        return this.dataStartOff - this.tupleStartOff + this.decodedFieldSlots[this.inputTotalFieldCount - 1];
    }

    public boolean isAntimatter() {
        int mask = -128;
        return (this.buf[this.tupleStartOff] & 0xFFFFFF80) != 0;
    }
}

