/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMRTreeWithAntiMatterTuplesSearchCursor
extends LSMIndexSearchCursor {
    private ITreeIndexAccessor[] mutableRTreeAccessors;
    private ITreeIndexAccessor[] btreeAccessors;
    private RTreeSearchCursor[] mutableRTreeCursors;
    private ITreeIndexCursor[] btreeCursors;
    private RangePredicate btreeRangePredicate;
    private boolean foundNext;
    private ITupleReference frameTuple;
    private int[] comparatorFields;
    private MultiComparator btreeCmp;
    private int currentCursor = 0;
    private SearchPredicate rtreeSearchPredicate;
    private int numMutableComponents;
    private boolean open;
    protected ISearchOperationCallback searchCallback;

    public LSMRTreeWithAntiMatterTuplesSearchCursor(ILSMIndexOperationContext opCtx) {
        this(opCtx, false);
    }

    public LSMRTreeWithAntiMatterTuplesSearchCursor(ILSMIndexOperationContext opCtx, boolean returnDeletedTuples) {
        super(opCtx, returnDeletedTuples);
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMRTreeCursorInitialState lsmInitialState = (LSMRTreeCursorInitialState)initialState;
        this.cmp = lsmInitialState.getHilbertCmp();
        this.btreeCmp = lsmInitialState.getBTreeCmp();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.comparatorFields = lsmInitialState.getComparatorFields();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.rtreeSearchPredicate = (SearchPredicate)searchPred;
        this.searchCallback = lsmInitialState.getSearchOperationCallback();
        this.includeMutableComponent = false;
        this.numMutableComponents = 0;
        int numImmutableComponents = 0;
        for (ILSMComponent component : this.operationalComponents) {
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
                ++this.numMutableComponents;
                continue;
            }
            ++numImmutableComponents;
        }
        if (this.includeMutableComponent) {
            this.btreeRangePredicate = new RangePredicate(null, null, true, true, this.btreeCmp, this.btreeCmp);
        }
        this.mutableRTreeCursors = new RTreeSearchCursor[this.numMutableComponents];
        this.mutableRTreeAccessors = new ITreeIndexAccessor[this.numMutableComponents];
        this.btreeCursors = new BTreeRangeSearchCursor[this.numMutableComponents];
        this.btreeAccessors = new ITreeIndexAccessor[this.numMutableComponents];
        for (int i = 0; i < this.numMutableComponents; ++i) {
            ILSMComponent component;
            component = (ILSMComponent)this.operationalComponents.get(i);
            RTree rtree = ((LSMRTreeMemoryComponent)component).getRTree();
            BTree btree = ((LSMRTreeMemoryComponent)component).getBTree();
            this.mutableRTreeCursors[i] = new RTreeSearchCursor((IRTreeInteriorFrame)lsmInitialState.getRTreeInteriorFrameFactory().createFrame(), (IRTreeLeafFrame)lsmInitialState.getRTreeLeafFrameFactory().createFrame());
            this.btreeCursors[i] = new BTreeRangeSearchCursor((IBTreeLeafFrame)lsmInitialState.getBTreeLeafFrameFactory().createFrame(), false);
            this.btreeAccessors[i] = btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.mutableRTreeAccessors[i] = rtree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        }
        this.rangeCursors = new RTreeSearchCursor[numImmutableComponents];
        ITreeIndexAccessor[] immutableRTreeAccessors = new ITreeIndexAccessor[numImmutableComponents];
        int j = 0;
        for (int i = this.numMutableComponents; i < this.operationalComponents.size(); ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            this.rangeCursors[j] = new RTreeSearchCursor((IRTreeInteriorFrame)lsmInitialState.getRTreeInteriorFrameFactory().createFrame(), (IRTreeLeafFrame)lsmInitialState.getRTreeLeafFrameFactory().createFrame());
            RTree rtree = ((LSMRTreeDiskComponent)component).getRTree();
            immutableRTreeAccessors[j] = rtree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            immutableRTreeAccessors[j].search(this.rangeCursors[j], searchPred);
            ++j;
        }
        this.searchNextCursor();
        this.setPriorityQueueComparator();
        this.initPriorityQueue();
        this.open = true;
    }

    private void searchNextCursor() throws HyracksDataException {
        if (this.currentCursor < this.numMutableComponents) {
            this.mutableRTreeCursors[this.currentCursor].reset();
            this.mutableRTreeAccessors[this.currentCursor].search((IIndexCursor)this.mutableRTreeCursors[this.currentCursor], (ISearchPredicate)this.rtreeSearchPredicate);
        }
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.includeMutableComponent) {
            if (this.foundNext) {
                return true;
            }
            while (this.currentCursor < this.numMutableComponents) {
                while (this.mutableRTreeCursors[this.currentCursor].hasNext()) {
                    this.mutableRTreeCursors[this.currentCursor].next();
                    ITupleReference currentTuple = this.mutableRTreeCursors[this.currentCursor].getTuple();
                    this.searchCallback.proceed(currentTuple);
                    if (!this.searchMemBTrees(currentTuple, this.currentCursor)) continue;
                    this.foundNext = true;
                    this.frameTuple = currentTuple;
                    return true;
                }
                this.mutableRTreeCursors[this.currentCursor].close();
                ++this.currentCursor;
                this.searchNextCursor();
            }
            while (super.hasNext()) {
                super.next();
                ITupleReference diskRTreeTuple = super.getTuple();
                this.searchCallback.proceed(diskRTreeTuple);
                if (!this.searchMemBTrees(diskRTreeTuple, this.numMutableComponents)) continue;
                this.foundNext = true;
                this.frameTuple = diskRTreeTuple;
                return true;
            }
        } else if (super.hasNext()) {
            super.next();
            ITupleReference diskRTreeTuple = super.getTuple();
            this.searchCallback.proceed(diskRTreeTuple);
            this.foundNext = true;
            this.frameTuple = diskRTreeTuple;
            return true;
        }
        return false;
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = ((ILSMComponent)this.operationalComponents.get(this.currentCursor < this.numMutableComponents ? this.currentCursor : this.outputElement.getCursorIndex() + this.currentCursor)).getLSMComponentFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = ((ILSMComponent)this.operationalComponents.get(this.currentCursor < this.numMutableComponents ? this.currentCursor : this.outputElement.getCursorIndex() + this.currentCursor)).getLSMComponentFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    public void next() throws HyracksDataException {
        this.foundNext = false;
    }

    public ITupleReference getTuple() {
        return this.frameTuple;
    }

    public void reset() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        this.currentCursor = 0;
        this.foundNext = false;
        if (this.includeMutableComponent) {
            for (int i = 0; i < this.numMutableComponents; ++i) {
                this.mutableRTreeCursors[i].reset();
                this.btreeCursors[i].reset();
            }
        }
        super.reset();
    }

    public void close() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        if (this.includeMutableComponent) {
            for (int i = 0; i < this.numMutableComponents; ++i) {
                this.mutableRTreeCursors[i].close();
                this.btreeCursors[i].close();
            }
        }
        this.currentCursor = 0;
        this.open = false;
        super.close();
    }

    protected int compare(MultiComparator cmp, ITupleReference tupleA, ITupleReference tupleB) throws HyracksDataException {
        return cmp.selectiveFieldCompare(tupleA, tupleB, this.comparatorFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searchMemBTrees(ITupleReference tuple, int lastBTreeToSearch) throws HyracksDataException {
        for (int i = 0; i < lastBTreeToSearch; ++i) {
            this.btreeCursors[i].reset();
            this.btreeRangePredicate.setHighKey(tuple, true);
            this.btreeRangePredicate.setLowKey(tuple, true);
            this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
            try {
                if (!this.btreeCursors[i].hasNext()) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                this.btreeCursors[i].close();
            }
        }
        return true;
    }

    protected void setPriorityQueueComparator() {
        if (this.pqCmp == null || this.cmp != this.pqCmp.getMultiComparator()) {
            this.pqCmp = new PriorityQueueHilbertComparator(this.cmp, this.comparatorFields);
        }
    }

    public class PriorityQueueHilbertComparator
    extends LSMIndexSearchCursor.PriorityQueueComparator {
        private final int[] comparatorFields;

        public PriorityQueueHilbertComparator(MultiComparator cmp, int[] comparatorFields) {
            super((LSMIndexSearchCursor)LSMRTreeWithAntiMatterTuplesSearchCursor.this, cmp);
            this.comparatorFields = comparatorFields;
        }

        public int compare(LSMIndexSearchCursor.PriorityQueueElement elementA, LSMIndexSearchCursor.PriorityQueueElement elementB) {
            try {
                int result = this.cmp.selectiveFieldCompare(elementA.getTuple(), elementB.getTuple(), this.comparatorFields);
                if (result != 0) {
                    return result;
                }
            }
            catch (HyracksDataException e) {
                throw new IllegalArgumentException(e);
            }
            if (elementA.getCursorIndex() > elementB.getCursorIndex()) {
                return 1;
            }
            return -1;
        }
    }
}

