/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.TreeTupleSorter;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMRTreeWithAntiMatterTuplesFlushCursor
implements ITreeIndexCursor {
    private final TreeTupleSorter rTreeTupleSorter;
    private final TreeTupleSorter bTreeTupleSorter;
    private final int[] comparatorFields;
    private final MultiComparator cmp;
    private ITupleReference frameTuple;
    private ITupleReference leftOverTuple;
    private ITupleReference rtreeTuple;
    private ITupleReference btreeTuple;
    private boolean foundNext = false;

    public LSMRTreeWithAntiMatterTuplesFlushCursor(TreeTupleSorter rTreeTupleSorter, TreeTupleSorter bTreeTupleSorter, int[] comparatorFields, IBinaryComparatorFactory[] comparatorFactories) {
        this.rTreeTupleSorter = rTreeTupleSorter;
        this.bTreeTupleSorter = bTreeTupleSorter;
        this.comparatorFields = comparatorFields;
        this.cmp = MultiComparator.create((IBinaryComparatorFactory[])comparatorFactories);
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasNext() throws HyracksDataException {
        if (this.foundNext) {
            return true;
        }
        if (this.leftOverTuple != null && this.leftOverTuple == this.rtreeTuple) {
            if (!this.bTreeTupleSorter.hasNext()) {
                this.frameTuple = this.rtreeTuple;
                this.foundNext = true;
                this.leftOverTuple = null;
                return true;
            }
            this.bTreeTupleSorter.next();
            this.btreeTuple = this.bTreeTupleSorter.getTuple();
        } else if (this.leftOverTuple != null && this.leftOverTuple == this.btreeTuple) {
            if (!this.rTreeTupleSorter.hasNext()) {
                this.frameTuple = this.btreeTuple;
                this.foundNext = true;
                this.leftOverTuple = null;
                return true;
            }
            this.rTreeTupleSorter.next();
            this.rtreeTuple = this.rTreeTupleSorter.getTuple();
        } else if (this.rTreeTupleSorter.hasNext() && this.bTreeTupleSorter.hasNext()) {
            this.rTreeTupleSorter.next();
            this.bTreeTupleSorter.next();
            this.rtreeTuple = this.rTreeTupleSorter.getTuple();
            this.btreeTuple = this.bTreeTupleSorter.getTuple();
        } else {
            if (this.rTreeTupleSorter.hasNext()) {
                this.rTreeTupleSorter.next();
                this.frameTuple = this.rtreeTuple = this.rTreeTupleSorter.getTuple();
                this.leftOverTuple = null;
                this.foundNext = true;
                return true;
            }
            if (this.bTreeTupleSorter.hasNext()) {
                this.bTreeTupleSorter.next();
                this.frameTuple = this.btreeTuple = this.bTreeTupleSorter.getTuple();
                this.leftOverTuple = null;
                this.foundNext = true;
                return true;
            }
            return false;
        }
        int c = this.cmp.selectiveFieldCompare(this.rtreeTuple, this.btreeTuple, this.comparatorFields);
        if (c == 0) {
            this.frameTuple = this.rtreeTuple;
            this.leftOverTuple = null;
            this.foundNext = true;
            return true;
        }
        if (c < 0) {
            this.frameTuple = this.rtreeTuple;
            this.leftOverTuple = this.btreeTuple;
            this.foundNext = true;
            return true;
        }
        this.frameTuple = this.btreeTuple;
        this.leftOverTuple = this.rtreeTuple;
        this.foundNext = true;
        return true;
    }

    public void next() throws HyracksDataException {
        this.foundNext = false;
    }

    public void close() throws HyracksDataException {
    }

    public void reset() throws HyracksDataException {
    }

    public ITupleReference getTuple() {
        return this.frameTuple;
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }

    public void setBufferCache(IBufferCache bufferCache) {
    }

    public void setFileId(int fileId) {
    }

    public boolean isExclusiveLatchNodes() {
        return false;
    }
}

