/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;
import org.apache.hyracks.storage.am.rtree.impls.RTree;

public class LSMRTreeDiskComponent
extends AbstractLSMDiskComponent {
    private final RTree rtree;
    private final BTree btree;
    private final BloomFilter bloomFilter;

    public LSMRTreeDiskComponent(RTree rtree, BTree btree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super((IMetadataPageManager)rtree.getPageManager(), filter);
        this.rtree = rtree;
        this.btree = btree;
        this.bloomFilter = bloomFilter;
    }

    public void destroy() throws HyracksDataException {
        this.rtree.deactivate();
        this.rtree.destroy();
        if (this.btree != null) {
            this.btree.deactivate();
            this.btree.destroy();
            this.bloomFilter.deactivate();
            this.bloomFilter.destroy();
        }
    }

    public RTree getRTree() {
        return this.rtree;
    }

    public BTree getBTree() {
        return this.btree;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public long getComponentSize() {
        long size = this.rtree.getFileReference().getFile().length();
        if (this.btree != null) {
            size += this.btree.getFileReference().getFile().length();
            size += this.bloomFilter.getFileReference().getFile().length();
        }
        return size;
    }

    public int getFileReferenceCount() {
        return this.rtree.getBufferCache().getFileReferenceCount(this.rtree.getFileId());
    }
}

