/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.server.HttpServerHandler;
import org.apache.hyracks.http.server.HttpServerInitializer;

public class HttpServer {
    private static final int LOW_WRITE_BUFFER_WATER_MARK = 8192;
    private static final int HIGH_WRITE_BUFFER_WATER_MARK = 32768;
    protected static final WriteBufferWaterMark WRITE_BUFFER_WATER_MARK = new WriteBufferWaterMark(8192, 32768);
    private static final Logger LOGGER = Logger.getLogger(HttpServer.class.getName());
    private static final int FAILED = -1;
    private static final int STOPPED = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private static final int STOPPING = 3;
    private final Object lock = new Object();
    private final AtomicInteger threadId = new AtomicInteger();
    private final ConcurrentMap<String, Object> ctx;
    private final List<IServlet> servlets;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final int port;
    private final ExecutorService executor;
    private volatile int state = 0;
    private Channel channel;
    private Throwable cause;

    public HttpServer(EventLoopGroup bossGroup, EventLoopGroup workerGroup, int port) {
        this(bossGroup, workerGroup, port, 16, 256);
    }

    public HttpServer(EventLoopGroup bossGroup, EventLoopGroup workerGroup, int port, int numExecutorThreads, int requestQueueSize) {
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.port = port;
        this.ctx = new ConcurrentHashMap<String, Object>();
        this.servlets = new ArrayList<IServlet>();
        this.executor = new ThreadPoolExecutor(numExecutorThreads, numExecutorThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(requestQueueSize), runnable -> new Thread(runnable, "HttpExecutor(port:" + port + ")-" + this.threadId.getAndIncrement()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == 2 || this.state == 1) {
                    return;
                }
                this.setStarting();
                this.doStart();
                this.setStarted();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failure starting an Http Server", e);
                this.setFailed(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == 3 || this.state == 0) {
                    return;
                }
                this.setStopping();
                this.doStop();
                this.setStopped();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failure stopping an Http Server", e);
                this.setFailed(e);
                throw e;
            }
        }
    }

    public String getState() {
        switch (this.state) {
            case -1: {
                return "FAILED";
            }
            case 1: {
                return "STARTING";
            }
            case 2: {
                return "STARTED";
            }
            case 3: {
                return "STOPPING";
            }
            case 0: {
                return "STOPPED";
            }
        }
        return "UNKNOWN";
    }

    private void setStarting() {
        this.state = 1;
    }

    private void setStarted() {
        this.state = 2;
    }

    private void setStopping() {
        this.state = 3;
    }

    private void setStopped() {
        this.state = 0;
    }

    private void setFailed(Throwable th) {
        this.state = -1;
        this.cause = th;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setAttribute(String name, Object value) {
        this.ctx.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.ctx.get(name);
    }

    public ConcurrentMap<String, Object> ctx() {
        return this.ctx;
    }

    public void addServlet(IServlet let) {
        this.servlets.add(let);
    }

    protected void doStart() throws InterruptedException {
        Collections.sort(this.servlets, (l1, l2) -> l2.getPaths()[0].length() - l1.getPaths()[0].length());
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)WRITE_BUFFER_WATER_MARK).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new HttpServerInitializer(this));
        this.channel = b.bind(this.port).sync().channel();
    }

    protected void doStop() throws InterruptedException {
        this.channel.close();
        this.channel.closeFuture().sync();
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
            if (!this.executor.isTerminated()) {
                LOGGER.log(Level.SEVERE, "Failed to shutdown http server executor");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while shutting down http server executor", e);
        }
    }

    public IServlet getServlet(FullHttpRequest request) {
        String uri = request.uri();
        int i = uri.indexOf(63);
        if (i >= 0) {
            uri = uri.substring(0, i);
        }
        for (IServlet servlet : this.servlets) {
            for (String path : servlet.getPaths()) {
                if (!HttpServer.match(path, uri)) continue;
                return servlet;
            }
        }
        return null;
    }

    static boolean match(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.equals(path) || pathSpec.length() == 1 && path.isEmpty()) {
                return true;
            }
            if (HttpServer.isPathWildcardMatch(pathSpec, path)) {
                return true;
            }
        } else if (c == '*') {
            return path.regionMatches(path.length() - pathSpec.length() + 1, pathSpec, 1, pathSpec.length() - 1);
        }
        return false;
    }

    static boolean isPathWildcardMatch(String pathSpec, String path) {
        int length = pathSpec.length();
        if (length < 2) {
            return false;
        }
        int cpl = length - 2;
        boolean b = pathSpec.endsWith("/*") && path.regionMatches(0, pathSpec, 0, cpl);
        return b && (path.length() == cpl || '/' == path.charAt(cpl));
    }

    protected HttpServerHandler createHttpHandler(int chunkSize) {
        return new HttpServerHandler<HttpServer>(this, chunkSize);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    protected EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }
}

