/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.ChunkedResponse;
import org.apache.hyracks.http.server.FullResponse;

public class HttpRequestHandler
implements Callable<Void> {
    private static final Logger LOGGER = Logger.getLogger(HttpRequestHandler.class.getName());
    private final ChannelHandlerContext ctx;
    private final IServlet servlet;
    private final IServletRequest request;
    private final IServletResponse response;

    public HttpRequestHandler(ChannelHandlerContext ctx, IServlet servlet, IServletRequest request, int chunkSize) {
        this.ctx = ctx;
        this.servlet = servlet;
        this.request = request;
        this.response = chunkSize == 0 ? new FullResponse(ctx, request.getHttpRequest()) : new ChunkedResponse(ctx, request.getHttpRequest(), chunkSize);
        request.getHttpRequest().retain();
    }

    @Override
    public Void call() throws Exception {
        try {
            ChannelFuture lastContentFuture = this.handle();
            if (!HttpUtil.isKeepAlive((HttpMessage)this.request.getHttpRequest())) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Throwable th) {
            LOGGER.log(Level.SEVERE, "Failure handling HTTP Request", th);
            this.ctx.close();
        }
        finally {
            this.request.getHttpRequest().release();
        }
        return null;
    }

    private ChannelFuture handle() throws IOException {
        try {
            this.servlet.handle(this.request, this.response);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure during handling of an IServletRequest", e);
            this.response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            this.response.close();
        }
        return this.response.lastContentFuture();
    }

    public void notifyChannelWritable() {
        this.response.notifyChannelWritable();
    }

    public void reject() throws IOException {
        this.response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
        this.response.close();
    }
}

