/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.comm.IConnectionWriterState;
import org.apache.hyracks.api.comm.MuxDemuxCommand;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import org.apache.hyracks.net.protocols.muxdemux.ChannelSet;
import org.apache.hyracks.net.protocols.muxdemux.IEventCounter;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemux;
import org.apache.hyracks.net.protocols.tcp.ITCPConnectionEventListener;
import org.apache.hyracks.net.protocols.tcp.TCPConnection;

public class MultiplexedConnection
implements ITCPConnectionEventListener {
    private static final Logger LOGGER = Logger.getLogger(MultiplexedConnection.class.getName());
    private static final int MAX_CHUNKS_READ_PER_CYCLE = 4;
    private final MuxDemux muxDemux;
    private final IEventCounter pendingWriteEventsCounter;
    private final ChannelSet cSet;
    private final ReaderState readerState;
    private final WriterState writerState;
    private TCPConnection tcpConnection;
    private int lastChannelWritten;
    private int nConnectionAttempts;
    private boolean connectionFailure;
    private Exception error;

    MultiplexedConnection(MuxDemux muxDemux) {
        this.muxDemux = muxDemux;
        this.pendingWriteEventsCounter = new IEventCounter(){
            private int counter;

            @Override
            public synchronized void increment() {
                ++this.counter;
                if (this.counter == 1) {
                    MultiplexedConnection.this.tcpConnection.enable(4);
                }
            }

            @Override
            public synchronized void decrement() {
                --this.counter;
                if (this.counter == 0) {
                    MultiplexedConnection.this.tcpConnection.disable(4);
                }
                if (this.counter < 0) {
                    throw new IllegalStateException();
                }
            }
        };
        this.cSet = new ChannelSet(this, this.pendingWriteEventsCounter);
        this.readerState = new ReaderState();
        this.writerState = new WriterState();
        this.lastChannelWritten = -1;
        this.connectionFailure = false;
    }

    int getConnectionAttempts() {
        return this.nConnectionAttempts;
    }

    void setConnectionAttempts(int nConnectionAttempts) {
        this.nConnectionAttempts = nConnectionAttempts;
    }

    synchronized void setTCPConnection(TCPConnection tcpConnection) {
        this.tcpConnection = tcpConnection;
        tcpConnection.enable(1);
        this.notifyAll();
    }

    synchronized void setConnectionFailure(Exception e) {
        this.connectionFailure = true;
        this.error = e;
        this.notifyAll();
    }

    synchronized void waitUntilConnected() throws InterruptedException, NetException {
        while (this.tcpConnection == null && !this.connectionFailure) {
            this.wait();
        }
        if (this.connectionFailure) {
            throw new NetException("Connection failure", (Throwable)this.error);
        }
    }

    @Override
    public void notifyIOReady(TCPConnection connection, boolean readable, boolean writable) throws IOException, NetException {
        if (readable) {
            this.driveReaderStateMachine();
        }
        if (writable) {
            this.driveWriterStateMachine();
        }
    }

    @Override
    public synchronized void notifyIOError(Exception e) {
        this.connectionFailure = true;
        this.error = e;
        this.cSet.notifyIOError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelControlBlock openChannel() throws NetException {
        MultiplexedConnection multiplexedConnection = this;
        synchronized (multiplexedConnection) {
            if (this.connectionFailure) {
                throw new NetException((Throwable)this.error);
            }
        }
        ChannelControlBlock channel = this.cSet.allocateChannel();
        int channelId = channel.getChannelId();
        this.cSet.initiateChannelSyn(channelId);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void driveWriterStateMachine() throws IOException, NetException {
        int numCycles;
        SocketChannel sc = this.tcpConnection.getSocketChannel();
        if (this.writerState.writePending()) {
            if (!this.writerState.performPendingWrite(sc)) {
                return;
            }
            this.pendingWriteEventsCounter.decrement();
        }
        MultiplexedConnection multiplexedConnection = this;
        synchronized (multiplexedConnection) {
            numCycles = this.cSet.getOpenChannelCount();
        }
        for (int i = 0; i < numCycles; ++i) {
            ChannelControlBlock writeCCB = null;
            MultiplexedConnection multiplexedConnection2 = this;
            synchronized (multiplexedConnection2) {
                BitSet pendingChannelSynBitmap = this.cSet.getPendingChannelSynBitmap();
                int j = pendingChannelSynBitmap.nextSetBit(0);
                while (j >= 0) {
                    pendingChannelSynBitmap.clear(j);
                    this.writerState.command.setChannelId(j);
                    this.writerState.command.setCommandType(MuxDemuxCommand.CommandType.OPEN_CHANNEL);
                    this.writerState.command.setData(0);
                    this.writerState.reset(null, 0, null);
                    if (!this.writerState.performPendingWrite(sc)) {
                        return;
                    }
                    this.pendingWriteEventsCounter.decrement();
                    j = pendingChannelSynBitmap.nextSetBit(j);
                }
                BitSet pendingChannelCreditsBitmap = this.cSet.getPendingChannelCreditsBitmap();
                int j2 = pendingChannelCreditsBitmap.nextSetBit(0);
                while (j2 >= 0) {
                    int effectiveCredits;
                    this.writerState.command.setChannelId(j2);
                    this.writerState.command.setCommandType(MuxDemuxCommand.CommandType.ADD_CREDITS);
                    ChannelControlBlock ccb = this.cSet.getCCB(j2);
                    int credits = ccb.getReadCredits();
                    if (credits <= 0x1FFFFFFF) {
                        effectiveCredits = credits;
                        ccb.setReadCredits(0);
                        pendingChannelCreditsBitmap.clear(j2);
                    } else {
                        effectiveCredits = 0x1FFFFFFF;
                        ccb.setReadCredits(credits - effectiveCredits);
                    }
                    this.writerState.command.setData(effectiveCredits);
                    this.writerState.reset(null, 0, null);
                    if (!this.writerState.performPendingWrite(sc)) {
                        return;
                    }
                    if (credits == effectiveCredits) {
                        this.pendingWriteEventsCounter.decrement();
                    }
                    j2 = pendingChannelCreditsBitmap.nextSetBit(j2);
                }
                BitSet pendingEOSAckBitmap = this.cSet.getPendingEOSAckBitmap();
                int j3 = pendingEOSAckBitmap.nextSetBit(0);
                while (j3 >= 0) {
                    pendingEOSAckBitmap.clear(j3);
                    ChannelControlBlock ccb = this.cSet.getCCB(j3);
                    ccb.reportRemoteEOSAck();
                    this.writerState.command.setChannelId(j3);
                    this.writerState.command.setCommandType(MuxDemuxCommand.CommandType.CLOSE_CHANNEL_ACK);
                    this.writerState.command.setData(0);
                    this.writerState.reset(null, 0, null);
                    if (!this.writerState.performPendingWrite(sc)) {
                        return;
                    }
                    this.pendingWriteEventsCounter.decrement();
                    j3 = pendingEOSAckBitmap.nextSetBit(j3);
                }
                BitSet pendingChannelWriteBitmap = this.cSet.getPendingChannelWriteBitmap();
                this.lastChannelWritten = pendingChannelWriteBitmap.nextSetBit(this.lastChannelWritten + 1);
                if (this.lastChannelWritten == -1) {
                    this.lastChannelWritten = pendingChannelWriteBitmap.nextSetBit(0);
                    if (this.lastChannelWritten == -1) {
                        return;
                    }
                }
                writeCCB = this.cSet.getCCB(this.lastChannelWritten);
            }
            writeCCB.write(this.writerState);
            if (!this.writerState.writePending()) continue;
            this.pendingWriteEventsCounter.increment();
            if (!this.writerState.performPendingWrite(sc)) {
                return;
            }
            this.pendingWriteEventsCounter.decrement();
        }
    }

    void driveReaderStateMachine() throws IOException, NetException {
        SocketChannel sc = this.tcpConnection.getSocketChannel();
        int chunksRead = 0;
        while (chunksRead < 4) {
            if (this.readerState.readBuffer.remaining() > 0) {
                int read = sc.read(this.readerState.readBuffer);
                if (read < 0) {
                    throw new NetException("Socket Closed");
                }
                this.muxDemux.getPerformanceCounters().addSignalingBytesRead(read);
                if (this.readerState.readBuffer.remaining() > 0) {
                    return;
                }
                this.readerState.readBuffer.flip();
                this.readerState.command.read(this.readerState.readBuffer);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Received command: " + this.readerState.command);
                }
                ChannelControlBlock ccb = null;
                switch (this.readerState.command.getCommandType()) {
                    case ADD_CREDITS: {
                        ccb = this.readerState.getCCBInCommand();
                        ccb.addWriteCredits(this.readerState.command.getData());
                        break;
                    }
                    case CLOSE_CHANNEL: {
                        ccb = this.readerState.getCCBInCommand();
                        ccb.reportRemoteEOS();
                        int channelId = ccb.getChannelId();
                        this.cSet.markEOSAck(channelId);
                        this.cSet.unmarkPendingCredits(channelId);
                        break;
                    }
                    case CLOSE_CHANNEL_ACK: {
                        ccb = this.readerState.getCCBInCommand();
                        ccb.reportLocalEOSAck();
                        break;
                    }
                    case DATA: {
                        ccb = this.readerState.getCCBInCommand();
                        this.readerState.pendingReadSize = this.readerState.command.getData();
                        this.readerState.ccb = ccb;
                        break;
                    }
                    case ERROR: {
                        ccb = this.readerState.getCCBInCommand();
                        ccb.reportRemoteError(this.readerState.command.getData());
                        int channelId = ccb.getChannelId();
                        this.cSet.markEOSAck(channelId);
                        this.cSet.unmarkPendingCredits(channelId);
                        break;
                    }
                    case OPEN_CHANNEL: {
                        int channelId = this.readerState.command.getChannelId();
                        ccb = this.cSet.registerChannel(channelId);
                        this.muxDemux.getChannelOpenListener().channelOpened(ccb);
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Applied command: " + this.readerState.command + " on " + ccb);
                }
            }
            if (this.readerState.pendingReadSize > 0) {
                ++chunksRead;
                int newPendingReadSize = this.readerState.ccb.read(sc, this.readerState.pendingReadSize);
                this.muxDemux.getPerformanceCounters().addPayloadBytesRead(this.readerState.pendingReadSize - newPendingReadSize);
                this.readerState.pendingReadSize = newPendingReadSize;
                if (this.readerState.pendingReadSize > 0) {
                    return;
                }
            }
            this.readerState.reset();
        }
    }

    public IChannelInterfaceFactory getChannelInterfaceFactory() {
        return this.muxDemux.getChannelInterfaceFactory();
    }

    class ReaderState {
        private final ByteBuffer readBuffer = ByteBuffer.allocateDirect(8);
        final MuxDemuxCommand command = new MuxDemuxCommand();
        private int pendingReadSize;
        private ChannelControlBlock ccb;

        ReaderState() {
        }

        void reset() {
            this.readBuffer.clear();
            this.pendingReadSize = 0;
            this.ccb = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChannelControlBlock getCCBInCommand() {
            MultiplexedConnection multiplexedConnection = MultiplexedConnection.this;
            synchronized (multiplexedConnection) {
                return MultiplexedConnection.this.cSet.getCCB(this.command.getChannelId());
            }
        }
    }

    class WriterState
    implements IConnectionWriterState {
        private final ByteBuffer cmdWriteBuffer = ByteBuffer.allocateDirect(8);
        final MuxDemuxCommand command;
        private ByteBuffer pendingBuffer;
        private int pendingWriteSize;
        private IChannelControlBlock ccb;

        public WriterState() {
            this.cmdWriteBuffer.flip();
            this.command = new MuxDemuxCommand();
            this.ccb = null;
        }

        boolean writePending() {
            return this.cmdWriteBuffer.remaining() > 0 || this.pendingBuffer != null && this.pendingWriteSize > 0;
        }

        public void reset(ByteBuffer pendingBuffer, int pendingWriteSize, IChannelControlBlock ccb) {
            this.cmdWriteBuffer.clear();
            this.command.write(this.cmdWriteBuffer);
            this.cmdWriteBuffer.flip();
            this.pendingBuffer = pendingBuffer;
            this.pendingWriteSize = pendingWriteSize;
            this.ccb = ccb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean performPendingWrite(SocketChannel sc) throws IOException {
            int len = this.cmdWriteBuffer.remaining();
            if (len > 0) {
                int written = sc.write(this.cmdWriteBuffer);
                MultiplexedConnection.this.muxDemux.getPerformanceCounters().addSignalingBytesWritten(written);
                if (written < len) {
                    return false;
                }
            }
            if (this.pendingBuffer != null) {
                if (this.pendingWriteSize > 0) {
                    assert (this.pendingWriteSize <= this.pendingBuffer.remaining());
                    int oldLimit = this.pendingBuffer.limit();
                    try {
                        this.pendingBuffer.limit(this.pendingWriteSize + this.pendingBuffer.position());
                        int written = sc.write(this.pendingBuffer);
                        MultiplexedConnection.this.muxDemux.getPerformanceCounters().addPayloadBytesWritten(written);
                        this.pendingWriteSize -= written;
                    }
                    finally {
                        this.pendingBuffer.limit(oldLimit);
                    }
                }
                if (this.pendingWriteSize > 0) {
                    return false;
                }
                this.pendingBuffer = null;
                this.pendingWriteSize = 0;
            }
            if (this.ccb != null) {
                this.ccb.writeComplete();
                this.ccb = null;
            }
            return true;
        }

        public MuxDemuxCommand getCommand() {
            return this.command;
        }
    }
}

