/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public class UTF8CharSequence
implements CharSequence {
    private char[] buf;
    private int length;

    @Override
    public char charAt(int index) {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException("No index " + index + " for string of length " + this.length);
        }
        return this.buf[index];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        UTF8CharSequence carSeq = new UTF8CharSequence();
        carSeq.length = end - start;
        if (end != start) {
            carSeq.buf = new char[carSeq.length];
            System.arraycopy(this.buf, start, carSeq.buf, 0, carSeq.length);
        }
        return carSeq;
    }

    public void reset(UTF8StringPointable valuePtr) {
        int utfLen = valuePtr.getUTF8Length();
        if (this.buf == null || this.buf.length < utfLen) {
            this.buf = new char[utfLen];
        }
        int charPos = 0;
        for (int bytePos = 0; bytePos < utfLen; bytePos += valuePtr.charSize(valuePtr.getMetaDataLength() + bytePos)) {
            this.buf[charPos++] = valuePtr.charAt(valuePtr.getMetaDataLength() + bytePos);
        }
        this.length = charPos;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.length);
    }
}

