/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class ByteArrayAccessibleOutputStream
extends ByteArrayOutputStream {
    public ByteArrayAccessibleOutputStream() {
    }

    public ByteArrayAccessibleOutputStream(int size) {
        super(size);
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    public void rewindPositionBy(int delta) {
        if (delta < 0 || this.count < delta) {
            throw new IndexOutOfBoundsException();
        }
        this.count -= delta;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    public int getLength() {
        return this.count;
    }

    public void setSize(int bytesRequired) {
        this.ensureCapacity(bytesRequired);
        this.count = bytesRequired;
    }
}

