/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.GrowableArray;

public class ArrayBackedValueStorage
implements IMutableValueStorage {
    private final GrowableArray data = new GrowableArray();

    @Override
    public void reset() {
        this.data.reset();
    }

    @Override
    public DataOutput getDataOutput() {
        return this.data.getDataOutput();
    }

    @Override
    public byte[] getByteArray() {
        return this.data.getByteArray();
    }

    @Override
    public int getStartOffset() {
        return 0;
    }

    @Override
    public int getLength() {
        return this.data.getLength();
    }

    public void append(IValueReference value) {
        try {
            this.data.append(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void assign(IValueReference value) {
        this.reset();
        this.append(value);
    }

    public void setSize(int bytesRequired) {
        this.data.setSize(bytesRequired);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayBackedValueStorage)) {
            return false;
        }
        ArrayBackedValueStorage other = (ArrayBackedValueStorage)obj;
        return Objects.equals(this.data, other.data);
    }
}

